/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class FilterStringGroupColEqualStringGroupColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;

    public FilterStringGroupColEqualStringGroupColumn(int colNum1, int colNum2) {
        super(colNum1, colNum2, -1);
    }

    public FilterStringGroupColEqualStringGroupColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector1 = (BytesColumnVector)batch.cols[this.inputColumnNum[0]];
        BytesColumnVector inputColVector2 = (BytesColumnVector)batch.cols[this.inputColumnNum[1]];
        int[] sel = batch.selected;
        boolean[] nullPos1 = inputColVector1.isNull;
        boolean[] nullPos2 = inputColVector2.isNull;
        byte[][] vector1 = inputColVector1.vector;
        byte[][] vector2 = inputColVector2.vector;
        int[] start1 = inputColVector1.start;
        int[] start2 = inputColVector2.start;
        int[] length1 = inputColVector1.length;
        int[] length2 = inputColVector2.length;
        if (inputColVector1.noNulls && inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (!StringExpr.equal(vector1[0], start1[0], length1[0], vector2[0], start2[0], length2[0])) {
                    batch.size = 0;
                }
            } else if (inputColVector1.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (!StringExpr.equal(vector1[0], start1[0], length1[0], vector2[i], start2[i], length2[i])) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (!StringExpr.equal(vector1[0], start1[0], length1[0], vector2[i], start2[i], length2[i])) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (!StringExpr.equal(vector1[i], start1[i], length1[i], vector2[0], start2[0], length2[0])) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (!StringExpr.equal(vector1[i], start1[i], length1[i], vector2[0], start2[0], length2[0])) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!StringExpr.equal(vector1[i], start1[i], length1[i], vector2[i], start2[i], length2[i])) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (!StringExpr.equal(vector1[i], start1[i], length1[i], vector2[i], start2[i], length2[i])) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector1.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (nullPos2[0] || !StringExpr.equal(vector1[0], start1[0], length1[0], vector2[0], start2[0], length2[0])) {
                    batch.size = 0;
                }
            } else if (inputColVector1.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (nullPos2[i] || !StringExpr.equal(vector1[0], start1[0], length1[0], vector2[i], start2[i], length2[i])) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (nullPos2[i] || !StringExpr.equal(vector1[0], start1[0], length1[0], vector2[i], start2[i], length2[i])) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (nullPos2[0]) {
                    batch.size = 0;
                    return;
                }
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (!StringExpr.equal(vector1[i], start1[i], length1[i], vector2[0], start2[0], length2[0])) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (!StringExpr.equal(vector1[i], start1[i], length1[i], vector2[0], start2[0], length2[0])) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos2[i] || !StringExpr.equal(vector1[i], start1[i], length1[i], vector2[i], start2[i], length2[i])) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos2[i] || !StringExpr.equal(vector1[i], start1[i], length1[i], vector2[i], start2[i], length2[i])) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (nullPos1[0] || !StringExpr.equal(vector1[0], start1[0], length1[0], vector2[0], start2[0], length2[0])) {
                    batch.size = 0;
                    return;
                }
            } else if (inputColVector1.isRepeating) {
                if (nullPos1[0]) {
                    batch.size = 0;
                    return;
                }
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (!StringExpr.equal(vector1[0], start1[0], length1[0], vector2[i], start2[i], length2[i])) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (!StringExpr.equal(vector1[0], start1[0], length1[0], vector2[i], start2[i], length2[i])) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (nullPos1[i] || !StringExpr.equal(vector1[i], start1[i], length1[i], vector2[0], start2[0], length2[0])) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (nullPos1[i] || !StringExpr.equal(vector1[i], start1[i], length1[i], vector2[0], start2[0], length2[0])) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos1[i] || !StringExpr.equal(vector1[i], start1[i], length1[i], vector2[i], start2[i], length2[i])) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos1[i] || !StringExpr.equal(vector1[i], start1[i], length1[i], vector2[i], start2[i], length2[i])) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            if (nullPos1[0] || nullPos2[0] || !StringExpr.equal(vector1[0], start1[0], length1[0], vector2[0], start2[0], length2[0])) {
                batch.size = 0;
            }
        } else if (inputColVector1.isRepeating) {
            if (nullPos1[0]) {
                batch.size = 0;
                return;
            }
            if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos2[i] || !StringExpr.equal(vector1[0], start1[0], length1[0], vector2[i], start2[i], length2[i])) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos2[i] || !StringExpr.equal(vector1[0], start1[0], length1[0], vector2[i], start2[i], length2[i])) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (nullPos2[0]) {
                batch.size = 0;
                return;
            }
            if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos1[i] || !StringExpr.equal(vector1[i], start1[i], length1[i], vector2[0], start2[0], length2[0])) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos1[i] || !StringExpr.equal(vector1[i], start1[i], length1[i], vector2[0], start2[0], length2[0])) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos1[i] || nullPos2[i] || !StringExpr.equal(vector1[i], start1[i], length1[i], vector2[i], start2[i], length2[i])) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos1[i] || nullPos2[i] || !StringExpr.equal(vector1[i], start1[i], length1[i], vector2[i], start2[i], length2[i])) continue;
                sel[newSize++] = i;
            }
            if (newSize < batch.size) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", " + this.getColumnParamString(1, this.inputColumnNum[1]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

