/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class FilterDecimalColumnNotBetween
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private HiveDecimal leftValue;
    private HiveDecimal rightValue;

    public FilterDecimalColumnNotBetween(int colNum, HiveDecimal leftValue, HiveDecimal rightValue) {
        super(colNum, -1);
        this.leftValue = leftValue;
        this.rightValue = rightValue;
    }

    public FilterDecimalColumnNotBetween() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DecimalColumnVector inputColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum[0]];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        HiveDecimalWritable[] vector = inputColVector.vector;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (DecimalUtil.compare(vector[0], this.leftValue) >= 0 && DecimalUtil.compare(vector[0], this.rightValue) <= 0) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (DecimalUtil.compare(this.leftValue, vector[i]) <= 0 && DecimalUtil.compare(vector[i], this.rightValue) <= 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (DecimalUtil.compare(this.leftValue, vector[i]) <= 0 && DecimalUtil.compare(vector[i], this.rightValue) <= 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!inputIsNull[0]) {
                if (DecimalUtil.compare(vector[0], this.leftValue) >= 0 && DecimalUtil.compare(vector[0], this.rightValue) <= 0) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (inputIsNull[i] || DecimalUtil.compare(this.leftValue, vector[i]) <= 0 && DecimalUtil.compare(vector[i], this.rightValue) <= 0) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (inputIsNull[i] || DecimalUtil.compare(this.leftValue, vector[i]) <= 0 && DecimalUtil.compare(vector[i], this.rightValue) <= 0) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    public HiveDecimal getLeftValue() {
        return this.leftValue;
    }

    public void setLeftValue(HiveDecimal value) {
        this.leftValue = value;
    }

    public HiveDecimal getRightValue() {
        return this.rightValue;
    }

    public void setRightValue(HiveDecimal value) {
        this.rightValue = value;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", left " + this.leftValue.toString() + ", right " + this.rightValue.toString();
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(3).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"decimal"), VectorExpressionDescriptor.ArgumentType.getType((String)"decimal"), VectorExpressionDescriptor.ArgumentType.getType((String)"decimal")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }
}

