/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import hiveexec.com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class VectorCoalesce
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private transient int[] unassignedBatchIndices;

    public VectorCoalesce(int[] inputColumns, int outputColumnNum) {
        super(inputColumns, outputColumnNum);
        Preconditions.checkArgument(inputColumns.length > 0);
    }

    public VectorCoalesce() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        int[] sel = batch.selected;
        int n = batch.size;
        ColumnVector outputColVector = batch.cols[this.outputColumnNum];
        boolean[] outputIsNull = outputColVector.isNull;
        if (n <= 0) {
            return;
        }
        if (this.unassignedBatchIndices == null || n > this.unassignedBatchIndices.length) {
            int roundUpSize = (n + 1024 - 1) / 1024 * 1024;
            this.unassignedBatchIndices = new int[roundUpSize];
        }
        outputColVector.isRepeating = false;
        outputColVector.init();
        int columnCount = this.inputColumnNum.length;
        boolean isAllUnassigned = true;
        int unassignedColumnCount = 0;
        for (int k = 0; k < this.inputColumnNum.length; ++k) {
            boolean[] inputIsNull;
            int batchIndex;
            ColumnVector cv = batch.cols[this.inputColumnNum[k]];
            if (cv.isRepeating) {
                if (!cv.noNulls && cv.isNull[0]) continue;
                if (isAllUnassigned) {
                    outputIsNull[0] = false;
                    outputColVector.setElement(0, 0, cv);
                    outputColVector.isRepeating = true;
                    return;
                }
                for (int i = 0; i < unassignedColumnCount; ++i) {
                    batchIndex = this.unassignedBatchIndices[i];
                    outputIsNull[batchIndex] = false;
                    outputColVector.setElement(batchIndex, 0, cv);
                }
                return;
            }
            if (isAllUnassigned) {
                if (cv.noNulls) {
                    if (batch.selectedInUse) {
                        for (int i = 0; i < n; ++i) {
                            batchIndex = sel[i];
                            outputIsNull[batchIndex] = false;
                            outputColVector.setElement(batchIndex, batchIndex, cv);
                        }
                    } else {
                        Arrays.fill(outputIsNull, 0, n, false);
                        for (int batchIndex2 = 0; batchIndex2 < n; ++batchIndex2) {
                            outputColVector.setElement(batchIndex2, batchIndex2, cv);
                        }
                    }
                    return;
                }
                inputIsNull = cv.isNull;
                if (batch.selectedInUse) {
                    for (int i = 0; i < n; ++i) {
                        int batchIndex3 = sel[i];
                        if (!inputIsNull[batchIndex3]) {
                            outputIsNull[batchIndex3] = false;
                            outputColVector.setElement(batchIndex3, batchIndex3, cv);
                            continue;
                        }
                        this.unassignedBatchIndices[unassignedColumnCount++] = batchIndex3;
                    }
                } else {
                    for (batchIndex = 0; batchIndex < n; ++batchIndex) {
                        if (!inputIsNull[batchIndex]) {
                            outputIsNull[batchIndex] = false;
                            outputColVector.setElement(batchIndex, batchIndex, cv);
                            continue;
                        }
                        this.unassignedBatchIndices[unassignedColumnCount++] = batchIndex;
                    }
                }
                if (unassignedColumnCount == 0) {
                    return;
                }
                isAllUnassigned = false;
                continue;
            }
            if (cv.noNulls) {
                for (int i = 0; i < unassignedColumnCount; ++i) {
                    batchIndex = this.unassignedBatchIndices[i];
                    outputIsNull[batchIndex] = false;
                    outputColVector.setElement(batchIndex, batchIndex, cv);
                }
                return;
            }
            inputIsNull = cv.isNull;
            int newUnassignedColumnCount = 0;
            for (int i = 0; i < unassignedColumnCount; ++i) {
                int batchIndex4 = this.unassignedBatchIndices[i];
                if (!inputIsNull[batchIndex4]) {
                    outputIsNull[batchIndex4] = false;
                    outputColVector.setElement(batchIndex4, batchIndex4, cv);
                    continue;
                }
                this.unassignedBatchIndices[newUnassignedColumnCount++] = batchIndex4;
            }
            if (newUnassignedColumnCount == 0) {
                return;
            }
            unassignedColumnCount = newUnassignedColumnCount;
        }
        outputColVector.noNulls = false;
        if (isAllUnassigned) {
            outputIsNull[0] = true;
            outputColVector.isRepeating = true;
        } else {
            for (int i = 0; i < unassignedColumnCount; ++i) {
                int batchIndex = this.unassignedBatchIndices[i];
                outputIsNull[batchIndex] = true;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return "columns " + Arrays.toString(this.inputColumnNum);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        throw new UnsupportedOperationException("Undefined descriptor");
    }
}

