/*
 * Decompiled with CFR 0.152.
 */
package hiveexec.com.google.common.cache;

import hiveexec.com.google.common.annotations.GwtCompatible;
import hiveexec.com.google.common.base.Preconditions;
import hiveexec.com.google.common.cache.ElementTypesAreNonnullByDefault;
import hiveexec.com.google.common.cache.RemovalCause;
import java.util.AbstractMap;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class RemovalNotification<K, V>
extends AbstractMap.SimpleImmutableEntry<K, V> {
    private final RemovalCause cause;
    private static final long serialVersionUID = 0L;

    public static <K, V> RemovalNotification<K, V> create(@CheckForNull K key, @CheckForNull V value, RemovalCause cause) {
        return new RemovalNotification<K, V>(key, value, cause);
    }

    private RemovalNotification(@CheckForNull K key, @CheckForNull V value, RemovalCause cause) {
        super(key, value);
        this.cause = Preconditions.checkNotNull(cause);
    }

    public RemovalCause getCause() {
        return this.cause;
    }

    public boolean wasEvicted() {
        return this.cause.wasEvicted();
    }
}

