/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import hiveexec.com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HiveTestUtils {
    public static final Logger LOG = LoggerFactory.getLogger(HiveTestUtils.class);
    public static final String JAVA_FILE_EXT = ".java";
    public static final String CLAZZ_FILE_EXT = ".class";
    public static final String JAR_FILE_EXT = ".jar";
    public static final String TXT_FILE_EXT = ".txt";

    public static String getFileFromClasspath(String name) {
        URL url = ClassLoader.getSystemResource(name);
        if (url == null) {
            throw new IllegalArgumentException("Could not find " + name);
        }
        return url.getPath();
    }

    private static void executeCmd(String[] cmdArr, File dir) throws IOException, InterruptedException {
        final Process p1 = Runtime.getRuntime().exec(cmdArr, null, dir);
        new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader input = new BufferedReader(new InputStreamReader(p1.getErrorStream()));
                try {
                    String line;
                    while ((line = input.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (IOException e) {
                    LOG.error("Failed to execute the command due the exception " + e);
                }
            }
        }).start();
        p1.waitFor();
    }

    public static File genLocalJarForTest(String pathToClazzFile, String clazzName) throws IOException, InterruptedException {
        return HiveTestUtils.genLocalJarForTest(pathToClazzFile, clazzName, new HashMap<File, String>());
    }

    public static File genLocalJarForTest(String pathToClazzFile, String clazzName, Map<File, String> extraContent) throws IOException, InterruptedException {
        String u = pathToClazzFile;
        File dir = new File(u);
        File parentDir = dir.getParentFile();
        File f = new File(parentDir, clazzName + JAVA_FILE_EXT);
        Files.copy(dir, f);
        HiveTestUtils.executeCmd(new String[]{"javac", clazzName + JAVA_FILE_EXT}, parentDir);
        f.delete();
        File outputJar = new File(parentDir, clazzName + JAR_FILE_EXT);
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outputJar));
        String contentClassName = clazzName + CLAZZ_FILE_EXT;
        zos.putNextEntry(new ZipEntry(contentClassName));
        IOUtils.copy((InputStream)new FileInputStream(new File(parentDir, contentClassName)), (OutputStream)zos);
        zos.closeEntry();
        for (Map.Entry<File, String> entry : extraContent.entrySet()) {
            zos.putNextEntry(new ZipEntry(entry.getKey().toString()));
            zos.write(entry.getValue().getBytes());
            zos.closeEntry();
        }
        zos.close();
        new File(parentDir, contentClassName).delete();
        return outputJar;
    }
}

