/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.SingleValueBoundaryScanner;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

class CharValueBoundaryScanner
extends SingleValueBoundaryScanner {
    public CharValueBoundaryScanner(BoundaryDef start, BoundaryDef end, OrderExpressionDef expressionDef, boolean nullsLast) {
        super(start, end, expressionDef, nullsLast);
    }

    @Override
    public boolean isDistanceGreater(Object v1, Object v2, int amt) {
        HiveChar s1 = PrimitiveObjectInspectorUtils.getHiveChar(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
        HiveChar s2 = PrimitiveObjectInspectorUtils.getHiveChar(v2, (PrimitiveObjectInspector)this.expressionDef.getOI());
        return s1 != null && s2 != null && s1.compareTo(s2) > 0;
    }

    @Override
    public boolean isEqual(Object v1, Object v2) {
        HiveChar s1 = PrimitiveObjectInspectorUtils.getHiveChar(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
        HiveChar s2 = PrimitiveObjectInspectorUtils.getHiveChar(v2, (PrimitiveObjectInspector)this.expressionDef.getOI());
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }
}

