/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveResourceACLs;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@Description(name="split_map_privs", value="_FUNC_(str) - Splits binary str and maps to privilege type regex", extended="Example:\n  > SELECT _FUNC_('0 1 1 0 1 1 0 0 0') FROM src LIMIT 1;\n  [\"UPDATE\", \"CREATE\", \"ALTER\", \"INDEX\"]")
public class GenericUDFStringToPrivilege
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[1];
    private List<HiveResourceACLs.Privilege> privilegesList = Arrays.asList(HiveResourceACLs.Privilege.values());

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 1, 1);
        this.checkArgPrimitive(arguments, 0);
        this.converters[0] = ObjectInspectorConverters.getConverter(arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        return ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        assert (arguments.length == 1);
        if (arguments[0].get() == null) {
            return null;
        }
        Text s = (Text)this.converters[0].convert(arguments[0].get());
        ArrayList<Text> result = new ArrayList<Text>();
        int index = 0;
        for (String str : s.toString().split(" ", -1)) {
            if ("1".equals(str)) {
                result.add(new Text(String.valueOf(this.privilegesList.get(index))));
            }
            ++index;
        }
        return result;
    }

    @Override
    protected String getFuncName() {
        return "split_map_privs";
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        return this.getStandardDisplayString("split_map_privs", children);
    }
}

