/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import hiveexec.com.google.re2j.Matcher;
import hiveexec.com.google.re2j.Pattern;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColRegExpStringScalar;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="rlike,regexp", value="str _FUNC_ regexp - Returns true if str matches regexp and false otherwise", extended="Example:\n  > SELECT 'fb' _FUNC_ '.*' FROM src LIMIT 1;\n  true")
@VectorizedExpressions(value={FilterStringColRegExpStringScalar.class})
public class GenericUDFRegExp
extends GenericUDF {
    static final Logger LOG = LoggerFactory.getLogger((String)GenericUDFRegExp.class.getName());
    private transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[2];
    private transient ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[2];
    private final BooleanWritable output = new BooleanWritable();
    private transient boolean isRegexConst;
    private transient String regexConst;
    private transient boolean warned;
    private transient java.util.regex.Pattern patternConst;
    private transient Pattern patternConstR2j;
    private boolean useGoogleRegexEngine = false;

    @Override
    public void configure(MapredContext context) {
        if (context != null && context.getJobConf().get("hive.use.googleregex.engine").equals("true")) {
            this.useGoogleRegexEngine = true;
        }
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        SessionState ss = SessionState.get();
        if (ss != null) {
            this.useGoogleRegexEngine = ss.getConf().getBoolVar(HiveConf.ConfVars.HIVEUSEGOOGLEREGEXENGINE);
        }
        this.checkArgsSize(arguments, 2, 2);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgPrimitive(arguments, 1);
        this.checkArgGroups(arguments, 0, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP);
        this.checkArgGroups(arguments, 1, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP);
        this.obtainStringConverter(arguments, 0, this.inputTypes, this.converters);
        this.obtainStringConverter(arguments, 1, this.inputTypes, this.converters);
        if (arguments[1] instanceof ConstantObjectInspector) {
            this.regexConst = this.getConstantStringValue(arguments, 1);
            if (this.regexConst != null) {
                if (!this.useGoogleRegexEngine) {
                    this.patternConst = java.util.regex.Pattern.compile(this.regexConst);
                } else {
                    this.patternConstR2j = Pattern.compile(this.regexConst);
                }
            }
            this.isRegexConst = true;
        }
        WritableBooleanObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        String s = this.getStringValue(arguments, 0, this.converters);
        if (s == null) {
            return null;
        }
        String regex = this.isRegexConst ? this.regexConst : this.getStringValue(arguments, 1, this.converters);
        if (regex == null) {
            return null;
        }
        if (regex.length() == 0) {
            if (!this.warned) {
                this.warned = true;
                LOG.warn(this.getClass().getSimpleName() + " regex is empty. Additional warnings for an empty regex will be suppressed.");
            }
            this.output.set(false);
            return this.output;
        }
        if (!this.useGoogleRegexEngine) {
            java.util.regex.Pattern p = this.isRegexConst ? this.patternConst : java.util.regex.Pattern.compile(regex);
            java.util.regex.Matcher m = p.matcher(s);
            this.output.set(m.find(0));
            return this.output;
        }
        Pattern patternR2j = this.isRegexConst ? this.patternConstR2j : Pattern.compile(regex);
        Matcher m = patternR2j.matcher(s);
        this.output.set(m.find(0));
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return children[0] + " regexp " + children[1];
    }

    @Override
    protected String getFuncName() {
        return "regexp";
    }
}

