/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLTrimCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLTrimColScalar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseTrim;

@Description(name="ltrim", value="_FUNC_(str[, chars]) - Removes the leading pad characters from str ", extended="Example:\n  > SELECT _FUNC_('   facebook') FROM src LIMIT 1;\n  'facebook'\n  > SELECT _FUNC_('xyzzxyfacebook', 'zyx') FROM src LIMIT 1;\n  'facebook'")
@VectorizedExpressions(value={StringLTrimCol.class, StringLTrimColScalar.class})
public class GenericUDFLTrim
extends GenericUDFBaseTrim {
    public GenericUDFLTrim() {
        super("ltrim");
    }

    @Override
    protected String performOp(String val, String trimChars) {
        return StringUtils.stripStart((String)val, (String)trimChars);
    }
}

