/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantStringObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="exception_in_vertex_udf", value="_FUNC_(hintColumn, vertexName, taskNumberExpression, taskAttemptNumberExpressionThrows exception in Map tasks, where UDF running is possible", extended="hintColumn is needed for easy-locating mapper stage please refer to full examples and explanation in exception_in_vertex_udf.q: exception_in_vertex_udf (src1.value, 'Map 1', 0, 0)          -> Map1, first task, first attemptexception_in_vertex_udf (src1.value, 'Map 1', '0,1,2', '*')  -> Map1, tasks: 0,1,2, all attemptsexception_in_vertex_udf (src1.value, 'Map 1', '*', 0)        -> Map1, all tasks, first attemptexception_in_vertex_udf (src1.value, 'Map 1', '0-2', '*')    -> Map1, tasks: 0,1,2, all attemptsexception_in_vertex_udf (src1.value, 'Map 1', '*', '*')      -> Map1, all tasks, all attemptsexception_in_vertex_udf (src1.value, 'Map 1', '*')           -> Map1, all tasks, all attemptsexception_in_vertex_udf (src1.value, 'Map 1')                -> Map1, all tasks, all attempts")
public class GenericUDFExceptionInVertex
extends GenericUDF {
    private static final Logger LOG = LoggerFactory.getLogger(GenericUDFExceptionInVertex.class);
    private String vertexName;
    private String taskNumberExpr;
    private String taskAttemptNumberExpr;
    private String currentVertexName;
    private int currentTaskNumber;
    private int currentTaskAttemptNumber;
    private boolean alreadyCheckedAndPassed;

    @Override
    public ObjectInspector initialize(ObjectInspector[] parameters) throws UDFArgumentException {
        if (parameters.length < 2) {
            throw new UDFArgumentTypeException(-1, "At least two argument is expected (fake column ref, vertex name)");
        }
        this.vertexName = GenericUDFExceptionInVertex.getVertexName(parameters, 1);
        this.taskNumberExpr = GenericUDFExceptionInVertex.getTaskNumber(parameters, 2);
        this.taskAttemptNumberExpr = GenericUDFExceptionInVertex.getTaskAttemptNumber(parameters, 3);
        return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
    }

    public static String getVertexName(ObjectInspector[] parameters, int index) {
        return ((WritableConstantStringObjectInspector)parameters[index]).getWritableConstantValue().toString();
    }

    public static String getTaskNumber(ObjectInspector[] parameters, int index) {
        return GenericUDFExceptionInVertex.getExpressionAtIndex(parameters, index);
    }

    public static String getTaskAttemptNumber(ObjectInspector[] parameters, int index) {
        return GenericUDFExceptionInVertex.getExpressionAtIndex(parameters, index);
    }

    private static String getExpressionAtIndex(ObjectInspector[] parameters, int index) {
        if (parameters.length > index) {
            if (parameters[index] instanceof WritableConstantStringObjectInspector) {
                return ((WritableConstantStringObjectInspector)parameters[index]).getWritableConstantValue().toString();
            }
            return ((WritableConstantIntObjectInspector)parameters[index]).getWritableConstantValue().toString();
        }
        return "*";
    }

    public static boolean numberFitsExpression(int number, String expression) {
        if (expression.contains("-")) {
            int min = Integer.parseInt(expression.split("-")[0]);
            int max = Integer.parseInt(expression.split("-")[1]);
            return number <= max && number >= min;
        }
        if (expression.contains(",")) {
            List numbers = Arrays.asList(expression.split(",")).stream().map(x -> Integer.valueOf(x)).collect(Collectors.toList());
            return numbers.contains(number);
        }
        if ("*".equals(expression)) {
            return true;
        }
        return Integer.parseInt(expression) == number;
    }

    @Override
    public void configure(MapredContext mapredContext) {
        this.currentVertexName = mapredContext.getJobConf().get("hive.tez.vertex.name");
        this.currentTaskNumber = mapredContext.getJobConf().getInt("hive.tez.task.index", -1);
        this.currentTaskAttemptNumber = mapredContext.getJobConf().getInt("hive.tez.task.attempt.number", -1);
        LOG.debug("configure vertex: {}, task: {}, attempt: {} <-> current vertex {}, task: {}, attempt: {}", new Object[]{this.vertexName, this.taskNumberExpr, this.taskAttemptNumberExpr, this.currentVertexName, this.currentTaskNumber, this.currentTaskAttemptNumber});
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (this.alreadyCheckedAndPassed) {
            return 0L;
        }
        LOG.debug("evaluate: vertex {}, task: {}, attempt: {} <-> vertex {}, task: {}, attempt: {}", new Object[]{this.currentVertexName, this.currentTaskNumber, this.currentTaskAttemptNumber, this.vertexName, this.taskNumberExpr, this.taskAttemptNumberExpr});
        if (this.vertexName.equals(this.currentVertexName) && GenericUDFExceptionInVertex.numberFitsExpression(this.currentTaskNumber, this.taskNumberExpr) && GenericUDFExceptionInVertex.numberFitsExpression(this.currentTaskAttemptNumber, this.taskAttemptNumberExpr)) {
            String message = String.format("GenericUDFExceptionInVertex: found condition for throwing exception (vertex/task/attempt):current %s / %d / %d matches criteria %s / %s / %s", this.currentVertexName, this.currentTaskNumber, this.currentTaskAttemptNumber, this.vertexName, this.taskNumberExpr, this.taskAttemptNumberExpr);
            LOG.info(message);
            throw new HiveException(message);
        }
        this.alreadyCheckedAndPassed = true;
        return 0L;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("GenericUDFExceptionInVertex", children, ",");
    }
}

