/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.Text;

@Description(name="date_format", value="_FUNC_(date/timestamp/string, fmt) - converts a date/timestamp/string to a value of string in the format specified by the date format fmt.", extended="Supported formats are DateTimeFormatter formats - https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html. Second argument fmt should be constant.\nExample: > SELECT _FUNC_('2015-04-08', 'y');\n '2015'")
public class GenericUDFDateFormat
extends GenericUDF {
    private final transient ObjectInspectorConverters.Converter[] tsConverters = new ObjectInspectorConverters.Converter[2];
    private final transient PrimitiveObjectInspector.PrimitiveCategory[] tsInputTypes = new PrimitiveObjectInspector.PrimitiveCategory[2];
    private final Text output = new Text();
    private transient ZoneId timeZone;
    private transient DateTimeFormatter formatter;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 2, 2);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgPrimitive(arguments, 1);
        this.checkArgGroups(arguments, 0, this.tsInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP);
        this.checkArgGroups(arguments, 1, this.tsInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP);
        this.obtainTimestampConverter(arguments, 0, this.tsInputTypes, this.tsConverters);
        if (arguments[1] instanceof ConstantObjectInspector) {
            String fmtStr = this.getConstantStringValue(arguments, 1);
            if (fmtStr != null) {
                try {
                    if (this.timeZone == null) {
                        this.timeZone = SessionState.get() == null ? new HiveConf().getLocalTimeZone() : SessionState.get().getConf().getLocalTimeZone();
                    }
                    this.formatter = DateTimeFormatter.ofPattern(fmtStr);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else {
            throw new UDFArgumentTypeException(1, this.getFuncName() + " only takes constant as " + this.getArgOrder(1) + " argument");
        }
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (this.formatter == null) {
            return null;
        }
        Timestamp ts = this.getTimestampValue(arguments, 0, this.tsConverters);
        if (ts == null) {
            return null;
        }
        Instant instant = Instant.ofEpochSecond(ts.toEpochSecond(), ts.getNanos());
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
        String res = this.formatter.format(zonedDateTime.withZoneSameLocal(this.timeZone));
        this.output.set(res);
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }

    @Override
    protected String getFuncName() {
        return "date_format";
    }
}

