/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import hiveexec.com.google.common.annotations.VisibleForTesting;
import hiveexec.com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.hive.common.format.datetime.HiveSqlDateTimeFormatter;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="cast_format", value="CAST(<value> AS <type> FORMAT <STRING>) - Converts a datetime value to string or string-type value to datetime based on the format pattern specified.", extended="If format is specified with FORMAT argument then SQL:2016 datetime formats will be used.\nExample:\n   > SELECT CAST(\"2018-01-01 4 PM\" AS timestamp FORMAT \"yyyy-mm-dd hh12 AM\");\n  2018-01-01 16:00:00")
public class GenericUDFCastFormat
extends GenericUDF
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger((String)GenericUDFCastFormat.class.getName());
    @VisibleForTesting
    static final Map<Integer, String> OUTPUT_TYPES = ImmutableMap.builder().put(1169, "string").put(1246, "varchar").put(882, "char").put(1216, "timestamp").put(918, "date").build();
    private transient HiveSqlDateTimeFormatter formatter;
    private transient PrimitiveObjectInspector outputOI;
    private transient PrimitiveObjectInspector inputOI;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 3 && arguments.length != 4) {
            throw new UDFArgumentException("Function cast_format requires 3 or 4 arguments (int, expression, StringLiteral[, var/char length]), got " + arguments.length);
        }
        this.outputOI = this.getOutputOI(arguments);
        try {
            this.inputOI = (PrimitiveObjectInspector)arguments[1];
        }
        catch (ClassCastException e) {
            throw new UDFArgumentException("Function CAST...as ... FORMAT ...takes only primitive types");
        }
        PrimitiveObjectInspectorUtils.PrimitiveGrouping inputPG = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(this.inputOI.getPrimitiveCategory());
        PrimitiveObjectInspectorUtils.PrimitiveGrouping outputPG = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(this.outputOI.getPrimitiveCategory());
        if (this.inputOI.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMPLOCALTZ) {
            throw new UDFArgumentException("Timestamp with local time zone not yet supported for cast ... format function");
        }
        if (!(inputPG == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && outputPG == PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP || inputPG == PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP && outputPG == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP || inputPG == PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP)) {
            throw new UDFArgumentException("Function CAST...as ... FORMAT ... only converts datetime objects to string types and string or void objects to datetime types. Type of object provided: " + (Object)((Object)this.outputOI.getPrimitiveCategory()) + " in primitive grouping " + (Object)((Object)inputPG) + ", type provided: " + (Object)((Object)this.inputOI.getPrimitiveCategory()) + " in primitive grouping " + (Object)((Object)outputPG));
        }
        boolean forParsing = outputPG == PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP;
        this.formatter = new HiveSqlDateTimeFormatter(this.getConstantStringValue(arguments, 2), forParsing);
        return this.outputOI;
    }

    private PrimitiveObjectInspector getOutputOI(ObjectInspector[] arguments) throws UDFArgumentException {
        int key = this.getConstantIntValue(arguments, 0);
        if (!OUTPUT_TYPES.keySet().contains(key)) {
            throw new UDFArgumentException("Cast...format can only convert to DATE, TIMESTAMP, STRING,VARCHAR, CHAR. Can't convert to HiveParser_IdentifiersParser constant with value " + key);
        }
        String typeString = OUTPUT_TYPES.get(key);
        if ("varchar".equals(typeString) || "char".equals(typeString)) {
            if (arguments.length < 4 || arguments[3] == null) {
                throw new UDFArgumentException(typeString + " missing length argument");
            }
            typeString = typeString + "(" + this.getConstantIntValue(arguments, 3) + ")";
        }
        PrimitiveTypeInfo typeInfo = TypeInfoFactory.getPrimitiveTypeInfo(typeString);
        return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(typeInfo);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object o0 = arguments[1].get();
        if (o0 == null) {
            return null;
        }
        return this.convert(o0);
    }

    private Object convert(Object o) throws HiveException {
        Object input;
        switch (this.inputOI.getPrimitiveCategory()) {
            case STRING: {
                input = ((StringObjectInspector)this.inputOI).getPrimitiveJavaObject(o);
                break;
            }
            case CHAR: {
                input = ((HiveCharObjectInspector)this.inputOI).getPrimitiveJavaObject(o).getStrippedValue();
                break;
            }
            case VARCHAR: {
                input = ((HiveVarcharObjectInspector)this.inputOI).getPrimitiveJavaObject(o).toString();
                break;
            }
            case TIMESTAMP: {
                input = ((TimestampObjectInspector)this.inputOI).getPrimitiveWritableObject(o).getTimestamp();
                break;
            }
            case DATE: {
                input = ((DateObjectInspector)this.inputOI).getPrimitiveWritableObject(o).get();
                break;
            }
            default: {
                throw new HiveException("Input type " + (Object)((Object)this.inputOI.getPrimitiveCategory()) + " not valid");
            }
        }
        String formattedOutput = null;
        if (this.inputOI.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.DATE || this.inputOI.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP) {
            if (this.inputOI.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.DATE) {
                try {
                    formattedOutput = this.formatter.format((Date)input);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            try {
                formattedOutput = this.formatter.format((Timestamp)input);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            if (formattedOutput == null) {
                return null;
            }
        }
        switch (this.outputOI.getPrimitiveCategory()) {
            case STRING: {
                return new Text(formattedOutput);
            }
            case CHAR: {
                return ((SettableHiveCharObjectInspector)this.outputOI).create(new HiveChar(formattedOutput, -1));
            }
            case VARCHAR: {
                return ((SettableHiveVarcharObjectInspector)this.outputOI).create(new HiveVarchar(formattedOutput, -1));
            }
            case TIMESTAMP: {
                try {
                    Timestamp t = this.formatter.parseTimestamp((String)input);
                    if (t == null) {
                        return null;
                    }
                    return ((SettableTimestampObjectInspector)this.outputOI).create(t);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            case DATE: {
                try {
                    Date d = this.formatter.parseDate((String)input);
                    if (d == null) {
                        return null;
                    }
                    return ((SettableDateObjectInspector)this.outputOI).create(d);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
        }
        throw new HiveException("Output type " + (Object)((Object)this.outputOI.getPrimitiveCategory()) + " not valid");
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 3 || children.length == 4);
        StringBuilder sb = new StringBuilder();
        sb.append("CAST( ");
        sb.append(children[1]);
        sb.append(" AS ");
        int typeKey = Integer.parseInt(children[0]);
        if (!OUTPUT_TYPES.keySet().contains(typeKey)) {
            sb.append("HiveParsers_IdentifiersParser index ").append(typeKey);
        } else {
            sb.append(OUTPUT_TYPES.get(typeKey));
            if (children.length == 4) {
                sb.append("(").append(children[3]).append(")");
            }
        }
        sb.append(" FORMAT ");
        sb.append(children[2]);
        sb.append(" )");
        return sb.toString();
    }
}

