/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

public abstract class GenericUDFBaseTrim
extends GenericUDF {
    public static final String DEFAULT_TRIM_CHARS = " ";
    private transient PrimitiveObjectInspectorConverter.TextConverter stringToTrimConverter;
    private transient PrimitiveObjectInspectorConverter.TextConverter trimCharsConverter;
    private Text result = new Text();
    private String udfName;

    public GenericUDFBaseTrim(String _udfName) {
        this.udfName = _udfName;
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1) {
            throw new UDFArgumentException(this.udfName + " requires at least one value argument. Found :" + arguments.length);
        }
        if (arguments.length > 2) {
            throw new UDFArgumentException(this.udfName + " requires no more than two value arguments. Found :" + arguments.length);
        }
        this.stringToTrimConverter = new PrimitiveObjectInspectorConverter.TextConverter(this.getArgumentObjectInspector(arguments[0]));
        this.trimCharsConverter = arguments.length == 2 ? new PrimitiveObjectInspectorConverter.TextConverter(this.getArgumentObjectInspector(arguments[1])) : null;
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    private PrimitiveObjectInspector getArgumentObjectInspector(ObjectInspector argument) throws UDFArgumentException {
        if (!(argument instanceof PrimitiveObjectInspector)) {
            throw new UDFArgumentException(this.udfName + " takes only primitive types. found " + argument.getTypeName());
        }
        PrimitiveObjectInspector argumentOI = (PrimitiveObjectInspector)argument;
        switch (argumentOI.getPrimitiveCategory()) {
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                break;
            }
            default: {
                throw new UDFArgumentException(this.udfName + " takes only STRING/CHAR/VARCHAR types. Found " + (Object)((Object)argumentOI.getPrimitiveCategory()));
            }
        }
        return argumentOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object valObject = arguments[0].get();
        if (valObject == null) {
            return null;
        }
        String val = this.stringToTrimConverter.convert(valObject).toString();
        if (val == null) {
            return null;
        }
        String trimChars = DEFAULT_TRIM_CHARS;
        if (this.trimCharsConverter != null && arguments.length == 2) {
            Object trimCharsObject = arguments[1].get();
            if (trimCharsObject == null) {
                return null;
            }
            trimChars = this.trimCharsConverter.convert(trimCharsObject).toString();
            if (trimChars == null) {
                return null;
            }
        }
        this.result.set(this.performOp(val, trimChars));
        return this.result;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.udfName, children);
    }

    protected abstract String performOp(String var1, String var2);
}

