/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.ISupportStreamingModeForWindowing;
import org.apache.hadoop.hive.ql.util.NullOrdering;
import org.apache.hadoop.hive.serde2.objectinspector.FullMapEqualComparer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantIntObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="rank", value="_FUNC_(x)")
@WindowFunctionDescription(supportsWindow=false, pivotResult=true, rankingFunction=true, orderedAggregate=true)
public class GenericUDAFRank
extends AbstractGenericUDAFResolver {
    static final Logger LOG = LoggerFactory.getLogger((String)GenericUDAFRank.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        if (info.isWindowing()) {
            return this.getWindowingEvaluator(info.getParameterObjectInspectors());
        }
        return this.getHypotheticalSetEvaluator(info.getParameterObjectInspectors());
    }

    private GenericUDAFEvaluator getWindowingEvaluator(ObjectInspector[] parameters) throws SemanticException {
        if (parameters.length < 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "One or more arguments are expected.");
        }
        for (int i = 0; i < parameters.length; ++i) {
            this.supportsCompare(parameters, i);
        }
        return this.createWindowingEvaluator();
    }

    protected GenericUDAFAbstractRankEvaluator createWindowingEvaluator() {
        return new GenericUDAFRankEvaluator();
    }

    private GenericUDAFEvaluator getHypotheticalSetEvaluator(ObjectInspector[] parameters) throws SemanticException {
        if (parameters.length % 4 != 0) {
            throw new UDFArgumentTypeException(parameters.length, "Invalid number of parameters: the number of hypothetical direct arguments must match the number of ordering columns");
        }
        for (int i = 0; i < parameters.length / 4; ++i) {
            this.supportsCompare(parameters, 4 * i);
            this.supportsCompare(parameters, 4 * i + 1);
        }
        return this.createHypotheticalSetEvaluator();
    }

    protected GenericUDAFHypotheticalSetRankEvaluator createHypotheticalSetEvaluator() {
        return new GenericUDAFHypotheticalSetRankEvaluator();
    }

    private void supportsCompare(ObjectInspector[] parameters, int i2) throws UDFArgumentTypeException {
        ObjectInspector oi = parameters[i2];
        if (!ObjectInspectorUtils.compareSupported(oi)) {
            throw new UDFArgumentTypeException(i2, "Cannot support comparison of map<> type or complex type containing map<>.");
        }
    }

    public static int compare(Object[] o1, ObjectInspector[] oi1, Object[] o2, ObjectInspector[] oi2) {
        int c = 0;
        for (int i = 0; i < oi1.length; ++i) {
            c = ObjectInspectorUtils.compare(o1[i], oi1[i], o2[i], oi2[i]);
            if (c == 0) continue;
            return c;
        }
        return c;
    }

    public static Object[] copyToStandardObject(Object[] o, ObjectInspector[] oi, ObjectInspectorUtils.ObjectInspectorCopyOption objectInspectorOption) {
        Object[] out = new Object[o.length];
        for (int i = 0; i < oi.length; ++i) {
            out[i] = ObjectInspectorUtils.copyToStandardObject(o[i], oi[i], objectInspectorOption);
        }
        return out;
    }

    public static class GenericUDAFHypotheticalSetRankEvaluator
    extends GenericUDAFEvaluator {
        public static final String RANK_FIELD = "rank";
        public static final String COUNT_FIELD = "count";
        public static final ObjectInspector PARTIAL_RANK_OI = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("rank", "count"), Arrays.asList(PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector));
        private final transient boolean allowEquality;
        private final transient ObjectInspector partialOutputOI;
        private final transient ObjectInspector finalOI;
        private transient List<RankAssets> rankAssetsList;
        private transient StructObjectInspector partialInputOI;
        private transient StructField partialInputRank;
        private transient StructField partialInputCount;

        public GenericUDAFHypotheticalSetRankEvaluator() {
            this(false, PARTIAL_RANK_OI, PrimitiveObjectInspectorFactory.writableLongObjectInspector);
        }

        public GenericUDAFHypotheticalSetRankEvaluator(boolean allowEquality, ObjectInspector partialOutputOI, ObjectInspector finalOI) {
            this.allowEquality = allowEquality;
            this.partialOutputOI = partialOutputOI;
            this.finalOI = finalOI;
        }

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.rankAssetsList = new ArrayList<RankAssets>(parameters.length / 4);
                for (int i = 0; i < parameters.length / 4; ++i) {
                    TypeInfo directArgumentType = TypeInfoUtils.getTypeInfoFromObjectInspector(parameters[4 * i]);
                    TypeInfo inputType = TypeInfoUtils.getTypeInfoFromObjectInspector(parameters[4 * i + 1]);
                    TypeInfo commonTypeInfo = FunctionRegistry.getCommonClassForComparison((TypeInfo)inputType, (TypeInfo)directArgumentType);
                    ObjectInspector commonInputOI = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(commonTypeInfo);
                    this.rankAssetsList.add(new RankAssets(commonInputOI, ObjectInspectorConverters.getConverter(parameters[4 * i], commonInputOI), ObjectInspectorConverters.getConverter(parameters[4 * i + 1], commonInputOI), ((WritableConstantIntObjectInspector)parameters[4 * i + 2]).getWritableConstantValue().get(), NullOrdering.fromCode((int)((WritableConstantIntObjectInspector)parameters[4 * i + 3]).getWritableConstantValue().get())));
                }
            } else {
                this.initPartial2AndFinalOI(parameters);
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return this.partialOutputOI;
            }
            return this.finalOI;
        }

        protected void initPartial2AndFinalOI(ObjectInspector[] parameters) {
            this.partialInputOI = (StructObjectInspector)parameters[0];
            this.partialInputRank = this.partialInputOI.getStructFieldRef(RANK_FIELD);
            this.partialInputCount = this.partialInputOI.getStructFieldRef(COUNT_FIELD);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new HypotheticalSetRankBuffer();
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            HypotheticalSetRankBuffer rankBuffer = (HypotheticalSetRankBuffer)agg;
            rankBuffer.rank = 0L;
            rankBuffer.rowCount = 0L;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            HypotheticalSetRankBuffer rankBuffer = (HypotheticalSetRankBuffer)agg;
            ++rankBuffer.rowCount;
            CompareResult compareResult = this.compare(parameters);
            if (compareResult.getCompareResult() == 0) {
                if (this.allowEquality) {
                    ++rankBuffer.rank;
                }
                return;
            }
            if (compareResult.getOrder() == 1 && compareResult.getCompareResult() < 0 || compareResult.getOrder() == 0 && compareResult.getCompareResult() > 0) {
                ++rankBuffer.rank;
            }
        }

        protected CompareResult compare(Object[] parameters) {
            RankAssets rankAssets;
            int i = 0;
            int c = 0;
            Iterator<RankAssets> iterator = this.rankAssetsList.iterator();
            while (iterator.hasNext() && (c = (rankAssets = iterator.next()).compare(parameters[4 * i + 1], parameters[4 * i])) == 0) {
                ++i;
            }
            if (c == 0) {
                return new CompareResult(c, -1);
            }
            return new CompareResult(c, this.rankAssetsList.get((int)i).order);
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            HypotheticalSetRankBuffer rankBuffer = (HypotheticalSetRankBuffer)agg;
            LongWritable[] result = new LongWritable[]{new LongWritable(rankBuffer.rank + 1L), new LongWritable(rankBuffer.rowCount)};
            return result;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial == null) {
                return;
            }
            Object objRank = this.partialInputOI.getStructFieldData(partial, this.partialInputRank);
            Object objCount = this.partialInputOI.getStructFieldData(partial, this.partialInputCount);
            HypotheticalSetRankBuffer rankBuffer = (HypotheticalSetRankBuffer)agg;
            rankBuffer.rank += ((LongWritable)objRank).get() - 1L;
            rankBuffer.rowCount += ((LongWritable)objCount).get();
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            HypotheticalSetRankBuffer rankBuffer = (HypotheticalSetRankBuffer)agg;
            return new LongWritable(rankBuffer.rank + 1L);
        }

        protected static class CompareResult {
            private final int compareResult;
            private final int order;

            public CompareResult(int compareResult, int order) {
                this.compareResult = compareResult;
                this.order = order;
            }

            public int getCompareResult() {
                return this.compareResult;
            }

            public int getOrder() {
                return this.order;
            }
        }

        protected static class RankAssets {
            private final ObjectInspector commonInputOI;
            private final ObjectInspectorConverters.Converter directArgumentConverter;
            private final ObjectInspectorConverters.Converter inputConverter;
            protected final int order;
            private final NullOrdering nullOrdering;

            public RankAssets(ObjectInspector commonInputOI, ObjectInspectorConverters.Converter directArgumentConverter, ObjectInspectorConverters.Converter inputConverter, int order, NullOrdering nullOrdering) {
                this.commonInputOI = commonInputOI;
                this.directArgumentConverter = directArgumentConverter;
                this.inputConverter = inputConverter;
                this.order = order;
                this.nullOrdering = nullOrdering;
            }

            public int compare(Object inputValue, Object directArgumentValue) {
                return ObjectInspectorUtils.compare(this.inputConverter.convert(inputValue), this.commonInputOI, this.directArgumentConverter.convert(directArgumentValue), this.commonInputOI, new FullMapEqualComparer(), this.nullOrdering.getNullValueOption());
            }
        }

        protected static class HypotheticalSetRankBuffer
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            protected long rank = 0L;
            protected long rowCount = 0L;

            protected HypotheticalSetRankBuffer() {
            }

            @Override
            public int estimate() {
                return 16;
            }
        }
    }

    public static class GenericUDAFRankEvaluator
    extends GenericUDAFAbstractRankEvaluator
    implements ISupportStreamingModeForWindowing {
        @Override
        public Object getNextResult(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((RankBuffer)agg).rowNums.get(0);
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrmDef) {
            this.isStreamingMode = true;
            return this;
        }

        @Override
        public int getRowsRemainingAfterTerminate() throws HiveException {
            return 0;
        }
    }

    public static abstract class GenericUDAFAbstractRankEvaluator
    extends GenericUDAFEvaluator {
        ObjectInspector[] inputOI;
        ObjectInspector[] outputOI;
        boolean isStreamingMode = false;

        protected boolean isStreaming() {
            return this.isStreamingMode;
        }

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m != GenericUDAFEvaluator.Mode.COMPLETE) {
                throw new HiveException("Only COMPLETE mode supported for Rank function");
            }
            this.inputOI = parameters;
            this.outputOI = new ObjectInspector[this.inputOI.length];
            for (int i = 0; i < this.inputOI.length; ++i) {
                this.outputOI[i] = ObjectInspectorUtils.getStandardObjectInspector(this.inputOI[i], ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            }
            return ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new RankBuffer(this.inputOI.length, this.isStreamingMode);
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((RankBuffer)agg).init();
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            RankBuffer rb = (RankBuffer)agg;
            int c = GenericUDAFRank.compare(rb.currVal, this.outputOI, parameters, this.inputOI);
            rb.incrRowNum();
            if (rb.currentRowNum == 1 || c != 0) {
                this.nextRank(rb);
                rb.currVal = GenericUDAFRank.copyToStandardObject(parameters, this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            }
            rb.addRank();
        }

        protected void nextRank(RankBuffer rb) {
            rb.currentRank = rb.currentRowNum;
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            throw new HiveException("terminatePartial not supported");
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            throw new HiveException("merge not supported");
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((RankBuffer)agg).rowNums;
        }
    }

    static class RankBuffer
    implements GenericUDAFEvaluator.AggregationBuffer {
        ArrayList<IntWritable> rowNums;
        int currentRowNum;
        Object[] currVal;
        int currentRank;
        int numParams;
        boolean supportsStreaming;

        RankBuffer(int numParams, boolean supportsStreaming) {
            this.numParams = numParams;
            this.supportsStreaming = supportsStreaming;
            this.init();
        }

        void init() {
            this.rowNums = new ArrayList();
            this.currentRowNum = 0;
            this.currentRank = 0;
            this.currVal = new Object[this.numParams];
            if (this.supportsStreaming) {
                this.rowNums.add(null);
            }
        }

        void incrRowNum() {
            ++this.currentRowNum;
        }

        void addRank() {
            if (this.supportsStreaming) {
                this.rowNums.set(0, new IntWritable(this.currentRank));
            } else {
                this.rowNums.add(new IntWritable(this.currentRank));
            }
        }
    }
}

