/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedUDAFs;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFComputeBitVectorDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFComputeBitVectorString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFComputeBitVectorTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFComputeBitVectorDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFComputeBitVectorFinal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFComputeBitVectorLong;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.stats.ColStatsProcessor;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFComputeBitVectorBase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;

@Description(name="compute_bit_vector_hll", value="_FUNC_(x) - Computes bit vector for NDV computation.")
public class GenericUDAFComputeBitVectorHLL
extends GenericUDAFComputeBitVectorBase {
    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly 1 (col) argument is expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        ColStatsProcessor.ColumnStatsType cst = ColStatsProcessor.ColumnStatsType.getColumnStatsType((PrimitiveTypeInfo)((PrimitiveTypeInfo)parameters[0]));
        switch (cst) {
            case LONG: {
                return new GenericUDAFLongStatsEvaluator();
            }
            case DOUBLE: {
                return new GenericUDAFDoubleStatsEvaluator();
            }
            case STRING: {
                return new GenericUDAFStringStatsEvaluator();
            }
            case DECIMAL: {
                return new GenericUDAFDecimalStatsEvaluator();
            }
            case DATE: {
                return new GenericUDAFDateStatsEvaluator();
            }
            case TIMESTAMP: {
                return new GenericUDAFTimestampStatsEvaluator();
            }
        }
        throw new UDFArgumentTypeException(0, "Type argument " + parameters[0].getTypeName() + " not valid");
    }

    @VectorizedUDAFs(value={VectorUDAFComputeBitVectorString.class, VectorUDAFComputeBitVectorFinal.class})
    public static class GenericUDAFStringStatsEvaluator
    extends GenericUDAFComputeBitVectorBase.StringStatsEvaluatorBase {
        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
            } else {
                this.ndvFieldOI = (BinaryObjectInspector)parameters[0];
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                this.partialResult = new BytesWritable();
                return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
            }
            this.result = new BytesWritable();
            return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            String v;
            Object p = parameters[0];
            GenericUDAFComputeBitVectorBase.StringStatsAgg myagg = (GenericUDAFComputeBitVectorBase.StringStatsAgg)agg;
            if (myagg.firstItem) {
                myagg.numDV = HyperLogLog.builder().setSizeOptimized().build();
                myagg.numDV.reset();
                myagg.firstItem = false;
            }
            if ((v = PrimitiveObjectInspectorUtils.getString(p, this.inputOI)) != null) {
                myagg.numDV.addToEstimator(v);
            }
        }
    }

    @VectorizedUDAFs(value={VectorUDAFComputeBitVectorTimestamp.class, VectorUDAFComputeBitVectorFinal.class})
    public static class GenericUDAFTimestampStatsEvaluator
    extends GenericUDAFNumericStatsEvaluator<TimestampWritableV2, TimestampObjectInspector> {
        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            GenericUDAFComputeBitVectorBase.TimestampStatsAgg result = new GenericUDAFComputeBitVectorBase.TimestampStatsAgg();
            this.reset(result);
            return result;
        }
    }

    @VectorizedUDAFs(value={VectorUDAFComputeBitVectorLong.class, VectorUDAFComputeBitVectorFinal.class})
    public static class GenericUDAFDateStatsEvaluator
    extends GenericUDAFNumericStatsEvaluator<DateWritableV2, DateObjectInspector> {
        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            GenericUDAFComputeBitVectorBase.DateStatsAgg result = new GenericUDAFComputeBitVectorBase.DateStatsAgg();
            this.reset(result);
            return result;
        }
    }

    @VectorizedUDAFs(value={VectorUDAFComputeBitVectorDecimal.class, VectorUDAFComputeBitVectorFinal.class})
    public static class GenericUDAFDecimalStatsEvaluator
    extends GenericUDAFNumericStatsEvaluator<HiveDecimal, HiveDecimalObjectInspector> {
        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            GenericUDAFComputeBitVectorBase.DecimalStatsAgg result = new GenericUDAFComputeBitVectorBase.DecimalStatsAgg();
            this.reset(result);
            return result;
        }
    }

    @VectorizedUDAFs(value={VectorUDAFComputeBitVectorDouble.class, VectorUDAFComputeBitVectorFinal.class})
    public static class GenericUDAFDoubleStatsEvaluator
    extends GenericUDAFNumericStatsEvaluator<Double, DoubleObjectInspector> {
        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            GenericUDAFComputeBitVectorBase.DoubleStatsAgg result = new GenericUDAFComputeBitVectorBase.DoubleStatsAgg();
            this.reset(result);
            return result;
        }
    }

    @VectorizedUDAFs(value={VectorUDAFComputeBitVectorLong.class, VectorUDAFComputeBitVectorFinal.class})
    public static class GenericUDAFLongStatsEvaluator
    extends GenericUDAFNumericStatsEvaluator<Long, LongObjectInspector> {
        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            GenericUDAFComputeBitVectorBase.LongStatsAgg result = new GenericUDAFComputeBitVectorBase.LongStatsAgg();
            this.reset(result);
            return result;
        }
    }

    public static abstract class GenericUDAFNumericStatsEvaluator<V, OI extends PrimitiveObjectInspector>
    extends GenericUDAFComputeBitVectorBase.NumericStatsEvaluatorBase {
        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
            } else {
                this.ndvFieldOI = (BinaryObjectInspector)parameters[0];
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                this.partialResult = new BytesWritable();
                return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
            }
            this.result = new BytesWritable();
            return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            GenericUDAFComputeBitVectorBase.NumericStatsAgg myagg = (GenericUDAFComputeBitVectorBase.NumericStatsAgg)agg;
            if (myagg.numDV == null) {
                myagg.numDV = HyperLogLog.builder().setSizeOptimized().build();
            }
            if (parameters[0] != null) {
                myagg.update(parameters[0], this.inputOI);
            }
        }
    }
}

