/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.io.BytesWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_Aggr_ConvexHull", value="_FUNC_(ST_Geometry) - aggregate convex hull of all geometries passed", extended="Example:\n  SELECT _FUNC_(geometry) FROM source; -- return convex hull of all geometries in source")
public class ST_Aggr_ConvexHull
extends UDAF {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_Aggr_ConvexHull.class.getName());

    public static class AggrConvexHullBinaryEvaluator
    implements UDAFEvaluator {
        private final int MAX_BUFFER_SIZE = 1000;
        private final ArrayList<Geometry> geometries = new ArrayList(1000);
        SpatialReference spatialRef = null;
        int firstWKID = -2;

        public void init() {
            if (this.geometries.size() > 0) {
                this.geometries.clear();
            }
        }

        public boolean iterate(BytesWritable geomref) throws HiveException {
            if (geomref == null) {
                LogUtils.Log_ArgumentsNull(LOG);
                return false;
            }
            if (this.firstWKID == -2) {
                this.firstWKID = GeometryUtils.getWKID(geomref);
                if (this.firstWKID != 0) {
                    this.spatialRef = SpatialReference.create(this.firstWKID);
                }
            } else if (this.firstWKID != GeometryUtils.getWKID(geomref)) {
                LogUtils.Log_SRIDMismatch(LOG, geomref, this.firstWKID);
                return false;
            }
            this.addGeometryToBuffer(geomref);
            return this.geometries.size() != 0;
        }

        public boolean merge(BytesWritable other) throws HiveException {
            return this.iterate(other);
        }

        public BytesWritable terminatePartial() throws HiveException {
            this.maybeAggregateBuffer(true);
            if (this.geometries.size() == 1) {
                OGCGeometry rslt = OGCGeometry.createFromEsriGeometry(this.geometries.get(0), this.spatialRef);
                return GeometryUtils.geometryToEsriShapeBytesWritable(rslt);
            }
            return null;
        }

        public BytesWritable terminate() throws HiveException {
            return this.terminatePartial();
        }

        private void addGeometryToBuffer(BytesWritable geomref) throws HiveException {
            OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
            this.addGeometryToBuffer(ogcGeometry.getEsriGeometry());
        }

        private void addGeometryToBuffer(Geometry geom) throws HiveException {
            this.geometries.add(geom);
            this.maybeAggregateBuffer(false);
        }

        private void maybeAggregateBuffer(boolean force) throws HiveException {
            if (force || this.geometries.size() > 1000) {
                Geometry[] geomArray = new Geometry[this.geometries.size()];
                this.geometries.toArray(geomArray);
                this.geometries.clear();
                try {
                    Geometry[] convexResult = GeometryEngine.convexHull(geomArray, true);
                    Collections.addAll(this.geometries, convexResult);
                }
                catch (Exception e) {
                    LOG.error("exception thrown", (Throwable)e);
                }
            }
        }
    }
}

