/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCPoint;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.log4j.Logger;

public class HiveGeometryOIHelper {
    static Logger LOG = Logger.getLogger(HiveGeometryOIHelper.class);
    private final PrimitiveObjectInspector oi;
    private final int argIndex;
    private final boolean isConstant;
    OGCGeometry constantGeometry;
    private BytesWritable last = null;
    private boolean bytesReused = true;

    private HiveGeometryOIHelper(ObjectInspector oi, int argIndex) {
        this.oi = (PrimitiveObjectInspector)oi;
        this.argIndex = argIndex;
        this.isConstant = ObjectInspectorUtils.isConstantObjectInspector(oi);
    }

    public static HiveGeometryOIHelper create(ObjectInspector[] OIs, int argIndex) throws UDFArgumentException {
        return HiveGeometryOIHelper.create(OIs[argIndex], argIndex);
    }

    public static HiveGeometryOIHelper create(ObjectInspector oi, int argIndex) throws UDFArgumentException {
        if (oi.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("Geometry argument must be a primitive type");
        }
        return new HiveGeometryOIHelper(oi, argIndex);
    }

    public static boolean canCreate(ObjectInspector oi) {
        return oi.getCategory() == ObjectInspector.Category.PRIMITIVE;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public OGCGeometry getConstantGeometry() {
        return this.constantGeometry;
    }

    public OGCPoint getPoint(GenericUDF.DeferredObject[] args) {
        OGCGeometry geometry = this.getGeometry(args);
        if (geometry instanceof OGCPoint) {
            return (OGCPoint)geometry;
        }
        return null;
    }

    public OGCGeometry getGeometry(GenericUDF.DeferredObject[] args) {
        if (this.isConstant) {
            if (this.constantGeometry == null) {
                this.constantGeometry = this.getGeometry(args[this.argIndex]);
            }
            return this.constantGeometry;
        }
        return this.getGeometry(args[this.argIndex]);
    }

    private OGCGeometry getGeometry(GenericUDF.DeferredObject arg) {
        Object writable;
        try {
            writable = this.oi.getPrimitiveWritableObject(arg.get());
        }
        catch (HiveException e) {
            LOG.error((Object)"Failed to get writable", (Throwable)e);
            return null;
        }
        if (writable == null) {
            return null;
        }
        switch (this.oi.getPrimitiveCategory()) {
            case BINARY: {
                return this.getGeometryFromBytes((BytesWritable)writable);
            }
            case STRING: {
                return OGCGeometry.fromText(writable.toString());
            }
        }
        return null;
    }

    private OGCGeometry getGeometryFromBytes(BytesWritable writable) {
        if (this.bytesReused) {
            if (this.last != null && this.last != writable) {
                this.bytesReused = false;
            }
            this.last = writable;
        }
        return GeometryUtils.geometryFromEsriShape(writable, this.bytesReused);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HiveGeometryHelper(");
        builder.append("constant=" + this.isConstant + ";");
        builder.append(")");
        return builder.toString();
    }
}

