/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.OperatorImportFromESRIShape;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import hiveexec.com.google.common.cache.Cache;
import hiveexec.com.google.common.cache.CacheBuilder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBinaryObjectInspector;
import org.apache.hadoop.io.BytesWritable;

public class GeometryUtils {
    private static final int SIZE_WKID = 4;
    private static final int SIZE_TYPE = 1;
    public static final int WKID_UNKNOWN = 0;
    public static OGCType[] OGCTypeLookup = new OGCType[]{OGCType.UNKNOWN, OGCType.ST_POINT, OGCType.ST_LINESTRING, OGCType.ST_POLYGON, OGCType.ST_MULTIPOINT, OGCType.ST_MULTILINESTRING, OGCType.ST_MULTIPOLYGON};
    public static final WritableBinaryObjectInspector geometryTransportObjectInspector = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
    private static final Cache<BytesWritable, OGCGeometry> geometryCache = CacheBuilder.newBuilder().weakKeys().build();

    public static boolean compareSpatialReferences(BytesWritable geomref1, BytesWritable geomref2) {
        return GeometryUtils.getWKID(geomref1) == GeometryUtils.getWKID(geomref2);
    }

    public static BytesWritable geometryToEsriShapeBytesWritable(MapGeometry mapGeometry) {
        return GeometryUtils.serialize(mapGeometry);
    }

    public static BytesWritable geometryToEsriShapeBytesWritable(Geometry geometry, int wkid, OGCType type) {
        return GeometryUtils.serialize(geometry, wkid, type);
    }

    public static BytesWritable geometryToEsriShapeBytesWritable(OGCGeometry geometry) {
        return new CachedGeometryBytesWritable(geometry);
    }

    public static OGCGeometry geometryFromEsriShape(BytesWritable geomref) {
        return GeometryUtils.geometryFromEsriShape(geomref, true);
    }

    public static OGCGeometry geometryFromEsriShape(BytesWritable geomref, boolean bytesRecycled) {
        OGCGeometry cachedGeom;
        if (geomref == null) {
            return null;
        }
        if (geomref instanceof CachedGeometryBytesWritable) {
            return ((CachedGeometryBytesWritable)geomref).getGeometry();
        }
        if (!bytesRecycled && (cachedGeom = geometryCache.getIfPresent(geomref)) != null) {
            return cachedGeom;
        }
        int wkid = GeometryUtils.getWKID(geomref);
        ByteBuffer shapeBuffer = GeometryUtils.getShapeByteBuffer(geomref);
        if (shapeBuffer.limit() < 4) {
            return null;
        }
        if (shapeBuffer.getInt(0) == Geometry.Type.Unknown.value()) {
            return null;
        }
        SpatialReference spatialReference = null;
        if (wkid != 0) {
            spatialReference = SpatialReference.create(wkid);
        }
        Geometry esriGeom = OperatorImportFromESRIShape.local().execute(0, Geometry.Type.Unknown, shapeBuffer);
        OGCGeometry createdGeom = OGCGeometry.createFromEsriGeometry(esriGeom, spatialReference);
        if (!bytesRecycled) {
            geometryCache.put(geomref, createdGeom);
        }
        return createdGeom;
    }

    public static OGCType getType(BytesWritable geomref) {
        return OGCTypeLookup[geomref.getBytes()[4]];
    }

    public static void setType(BytesWritable geomref, OGCType type) {
        geomref.getBytes()[4] = (byte)type.getIndex();
    }

    public static int getWKID(BytesWritable geomref) {
        ByteBuffer bb = ByteBuffer.wrap(geomref.getBytes());
        return bb.getInt(0);
    }

    public static void setWKID(BytesWritable geomref, int wkid) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(wkid);
        System.arraycopy(bb.array(), 0, geomref.getBytes(), 0, 4);
    }

    public static OGCType getInferredOGCType(Geometry geom) {
        switch (geom.getType()) {
            case Polygon: {
                return OGCType.ST_MULTIPOLYGON;
            }
            case Polyline: {
                return OGCType.ST_MULTILINESTRING;
            }
            case MultiPoint: {
                return OGCType.ST_MULTIPOINT;
            }
            case Point: {
                return OGCType.ST_POINT;
            }
        }
        return OGCType.UNKNOWN;
    }

    private static ByteBuffer getShapeByteBuffer(BytesWritable geomref) {
        byte[] geomBytes = geomref.getBytes();
        int offset = 5;
        return ByteBuffer.wrap(geomBytes, offset, geomBytes.length - offset).slice().order(ByteOrder.LITTLE_ENDIAN);
    }

    private static BytesWritable serialize(MapGeometry mapGeometry) {
        OGCType ogcType;
        int wkid = 0;
        SpatialReference spatialRef = mapGeometry.getSpatialReference();
        if (spatialRef != null) {
            wkid = spatialRef.getID();
        }
        Geometry.Type esriType = mapGeometry.getGeometry().getType();
        switch (esriType) {
            case Point: {
                ogcType = OGCType.ST_POINT;
                break;
            }
            case Polyline: {
                ogcType = OGCType.ST_LINESTRING;
                break;
            }
            case Polygon: {
                ogcType = OGCType.ST_POLYGON;
                break;
            }
            default: {
                ogcType = OGCType.UNKNOWN;
            }
        }
        return GeometryUtils.serialize(mapGeometry.getGeometry(), wkid, ogcType);
    }

    private static BytesWritable serialize(OGCGeometry ogcGeometry) {
        OGCType ogcType;
        int wkid;
        try {
            wkid = ogcGeometry.SRID();
        }
        catch (NullPointerException npe) {
            wkid = 0;
        }
        try {
            String typeName = ogcGeometry.geometryType();
            ogcType = typeName.equals("Point") ? OGCType.ST_POINT : (typeName.equals("LineString") ? OGCType.ST_LINESTRING : (typeName.equals("Polygon") ? OGCType.ST_POLYGON : (typeName.equals("MultiPoint") ? OGCType.ST_MULTIPOINT : (typeName.equals("MultiLineString") ? OGCType.ST_MULTILINESTRING : (typeName.equals("MultiPolygon") ? OGCType.ST_MULTIPOLYGON : OGCType.UNKNOWN)))));
        }
        catch (NullPointerException npe) {
            ogcType = OGCType.UNKNOWN;
        }
        return GeometryUtils.serialize(ogcGeometry.getEsriGeometry(), wkid, ogcType);
    }

    private static BytesWritable serialize(Geometry geometry, int wkid, OGCType type) {
        if (geometry == null) {
            return null;
        }
        byte[] shape = GeometryEngine.geometryToEsriShape(geometry);
        if (shape == null) {
            return null;
        }
        byte[] shapeWithData = new byte[shape.length + 4 + 1];
        System.arraycopy(shape, 0, shapeWithData, 5, shape.length);
        BytesWritable hiveGeometryBytes = new BytesWritable(shapeWithData);
        GeometryUtils.setWKID(hiveGeometryBytes, wkid);
        GeometryUtils.setType(hiveGeometryBytes, type);
        BytesWritable ret = new BytesWritable(shapeWithData);
        return ret;
    }

    public static class CachedGeometryBytesWritable
    extends BytesWritable {
        OGCGeometry cachedGeom;

        public CachedGeometryBytesWritable(OGCGeometry geom) {
            this.cachedGeom = geom;
            super.set(GeometryUtils.serialize(this.cachedGeom));
        }

        public OGCGeometry getGeometry() {
            return this.cachedGeom;
        }
    }

    public static enum OGCType {
        UNKNOWN(0),
        ST_POINT(1),
        ST_LINESTRING(2),
        ST_POLYGON(3),
        ST_MULTIPOINT(4),
        ST_MULTILINESTRING(5),
        ST_MULTIPOLYGON(6);

        private final int index;

        private OGCType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

