/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import hiveexec.com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;

public class NotNullConstraint
implements Serializable {
    Map<String, String> notNullConstraints;
    String databaseName;
    String tableName;
    Map<String, List<String>> enableValidateRely;

    public NotNullConstraint() {
    }

    public NotNullConstraint(List<SQLNotNullConstraint> nns, String tableName, String databaseName) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.notNullConstraints = new TreeMap<String, String>();
        this.enableValidateRely = new HashMap<String, List<String>>();
        if (nns == null) {
            return;
        }
        for (SQLNotNullConstraint pk : nns) {
            if (!pk.getTable_db().equalsIgnoreCase(databaseName) || !pk.getTable_name().equalsIgnoreCase(tableName)) continue;
            String enable = pk.isEnable_cstr() ? "ENABLE" : "DISABLE";
            String validate = pk.isValidate_cstr() ? "VALIDATE" : "NOVALIDATE";
            String rely = pk.isRely_cstr() ? "RELY" : "NORELY";
            this.enableValidateRely.put(pk.getNn_name(), ImmutableList.of(enable, validate, rely));
            this.notNullConstraints.put(pk.getNn_name(), pk.getColumn_name());
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Map<String, String> getNotNullConstraints() {
        return this.notNullConstraints;
    }

    public Map<String, List<String>> getEnableValidateRely() {
        return this.enableValidateRely;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Not Null Constraints for " + this.databaseName + "." + this.tableName + ":");
        sb.append("[");
        if (this.notNullConstraints != null && this.notNullConstraints.size() > 0) {
            for (Map.Entry<String, String> me : this.notNullConstraints.entrySet()) {
                sb.append(" {Constraint Name: " + me.getKey());
                sb.append(", Column Name: " + me.getValue());
                sb.append("},");
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean isNotNullConstraintNotEmpty(NotNullConstraint info) {
        return NotNullConstraint.isNotEmpty(info);
    }

    public static boolean isNotEmpty(NotNullConstraint info) {
        return info != null && !info.getNotNullConstraints().isEmpty();
    }
}

