/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import hiveexec.com.google.common.base.Preconditions;
import hiveexec.com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.common.type.SnapshotContext;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.create.like.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.StorageHandlerInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.AlterTableExecuteSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TransformSpec;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveCustomStorageHandlerUtils;
import org.apache.hadoop.hive.ql.stats.Partish;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface HiveStorageHandler
extends Configurable {
    public static final List<AlterTableType> DEFAULT_ALLOWED_ALTER_OPS = ImmutableList.of(AlterTableType.ADDPROPS, AlterTableType.DROPPROPS, AlterTableType.ADDCOLS);

    public Class<? extends InputFormat> getInputFormatClass();

    public Class<? extends OutputFormat> getOutputFormatClass();

    public Class<? extends AbstractSerDe> getSerDeClass();

    public HiveMetaHook getMetaHook();

    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException;

    public void configureInputJobProperties(TableDesc var1, Map<String, String> var2);

    public void configureInputJobCredentials(TableDesc var1, Map<String, String> var2);

    public void configureOutputJobProperties(TableDesc var1, Map<String, String> var2);

    @Deprecated
    public void configureTableJobProperties(TableDesc var1, Map<String, String> var2);

    public void configureJobConf(TableDesc var1, JobConf var2);

    default public StorageHandlerInfo getStorageHandlerInfo(org.apache.hadoop.hive.metastore.api.Table table) throws MetaException {
        return null;
    }

    default public LockType getLockType(WriteEntity writeEntity) {
        return LockType.EXCLUSIVE;
    }

    default public boolean addDynamicSplitPruningEdge(Table table, ExprNodeDesc syntheticFilterPredicate) {
        return false;
    }

    default public Map<String, String> getOperatorDescProperties(OperatorDesc operatorDesc, Map<String, String> initialProps) {
        return initialProps;
    }

    default public Map<String, String> getBasicStatistics(Partish partish) {
        return null;
    }

    default public boolean canProvideBasicStatistics() {
        return false;
    }

    default public boolean directInsert() {
        return false;
    }

    default public boolean alwaysUnpartitioned() {
        return false;
    }

    default public void setTableParametersForCTLT(Table tbl, CreateTableLikeDesc desc, Map<String, String> origParams) {
    }

    default public AcidSupportType supportsAcidOperations(Table table, boolean isWriteOperation) {
        return AcidSupportType.NONE;
    }

    default public List<VirtualColumn> acidVirtualColumns() {
        return Collections.emptyList();
    }

    default public List<FieldSchema> acidSelectColumns(Table table, Context.Operation operation) {
        return Collections.emptyList();
    }

    default public List<FieldSchema> acidSortColumns(Table table, Context.Operation operation) {
        return Collections.emptyList();
    }

    default public boolean supportsSortColumns() {
        return false;
    }

    default public List<FieldSchema> sortColumns(Table table) {
        Preconditions.checkState(this.supportsSortColumns(), "Should only be called for table formats where data sorting is supported");
        return Collections.emptyList();
    }

    default public boolean supportsPartitionTransform() {
        return false;
    }

    default public List<TransformSpec> getPartitionTransformSpec(Table table) {
        return null;
    }

    default public DynamicPartitionCtx createDPContext(HiveConf conf, Table table, Context.Operation writeOperation) throws SemanticException {
        Preconditions.checkState(this.alwaysUnpartitioned(), "Should only be called for table formats where partitioning is not handled by Hive but the table format itself. See alwaysUnpartitioned() method.");
        return null;
    }

    default public String getFileFormatPropertyKey() {
        return null;
    }

    default public boolean commitInMoveTask() {
        return false;
    }

    default public void storageHandlerCommit(Properties commitProperties, boolean overwrite) throws HiveException {
        throw new UnsupportedOperationException();
    }

    default public boolean isAllowedAlterOperation(AlterTableType opType) {
        return DEFAULT_ALLOWED_ALTER_OPS.contains(opType);
    }

    default public boolean isTimeTravelAllowed() {
        return false;
    }

    default public boolean supportsTruncateOnNonNativeTables() {
        return false;
    }

    default public boolean isMetadataTableSupported() {
        return false;
    }

    default public boolean isValidMetadataTable(String metaTableName) {
        return false;
    }

    default public URI getURIForAuth(org.apache.hadoop.hive.metastore.api.Table table) throws URISyntaxException {
        Map tableProperties = HiveCustomStorageHandlerUtils.getTableProperties((org.apache.hadoop.hive.metastore.api.Table)table);
        return new URI(this.getClass().getSimpleName().toLowerCase() + "://" + HiveCustomStorageHandlerUtils.getTablePropsForCustomStorageHandler((Map)tableProperties));
    }

    default public void validateSinkDesc(FileSinkDesc sinkDesc) throws SemanticException {
    }

    default public void executeOperation(Table table, AlterTableExecuteSpec executeSpec) {
    }

    default public boolean areSnapshotsSupported() {
        return false;
    }

    default public SnapshotContext getCurrentSnapshotContext(Table table) {
        return null;
    }

    default public void prepareAlterTableEnvironmentContext(AbstractAlterTableDesc alterTableDesc, EnvironmentContext environmentContext) {
    }

    public static enum AcidSupportType {
        NONE,
        WITH_TRANSACTIONS,
        WITHOUT_TRANSACTIONS;

    }
}

