/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import hiveexec.com.google.common.collect.ImmutableList;
import hiveexec.com.google.common.collect.ImmutableMap;
import hiveexec.com.google.common.util.concurrent.ThreadFactoryBuilder;
import hiveexec.org.joda.time.Interval;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.engine.EngineCompileHelper;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveRelOptMaterialization;
import org.apache.hadoop.hive.ql.metadata.MaterializedViewsCache;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePartitionPruneRuleHelper;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.PartitionPruneRuleHelper;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.MaterializedViewIncrementalRewritingRelVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CBOPlan;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.ParsedQueryTables;
import org.apache.hadoop.hive.ql.parse.QueryTables;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.type.FunctionHelper;
import org.apache.hadoop.hive.ql.parse.type.HiveFunctionHelper;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveMaterializedViewsRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMaterializedViewsRegistry.class);
    private static final String CLASS_NAME = HiveMaterializedViewsRegistry.class.getName();
    private static final HiveMaterializedViewsRegistry SINGLETON = new HiveMaterializedViewsRegistry();
    private final MaterializedViewsCache materializedViewsCache = new MaterializedViewsCache();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    private HiveMaterializedViewsRegistry() {
    }

    public static HiveMaterializedViewsRegistry get() {
        return SINGLETON;
    }

    public void init() {
        try {
            HiveConf conf = new HiveConf();
            conf.set(MetastoreConf.ConfVars.FILTER_HOOK.getVarname(), DefaultMetaStoreFilterHookImpl.class.getName());
            this.init(Hive.get(conf));
        }
        catch (HiveException e) {
            LOG.error("Problem connecting to the metastore when initializing the view registry", (Throwable)e);
        }
    }

    public void init(Hive db) {
        boolean dummy = db.getConf().get(HiveConf.ConfVars.HIVE_SERVER2_MATERIALIZED_VIEWS_REGISTRY_IMPL.varname).equals("DUMMY");
        if (dummy) {
            this.initialized.set(true);
            LOG.info("Using dummy materialized views registry");
        } else {
            long period = HiveConf.getTimeVar(db.getConf(), HiveConf.ConfVars.HIVE_SERVER2_MATERIALIZED_VIEWS_REGISTRY_REFRESH, TimeUnit.SECONDS);
            ScheduledExecutorService pool = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HiveMaterializedViewsRegistry-%d").build());
            pool.scheduleAtFixedRate(new Loader(db), 0L, period, TimeUnit.SECONDS);
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveRelOptMaterialization createMaterialization(HiveConf conf, Hive db, Table materializedViewTable) {
        CBOPlan plan;
        String viewQuery = materializedViewTable.getViewExpandedText();
        RelNode viewScan = HiveMaterializedViewsRegistry.createMaterializedViewScan(conf, db, materializedViewTable);
        if (viewScan == null) {
            LOG.warn("Materialized view " + materializedViewTable.getCompleteName() + " ignored; error creating view replacement");
            return null;
        }
        String currentEngine = conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
        String engineString = materializedViewTable.getProperty("materializedview.engine");
        if (engineString != null) {
            conf.setVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, engineString);
        }
        try {
            plan = ParseUtils.parseQuery((HiveConf)conf, (String)viewQuery);
        }
        catch (Exception e) {
            LOG.warn("Materialized view " + materializedViewTable.getCompleteName() + " ignored; error parsing original query; " + e);
            HiveRelOptMaterialization hiveRelOptMaterialization = null;
            return hiveRelOptMaterialization;
        }
        finally {
            conf.setVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, currentEngine);
        }
        return new HiveRelOptMaterialization(viewScan, plan.getPlan(), null, viewScan.getTable().getQualifiedName(), StringUtils.isBlank((CharSequence)plan.getInvalidAutomaticRewritingMaterializationReason()) ? EnumSet.allOf(HiveRelOptMaterialization.RewriteAlgorithm.class) : EnumSet.of(HiveRelOptMaterialization.RewriteAlgorithm.TEXT), this.determineIncrementalRebuildMode(plan.getPlan()), plan.getAst());
    }

    private HiveRelOptMaterialization.IncrementalRebuildMode determineIncrementalRebuildMode(RelNode definitionPlan) {
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        visitor.go(definitionPlan);
        if (!visitor.isRewritingAllowed()) {
            return HiveRelOptMaterialization.IncrementalRebuildMode.NOT_AVAILABLE;
        }
        if (visitor.isContainsAggregate() && !visitor.hasCountStar()) {
            return HiveRelOptMaterialization.IncrementalRebuildMode.INSERT_ONLY;
        }
        return HiveRelOptMaterialization.IncrementalRebuildMode.AVAILABLE;
    }

    public void createMaterializedView(HiveConf conf, Hive db, Table materializedViewTable) {
        boolean cache;
        boolean bl = cache = !conf.get(HiveConf.ConfVars.HIVE_SERVER2_MATERIALIZED_VIEWS_REGISTRY_IMPL.varname).equals("DUMMY");
        if (!cache) {
            return;
        }
        if (!materializedViewTable.isRewriteEnabled()) {
            LOG.debug("Materialized view " + materializedViewTable.getCompleteName() + " ignored; it is not rewrite enabled");
            return;
        }
        HiveRelOptMaterialization materialization = this.createMaterialization(conf, db, materializedViewTable);
        if (materialization == null) {
            return;
        }
        this.materializedViewsCache.putIfAbsent(materializedViewTable, materialization);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created materialized view for rewriting: " + materializedViewTable.getFullyQualifiedName());
        }
    }

    public void refreshMaterializedView(HiveConf conf, Hive db, Table materializedViewTable) {
        HiveRelOptMaterialization cached = this.materializedViewsCache.get(materializedViewTable.getDbName(), materializedViewTable.getTableName());
        if (cached == null) {
            return;
        }
        Table cachedTable = HiveMaterializedViewUtils.extractTable((RelOptMaterialization)cached);
        this.refreshMaterializedView(conf, db, cachedTable, materializedViewTable);
    }

    public void refreshMaterializedView(HiveConf conf, Hive db, Table oldMaterializedViewTable, Table materializedViewTable) {
        boolean cache;
        boolean bl = cache = !conf.get(HiveConf.ConfVars.HIVE_SERVER2_MATERIALIZED_VIEWS_REGISTRY_IMPL.varname).equals("DUMMY");
        if (!cache) {
            return;
        }
        if (!materializedViewTable.isRewriteEnabled()) {
            this.dropMaterializedView(oldMaterializedViewTable);
            LOG.debug("Materialized view " + materializedViewTable.getCompleteName() + " dropped; it is not rewrite enabled");
            return;
        }
        HiveRelOptMaterialization newMaterialization = this.createMaterialization(conf, db, materializedViewTable);
        if (newMaterialization == null) {
            return;
        }
        this.materializedViewsCache.refresh(oldMaterializedViewTable, materializedViewTable, newMaterialization);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Materialized view refreshed: " + materializedViewTable.getFullyQualifiedName());
        }
    }

    public void dropMaterializedView(Table materializedViewTable) {
        this.materializedViewsCache.remove(materializedViewTable);
    }

    public void dropMaterializedView(String dbName, String tableName) {
        this.materializedViewsCache.remove(dbName, tableName);
    }

    List<HiveRelOptMaterialization> getRewritingMaterializedViews() {
        return this.materializedViewsCache.values().stream().filter(materialization -> materialization.getScope().contains((Object)HiveRelOptMaterialization.RewriteAlgorithm.CALCITE)).collect(Collectors.toList());
    }

    public HiveRelOptMaterialization getRewritingMaterializedView(String dbName, String viewName, EnumSet<HiveRelOptMaterialization.RewriteAlgorithm> scope) {
        HiveRelOptMaterialization materialization = this.materializedViewsCache.get(dbName, viewName);
        if (materialization == null) {
            return null;
        }
        if (!materialization.isSupported(scope)) {
            return null;
        }
        return materialization;
    }

    public List<HiveRelOptMaterialization> getRewritingMaterializedViews(ASTNode ast) {
        return this.materializedViewsCache.get(ast);
    }

    public boolean isEmpty() {
        return this.materializedViewsCache.isEmpty();
    }

    private static RelNode createMaterializedViewScan(HiveConf conf, Hive db, Table viewTable) {
        HiveTableScan tableRel;
        RelDataType rowType;
        ColumnInfo colInfo;
        String colName;
        StructObjectInspector rowObjectInspector;
        RelDataTypeSystem typeSystem = EngineCompileHelper.getInstance((HiveConf)conf).getRelDataTypeSystem();
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl(typeSystem));
        RelOptPlanner planner = CalcitePlanner.createPlanner((HiveConf)conf, (FunctionHelper)new HiveFunctionHelper(rexBuilder));
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)rexBuilder);
        RowResolver rr = new RowResolver();
        try {
            rowObjectInspector = (StructObjectInspector)viewTable.getDeserializer().getObjectInspector();
        }
        catch (SerDeException e) {
            return null;
        }
        List<? extends StructField> fields = rowObjectInspector.getAllStructFieldRefs();
        ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
        for (StructField structField : fields) {
            colName = structField.getFieldName();
            colInfo = new ColumnInfo(structField.getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector(structField.getFieldObjectInspector()), null, false);
            rr.put(null, colName, colInfo);
            cInfoLst.add(colInfo);
        }
        ArrayList nonPartitionColumns = new ArrayList(cInfoLst);
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
        for (FieldSchema part_col : viewTable.getPartCols()) {
            colName = part_col.getName();
            colInfo = new ColumnInfo(colName, (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo(part_col.getType()), null, true);
            rr.put(null, colName, colInfo);
            cInfoLst.add(colInfo);
            arrayList.add(colInfo);
        }
        try {
            rowType = TypeConverter.getType((RelOptCluster)cluster, (RowResolver)rr, null);
        }
        catch (CalciteSemanticException e) {
            return null;
        }
        ArrayList<String> fullyQualifiedTabName = new ArrayList<String>();
        if (viewTable.getDbName() != null && !viewTable.getDbName().isEmpty()) {
            fullyQualifiedTabName.add(viewTable.getDbName());
        }
        fullyQualifiedTabName.add(viewTable.getTableName());
        RelOptHiveTable.TableType tableType = HiveCalciteUtil.obtainTableType((Table)viewTable);
        if (tableType == RelOptHiveTable.TableType.DRUID) {
            String address = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
            String dataSource = viewTable.getParameters().get("druid.datasource");
            HashSet<String> metrics = new HashSet<String>();
            ArrayList<RelDataType> druidColTypes = new ArrayList<RelDataType>();
            ArrayList<String> druidColNames = new ArrayList<String>();
            RelDataTypeFactory dtFactory = cluster.getRexBuilder().getTypeFactory();
            for (RelDataTypeField field : rowType.getFieldList()) {
                if ("__time".equals(field.getName())) {
                    druidColTypes.add(dtFactory.createTypeWithNullability(field.getType(), false));
                } else {
                    druidColTypes.add(field.getType());
                }
                druidColNames.add(field.getName());
                if (field.getName().equals("__time") || field.getType().getSqlTypeName() == SqlTypeName.VARCHAR) continue;
                metrics.add(field.getName());
            }
            List<Interval> intervals = Collections.singletonList(DruidTable.DEFAULT_INTERVAL);
            rowType = dtFactory.createStructType(druidColTypes, druidColNames);
            RelOptHiveTable optTable = new RelOptHiveTable(null, cluster.getTypeFactory(), fullyQualifiedTabName, rowType, viewTable, nonPartitionColumns, arrayList, new ArrayList(), conf, db, (ParsedQueryTables)new QueryTables(true), new HashMap(), new HashMap(), new AtomicInteger(), tableType, (PartitionPruneRuleHelper)new HivePartitionPruneRuleHelper());
            DruidTable druidTable = new DruidTable(new DruidSchema(address, address, false), dataSource, RelDataTypeImpl.proto((RelDataType)rowType), metrics, "__time", intervals, null, null);
            HiveTableScan scan = new HiveTableScan(cluster, cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, viewTable.getTableName(), null, false, false);
            tableRel = DruidQuery.create((RelOptCluster)cluster, (RelTraitSet)cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE), (RelOptTable)optTable, (DruidTable)druidTable, ImmutableList.of(scan), ImmutableMap.of());
        } else {
            RelOptHiveTable optTable = new RelOptHiveTable(null, cluster.getTypeFactory(), fullyQualifiedTabName, rowType, viewTable, nonPartitionColumns, arrayList, new ArrayList(), conf, db, (ParsedQueryTables)new QueryTables(true), new HashMap(), new HashMap(), new AtomicInteger(), tableType, (PartitionPruneRuleHelper)new HivePartitionPruneRuleHelper());
            tableRel = new HiveTableScan(cluster, cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, viewTable.getTableName(), null, false, false);
        }
        return tableRel;
    }

    private class Loader
    implements Runnable {
        private final Hive db;

        private Loader(Hive db) {
            this.db = db;
        }

        @Override
        public void run() {
            SessionState ss = new SessionState(this.db.getConf());
            ss.setIsHiveServerQuery(true);
            SessionState.start((SessionState)ss);
            PerfLogger perfLogger = SessionState.getPerfLogger();
            perfLogger.PerfLogBegin(CLASS_NAME, "MaterializedViewsRegistryRefresh");
            try {
                if (HiveMaterializedViewsRegistry.this.initialized.get()) {
                    for (Table mvTableFromAll : this.db.getAllMaterializedViewObjectsForRewriting()) {
                        Table mvTable = this.db.getTable(mvTableFromAll.getDbName(), mvTableFromAll.getTableName());
                        if (mvTable == null) continue;
                        HiveRelOptMaterialization existingMV = HiveMaterializedViewsRegistry.this.getRewritingMaterializedView(mvTable.getDbName(), mvTable.getTableName(), HiveRelOptMaterialization.RewriteAlgorithm.ALL);
                        if (existingMV != null) {
                            Table existingMVTable = HiveMaterializedViewUtils.extractTable((RelOptMaterialization)existingMV);
                            if (existingMVTable.getCreateTime() >= mvTable.getCreateTime() && (existingMVTable.getCreateTime() != mvTable.getCreateTime() || existingMVTable.getMVMetadata().getMaterializationTime() > mvTable.getMVMetadata().getMaterializationTime())) continue;
                            HiveMaterializedViewsRegistry.this.refreshMaterializedView(this.db.getConf(), this.db, existingMVTable, mvTable);
                            continue;
                        }
                        HiveMaterializedViewsRegistry.this.refreshMaterializedView(this.db.getConf(), this.db, null, mvTable);
                    }
                    LOG.info("Materialized views registry has been refreshed");
                } else {
                    for (Table mvTableFromAll : this.db.getAllMaterializedViewObjectsForRewriting()) {
                        Table mvTable = this.db.getTable(mvTableFromAll.getDbName(), mvTableFromAll.getTableName());
                        if (mvTable == null) continue;
                        HiveMaterializedViewsRegistry.this.refreshMaterializedView(this.db.getConf(), this.db, null, mvTable);
                    }
                    HiveMaterializedViewsRegistry.this.initialized.set(true);
                    LOG.info("Materialized views registry has been initialized");
                }
            }
            catch (HiveException e) {
                if (HiveMaterializedViewsRegistry.this.initialized.get()) {
                    LOG.error("Problem connecting to the metastore when refreshing the view registry", (Throwable)e);
                }
                LOG.error("Problem connecting to the metastore when initializing the view registry", (Throwable)e);
            }
            perfLogger.PerfLogEnd(CLASS_NAME, "MaterializedViewsRegistryRefresh");
        }
    }
}

