/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;

public class ForeignKeyInfo
implements Serializable {
    Map<String, List<ForeignKeyCol>> foreignKeys;
    String childTableName;
    String childDatabaseName;

    public ForeignKeyInfo() {
    }

    public ForeignKeyInfo(List<SQLForeignKey> fks, String childTableName, String childDatabaseName) {
        this.childTableName = childTableName;
        this.childDatabaseName = childDatabaseName;
        this.foreignKeys = new TreeMap<String, List<ForeignKeyCol>>();
        if (fks == null) {
            return;
        }
        for (SQLForeignKey fk : fks) {
            if (!fk.getFktable_db().equalsIgnoreCase(childDatabaseName) || !fk.getFktable_name().equalsIgnoreCase(childTableName)) continue;
            String enable = fk.isEnable_cstr() ? "ENABLE" : "DISABLE";
            String validate = fk.isValidate_cstr() ? "VALIDATE" : "NOVALIDATE";
            String rely = fk.isRely_cstr() ? "RELY" : "NORELY";
            ForeignKeyCol currCol = new ForeignKeyCol(fk.getPktable_name(), fk.getPktable_db(), fk.getPkcolumn_name(), fk.getFkcolumn_name(), fk.getKey_seq(), enable, validate, rely);
            String constraintName = fk.getFk_name();
            if (this.foreignKeys.containsKey(constraintName)) {
                this.foreignKeys.get(constraintName).add(currCol);
                continue;
            }
            ArrayList<ForeignKeyCol> currList = new ArrayList<ForeignKeyCol>();
            currList.add(currCol);
            this.foreignKeys.put(constraintName, currList);
        }
    }

    public String getChildTableName() {
        return this.childTableName;
    }

    public String getChildDatabaseName() {
        return this.childDatabaseName;
    }

    public Map<String, List<ForeignKeyCol>> getForeignKeys() {
        return this.foreignKeys;
    }

    public void setChildTableName(String tableName) {
        this.childTableName = tableName;
    }

    public void setChildDatabaseName(String databaseName) {
        this.childDatabaseName = databaseName;
    }

    public void setForeignKeys(Map<String, List<ForeignKeyCol>> foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Foreign Keys for " + this.childDatabaseName + "." + this.childTableName + ":");
        sb.append("[");
        if (this.foreignKeys != null && this.foreignKeys.size() > 0) {
            for (Map.Entry<String, List<ForeignKeyCol>> me : this.foreignKeys.entrySet()) {
                sb.append(" {Constraint Name: " + me.getKey() + ",");
                List<ForeignKeyCol> currCol = me.getValue();
                if (currCol != null && currCol.size() > 0) {
                    for (ForeignKeyCol fkc : currCol) {
                        sb.append(" (Parent Column Name: " + fkc.parentDatabaseName + "." + fkc.parentTableName + "." + fkc.parentColName + ", Column Name: " + fkc.childColName + ", Key Sequence: " + fkc.position + "),");
                    }
                    sb.setLength(sb.length() - 1);
                }
                sb.append("},");
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean isForeignKeyInfoNotEmpty(ForeignKeyInfo info) {
        return ForeignKeyInfo.isNotEmpty(info);
    }

    public static boolean isNotEmpty(ForeignKeyInfo info) {
        return info != null && !info.getForeignKeys().isEmpty();
    }

    public class ForeignKeyCol {
        public String parentTableName;
        public String parentDatabaseName;
        public String parentColName;
        public String childColName;
        public Integer position;
        public String enable;
        public String validate;
        public String rely;

        public ForeignKeyCol(String parentTableName, String parentDatabaseName, String parentColName, String childColName, Integer position, String enable, String validate, String rely) {
            this.parentTableName = parentTableName;
            this.parentDatabaseName = parentDatabaseName;
            this.parentColName = parentColName;
            this.childColName = childColName;
            this.position = position;
            this.enable = enable;
            this.validate = validate;
            this.rely = rely;
        }
    }
}

