/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.DateTimeMath;

public class TimestampColSubtractIntervalYearMonthColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final transient HiveIntervalYearMonth scratchIntervalYearMonth2 = new HiveIntervalYearMonth();
    private final transient DateTimeMath dtm = new DateTimeMath();

    public TimestampColSubtractIntervalYearMonthColumn(int colNum1, int colNum2, int outputColumnNum) {
        super(colNum1, colNum2, outputColumnNum);
    }

    public TimestampColSubtractIntervalYearMonthColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        TimestampColumnVector inputColVector1 = (TimestampColumnVector)batch.cols[this.inputColumnNum[0]];
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.inputColumnNum[1]];
        TimestampColumnVector outputColVector = (TimestampColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        long[] vector2 = inputColVector2.vector;
        NullUtil.propagateNullsColCol((ColumnVector)inputColVector1, (ColumnVector)inputColVector2, (ColumnVector)outputColVector, sel, n, batch.selectedInUse);
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            this.scratchIntervalYearMonth2.set((int)vector2[0]);
            this.dtm.subtract(inputColVector1.asScratchTimestamp(0), this.scratchIntervalYearMonth2, outputColVector.getScratchTimestamp());
            outputColVector.setFromScratchTimestamp(0);
        } else if (inputColVector1.isRepeating) {
            Timestamp value1 = inputColVector1.asScratchTimestamp(0);
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.scratchIntervalYearMonth2.set((int)vector2[i]);
                    this.dtm.subtract(value1, this.scratchIntervalYearMonth2, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.scratchIntervalYearMonth2.set((int)vector2[i]);
                    this.dtm.subtract(value1, this.scratchIntervalYearMonth2, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            }
        } else if (inputColVector2.isRepeating) {
            this.scratchIntervalYearMonth2.set((int)vector2[0]);
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.scratchIntervalYearMonth2, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.scratchIntervalYearMonth2, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.scratchIntervalYearMonth2.set((int)vector2[i]);
                this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.scratchIntervalYearMonth2, outputColVector.getScratchTimestamp());
                outputColVector.setFromScratchTimestamp(i);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.scratchIntervalYearMonth2.set((int)vector2[i]);
                this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.scratchIntervalYearMonth2, outputColVector.getScratchTimestamp());
                outputColVector.setFromScratchTimestamp(i);
            }
        }
        NullUtil.setNullDataEntriesTimestamp(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", " + this.getColumnParamString(1, this.inputColumnNum[1]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"timestamp"), VectorExpressionDescriptor.ArgumentType.getType((String)"interval_year_month")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

