/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class TimestampColEqualDoubleColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum2;

    public TimestampColEqualDoubleColumn(int colNum1, int colNum2, int outputColumnNum) {
        super(colNum1, outputColumnNum);
        this.colNum2 = colNum2;
    }

    public TimestampColEqualDoubleColumn() {
        this.colNum2 = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        TimestampColumnVector inputColVector1 = (TimestampColumnVector)batch.cols[this.inputColumnNum[0]];
        DoubleColumnVector inputColVector2 = (DoubleColumnVector)batch.cols[this.colNum2];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        double[] vector2 = inputColVector2.vector;
        long[] outputVector = outputColVector.vector;
        NullUtil.propagateNullsColCol((ColumnVector)inputColVector1, (ColumnVector)inputColVector2, (ColumnVector)outputColVector, sel, n, batch.selectedInUse);
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            outputVector[0] = inputColVector1.getDouble(0) == vector2[0] ? 1L : 0L;
        } else if (inputColVector1.isRepeating) {
            double value1 = inputColVector1.getDouble(0);
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = value1 == vector2[i] ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = value1 == vector2[i] ? 1L : 0L;
                }
            }
        } else if (inputColVector2.isRepeating) {
            double value2 = vector2[0];
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = inputColVector1.getDouble(i) == vector2[0] ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = inputColVector1.getDouble(i) == vector2[0] ? 1L : 0L;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputVector[i] = inputColVector1.getDouble(i) == vector2[i] ? 1L : 0L;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = inputColVector1.getDouble(i) == vector2[i] ? 1L : 0L;
            }
        }
        NullUtil.setNullDataEntriesLong(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"timestamp"), VectorExpressionDescriptor.ArgumentType.getType((String)"double")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

