/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprLongScalarLongScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected final long arg2Scalar;
    protected final long arg3Scalar;

    public IfExprLongScalarLongScalar(int arg1Column, long arg2Scalar, long arg3Scalar, int outputColumnNum) {
        super(arg1Column, outputColumnNum);
        this.arg2Scalar = arg2Scalar;
        this.arg3Scalar = arg3Scalar;
    }

    public IfExprLongScalarLongScalar() {
        this.arg2Scalar = 0L;
        this.arg3Scalar = 0L;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.inputColumnNum[0]];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        long[] vector1 = arg1ColVector.vector;
        long[] outputVector = outputColVector.vector;
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                outputColVector.fill(this.arg2Scalar);
            } else {
                outputColVector.fill(this.arg3Scalar);
            }
            return;
        }
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = vector1[i] == 1L ? this.arg2Scalar : this.arg3Scalar;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1[i] == 1L ? this.arg2Scalar : this.arg3Scalar;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] == 1L ? this.arg2Scalar : this.arg3Scalar;
                }
            }
        } else if (batch.selectedInUse) {
            if (!outputColVector.noNulls) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = false;
                    outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? this.arg2Scalar : this.arg3Scalar;
                }
            } else {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? this.arg2Scalar : this.arg3Scalar;
                }
            }
        } else {
            if (!outputColVector.noNulls) {
                Arrays.fill(outputIsNull, false);
                outputColVector.noNulls = true;
            }
            for (int i = 0; i != n; ++i) {
                outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? this.arg2Scalar : this.arg3Scalar;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", val " + this.arg2Scalar + ", val " + this.arg3Scalar;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"long"), VectorExpressionDescriptor.ArgumentType.getType((String)"int_date_interval_year_month"), VectorExpressionDescriptor.ArgumentType.getType((String)"int_date_interval_year_month")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }
}

