/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBloomFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.io.IOUtils;
import org.apache.hive.common.util.BloomKFilter;

public class VectorUDAFBloomFilter
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private long expectedEntries = -1L;
    private ValueProcessor valueProcessor;
    private transient int bitSetSize;
    private transient ByteArrayOutputStream byteStream;

    public VectorUDAFBloomFilter() {
    }

    public VectorUDAFBloomFilter(VectorAggregationDesc vecAggrDesc) {
        super(vecAggrDesc);
        this.init();
    }

    private void init() {
        ColumnVector.Type colVectorType;
        GenericUDAFBloomFilter.GenericUDAFBloomFilterEvaluator udafBloomFilter = (GenericUDAFBloomFilter.GenericUDAFBloomFilterEvaluator)this.vecAggrDesc.getEvaluator();
        this.expectedEntries = udafBloomFilter.getExpectedEntries();
        this.bitSetSize = -1;
        this.byteStream = new ByteArrayOutputStream();
        try {
            colVectorType = this.inputExpression.getOutputColumnVectorType();
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
        switch (colVectorType) {
            case LONG: 
            case DECIMAL_64: {
                this.valueProcessor = new ValueProcessorLong();
                break;
            }
            case DOUBLE: {
                this.valueProcessor = new ValueProcessorDouble();
                break;
            }
            case DECIMAL: {
                this.valueProcessor = new ValueProcessorDecimal();
                break;
            }
            case BYTES: {
                this.valueProcessor = new ValueProcessorBytes();
                break;
            }
            case TIMESTAMP: {
                this.valueProcessor = new ValueProcessorTimestamp();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported column vector type " + colVectorType);
            }
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        if (this.expectedEntries < 0L) {
            throw new IllegalStateException("expectedEntries not initialized");
        }
        return new Aggregation(this.expectedEntries);
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        ColumnVector inputColumn = batch.cols[this.inputExpression.getOutputColumnNum()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        if (inputColumn.isRepeating) {
            if (inputColumn.noNulls || !inputColumn.isNull[0]) {
                this.valueProcessor.processValue(myagg, inputColumn, 0);
            }
            return;
        }
        if (!batch.selectedInUse && inputColumn.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, inputColumn, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, inputColumn, batchSize);
        } else if (inputColumn.noNulls) {
            this.iterateSelectionNoNulls(myagg, inputColumn, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, inputColumn, batchSize, batch.selected);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.valueProcessor.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            if (inputColumn.isNull[i]) continue;
            this.valueProcessor.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, ColumnVector inputColumn, int batchSize, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            this.valueProcessor.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, ColumnVector inputColumn, int batchSize, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (inputColumn.isNull[i]) continue;
            this.valueProcessor.processValue(myagg, inputColumn, i);
        }
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        ColumnVector inputColumn = batch.cols[this.inputExpression.getOutputColumnNum()];
        if (inputColumn.noNulls) {
            if (inputColumn.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batchSize);
            }
        } else if (inputColumn.isRepeating) {
            if (!inputColumn.isNull[0]) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batchSize);
            }
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batchSize, batch.selected);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batchSize);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            this.valueProcessor.processValue(myagg, inputColumn, 0);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, ColumnVector inputColumn, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            int row = selection[i];
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            this.valueProcessor.processValue(myagg, inputColumn, row);
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            this.valueProcessor.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, ColumnVector inputColumn, int batchSize, int[] selection) {
        for (int i = 0; i < batchSize; ++i) {
            int row = selection[i];
            if (inputColumn.isNull[row]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            this.valueProcessor.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            if (inputColumn.isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            this.valueProcessor.processValue(myagg, inputColumn, i);
        }
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregrateIndex);
        return myagg;
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        agg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        if (this.bitSetSize < 0) {
            try {
                Aggregation agg = (Aggregation)this.getNewAggregationBuffer();
                this.bitSetSize = agg.bf.getBitSet().length;
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error while creating AggregationBuffer", e);
            }
        }
        JavaDataModel model = JavaDataModel.get();
        long bloomFilterSize = JavaDataModel.alignUp((long)((long)model.object() + model.lengthForLongArrayOfSize((long)this.bitSetSize)), (long)model.memoryAlign());
        return JavaDataModel.alignUp((long)((long)model.object() + bloomFilterSize + (long)model.primitive1() + (long)model.primitive1()), (long)model.memoryAlign());
    }

    public long getExpectedEntries() {
        return this.expectedEntries;
    }

    public void setExpectedEntries(long expectedEntries) {
        this.expectedEntries = expectedEntries;
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return name.equals("bloom_filter") && outputColVectorType == ColumnVector.Type.BYTES && (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE);
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[columnNum];
        Aggregation myagg = (Aggregation)agg;
        outputColVector.isNull[batchIndex] = false;
        try {
            Aggregation bfAgg = (Aggregation)agg;
            this.byteStream.reset();
            BloomKFilter.serialize(this.byteStream, bfAgg.bf);
            byte[] bytes = this.byteStream.toByteArray();
            outputColVector.setVal(batchIndex, bytes);
        }
        catch (IOException err) {
            throw new HiveException("Error encountered while serializing bloomfilter", err);
        }
        finally {
            IOUtils.closeStream((Closeable)this.byteStream);
        }
    }

    public static class ValueProcessorTimestamp
    extends ValueProcessor {
        @Override
        protected void processValue(Aggregation myagg, ColumnVector columnVector, int i) {
            TimestampColumnVector inputColumn = (TimestampColumnVector)columnVector;
            myagg.bf.addLong(inputColumn.time[i]);
        }
    }

    public static class ValueProcessorDecimal
    extends ValueProcessor {
        private byte[] scratchBuffer = new byte[79];

        @Override
        protected void processValue(Aggregation myagg, ColumnVector columnVector, int i) {
            DecimalColumnVector inputColumn = (DecimalColumnVector)columnVector;
            int startIdx = inputColumn.vector[i].toBytes(this.scratchBuffer);
            myagg.bf.addBytes(this.scratchBuffer, startIdx, this.scratchBuffer.length - startIdx);
        }
    }

    public static class ValueProcessorDouble
    extends ValueProcessor {
        @Override
        protected void processValue(Aggregation myagg, ColumnVector columnVector, int i) {
            DoubleColumnVector inputColumn = (DoubleColumnVector)columnVector;
            myagg.bf.addDouble(inputColumn.vector[i]);
        }
    }

    public static class ValueProcessorLong
    extends ValueProcessor {
        @Override
        protected void processValue(Aggregation myagg, ColumnVector columnVector, int i) {
            LongColumnVector inputColumn = (LongColumnVector)columnVector;
            myagg.bf.addLong(inputColumn.vector[i]);
        }
    }

    public static class ValueProcessorBytes
    extends ValueProcessor {
        @Override
        protected void processValue(Aggregation myagg, ColumnVector columnVector, int i) {
            BytesColumnVector inputColumn = (BytesColumnVector)columnVector;
            myagg.bf.addBytes(inputColumn.vector[i], inputColumn.start[i], inputColumn.length[i]);
        }
    }

    private static abstract class ValueProcessor {
        private ValueProcessor() {
        }

        protected abstract void processValue(Aggregation var1, ColumnVector var2, int var3);
    }

    private static final class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        BloomKFilter bf;

        public Aggregation(long expectedEntries) {
            this.bf = new BloomKFilter(expectedEntries);
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.bf.reset();
        }
    }
}

