/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.Text;

public class StringUnaryUDF
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final IUDFUnaryString func;
    private Text s;

    StringUnaryUDF(int colNum, int outputColumnNum, IUDFUnaryString func) {
        super(colNum, outputColumnNum);
        this.func = func;
        this.s = new Text();
    }

    public StringUnaryUDF() {
        this.func = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.inputColumnNum[0]];
        int[] sel = batch.selected;
        int n = batch.size;
        byte[][] vector = inputColVector.vector;
        int[] start = inputColVector.start;
        int[] length = inputColVector.length;
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[this.outputColumnNum];
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.initBuffer();
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.s.set(vector[0], start[0], length[0]);
                Text t = this.func.evaluate(this.s);
                StringUnaryUDF.setString(outputColVector, 0, t);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.s.set(vector[i], start[i], length[i]);
                        Text t = this.func.evaluate(this.s);
                        StringUnaryUDF.setString(outputColVector, i, t);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.s.set(vector[i], start[i], length[i]);
                        Text t = this.func.evaluate(this.s);
                        StringUnaryUDF.setString(outputColVector, i, t);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.s.set(vector[i], start[i], length[i]);
                    Text t = this.func.evaluate(this.s);
                    StringUnaryUDF.setString(outputColVector, i, t);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputColVector.isNull[i] = inputColVector.isNull[i];
                    if (inputColVector.isNull[i]) continue;
                    this.s.set(vector[i], start[i], length[i]);
                    Text t = this.func.evaluate(this.s);
                    StringUnaryUDF.setString(outputColVector, i, t);
                }
            } else {
                System.arraycopy(inputColVector.isNull, 0, outputColVector.isNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputColVector.isNull[i]) continue;
                    this.s.set(vector[i], start[i], length[i]);
                    Text t = this.func.evaluate(this.s);
                    StringUnaryUDF.setString(outputColVector, i, t);
                }
            }
        }
    }

    private static void setString(BytesColumnVector outputColVector, int i, Text t) {
        if (t == null) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
            return;
        }
        outputColVector.setVal(i, t.getBytes(), 0, t.getLength());
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.STRING_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN});
        return b.build();
    }

    public static interface IUDFUnaryString {
        public Text evaluate(Text var1);
    }
}

