/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class StringGroupConcatColCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;

    public StringGroupConcatColCol(int colNum1, int colNum2, int outputColumnNum) {
        super(colNum1, colNum2, outputColumnNum);
    }

    public StringGroupConcatColCol() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inV1 = (BytesColumnVector)batch.cols[this.inputColumnNum[0]];
        BytesColumnVector inV2 = (BytesColumnVector)batch.cols[this.inputColumnNum[1]];
        BytesColumnVector outV = (BytesColumnVector)batch.cols[this.outputColumnNum];
        boolean[] outputIsNull = outV.isNull;
        int[] sel = batch.selected;
        int n = batch.size;
        byte[][] vector1 = inV1.vector;
        byte[][] vector2 = inV2.vector;
        int[] len1 = inV1.length;
        int[] len2 = inV2.length;
        int[] start1 = inV1.start;
        int[] start2 = inV2.start;
        if (n == 0) {
            return;
        }
        outV.initBuffer();
        outV.isRepeating = false;
        if (inV1.noNulls && !inV2.noNulls) {
            outV.noNulls = false;
            if (inV2.isRepeating) {
                if (inV2.isNull[0]) {
                    outV.isNull[0] = true;
                    outV.isRepeating = true;
                    return;
                }
            } else {
                StringGroupConcatColCol.propagateNulls(batch.selectedInUse, n, sel, (ColumnVector)inV2, (ColumnVector)outV);
            }
            if (inV1.isRepeating && inV2.isRepeating) {
                if (!inV2.isNull[0]) {
                    outV.setConcat(0, vector1[0], start1[0], len1[0], vector2[0], start2[0], len2[0]);
                }
                outV.isRepeating = true;
            } else if (inV1.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inV2.isNull[i]) continue;
                        outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inV2.isNull[i]) continue;
                        outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                    }
                }
            } else if (inV2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inV2.isNull[i]) continue;
                        outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inV2.isNull[i]) continue;
                        outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (inV2.isNull[i]) continue;
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (inV2.isNull[i]) continue;
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
                }
            }
        } else if (!inV1.noNulls && inV2.noNulls) {
            outV.noNulls = false;
            if (inV1.isRepeating) {
                outV.isRepeating = true;
                outV.isNull[0] = true;
                return;
            }
            StringGroupConcatColCol.propagateNulls(batch.selectedInUse, n, sel, (ColumnVector)inV1, (ColumnVector)outV);
            if (inV1.isRepeating && inV2.isRepeating) {
                if (!inV1.isNull[0]) {
                    outV.setConcat(0, vector1[0], start1[0], len1[0], vector2[0], start2[0], len2[0]);
                }
                outV.isRepeating = true;
            } else if (inV1.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inV1.isNull[0]) continue;
                        outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inV1.isNull[0]) continue;
                        outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                    }
                }
            } else if (inV2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inV1.isNull[i]) continue;
                        outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inV1.isNull[i]) continue;
                        outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (inV1.isNull[i]) continue;
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (inV1.isNull[i]) continue;
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
                }
            }
        } else if (!inV1.noNulls && !inV2.noNulls) {
            outV.noNulls = false;
            if (inV1.isRepeating && inV2.isRepeating) {
                outV.isNull[0] = inV1.isNull[0] || inV2.isNull[0];
                outV.isRepeating = true;
                if (outV.isNull[0]) {
                    return;
                }
            } else if (inV1.isRepeating) {
                if (inV1.isNull[0]) {
                    outV.isRepeating = true;
                    outV.isNull[0] = true;
                    return;
                }
                outV.isRepeating = false;
                StringGroupConcatColCol.propagateNulls(batch.selectedInUse, n, sel, (ColumnVector)inV2, (ColumnVector)outV);
            } else if (inV2.isRepeating) {
                if (inV2.isNull[0]) {
                    outV.isRepeating = true;
                    outV.isNull[0] = true;
                    return;
                }
                outV.isRepeating = false;
                StringGroupConcatColCol.propagateNulls(batch.selectedInUse, n, sel, (ColumnVector)inV1, (ColumnVector)outV);
            } else {
                StringGroupConcatColCol.propagateNullsCombine(batch.selectedInUse, n, sel, (ColumnVector)inV1, (ColumnVector)inV2, outV);
            }
            if (inV1.isRepeating && inV2.isRepeating) {
                if (!inV1.isNull[0] && !inV2.isNull[0]) {
                    outV.setConcat(0, vector1[0], start1[0], len1[0], vector2[0], start2[0], len2[0]);
                }
                outV.isRepeating = true;
            } else if (inV1.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inV1.isNull[0] || inV2.isNull[i]) continue;
                        outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inV1.isNull[0] || inV2.isNull[i]) continue;
                        outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                    }
                }
            } else if (inV2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (inV1.isNull[i] || inV2.isNull[0]) continue;
                        outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inV1.isNull[i] || inV2.isNull[0]) continue;
                        outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (inV1.isNull[i] || inV2.isNull[i]) continue;
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (inV1.isNull[i] || inV2.isNull[i]) continue;
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
                }
            }
        } else if (inV1.isRepeating && inV2.isRepeating) {
            outV.setConcat(0, vector1[0], start1[0], len1[0], vector2[0], start2[0], len2[0]);
            outV.isRepeating = true;
            outputIsNull[0] = false;
        } else if (inV1.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = false;
                    outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                }
            } else {
                Arrays.fill(outputIsNull, 0, n, false);
                for (int i = 0; i != n; ++i) {
                    outV.setConcat(i, vector1[0], start1[0], len1[0], vector2[i], start2[i], len2[i]);
                }
            }
        } else if (inV2.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = false;
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                }
            } else {
                Arrays.fill(outputIsNull, 0, n, false);
                for (int i = 0; i != n; ++i) {
                    outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[0], start2[0], len2[0]);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputIsNull[i] = false;
                outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
            }
        } else {
            Arrays.fill(outputIsNull, 0, n, false);
            for (int i = 0; i != n; ++i) {
                outV.setConcat(i, vector1[i], start1[i], len1[i], vector2[i], start2[i], len2[i]);
            }
        }
    }

    private static void propagateNullsCombine(boolean selectedInUse, int n, int[] sel, ColumnVector inV1, ColumnVector inV2, BytesColumnVector outV) {
        if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outV.isNull[i] = inV1.isNull[i] || inV2.isNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outV.isNull[i] = inV1.isNull[i] || inV2.isNull[i];
            }
        }
    }

    private static void propagateNulls(boolean selectedInUse, int n, int[] sel, ColumnVector inV, ColumnVector outV) {
        if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outV.isNull[i] = inV.isNull[i];
            }
        } else {
            System.arraycopy(inV.isNull, 0, outV.isNull, 0, n);
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", " + this.getColumnParamString(1, this.inputColumnNum[1]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

