/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprStringGroupColumnStringGroupColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;

    public IfExprStringGroupColumnStringGroupColumn(int arg1Column, int arg2Column, int arg3Column, int outputColumnNum) {
        super(arg1Column, arg2Column, arg3Column, outputColumnNum);
    }

    public IfExprStringGroupColumnStringGroupColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.inputColumnNum[0]];
        BytesColumnVector arg2ColVector = (BytesColumnVector)batch.cols[this.inputColumnNum[1]];
        BytesColumnVector arg3ColVector = (BytesColumnVector)batch.cols[this.inputColumnNum[2]];
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.initBuffer();
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                arg2ColVector.copySelected(batch.selectedInUse, sel, n, (ColumnVector)outputColVector);
            } else {
                arg3ColVector.copySelected(batch.selectedInUse, sel, n, (ColumnVector)outputColVector);
            }
            return;
        }
        arg2ColVector.flatten(batch.selectedInUse, sel, n);
        arg3ColVector.flatten(batch.selectedInUse, sel, n);
        outputColVector.noNulls = false;
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (vector1[i] == 1L) {
                        if (!arg2ColVector.isNull[i]) {
                            outputColVector.setVal(i, arg2ColVector.vector[i], arg2ColVector.start[i], arg2ColVector.length[i]);
                        }
                    } else if (!arg3ColVector.isNull[i]) {
                        outputColVector.setVal(i, arg3ColVector.vector[i], arg3ColVector.start[i], arg3ColVector.length[i]);
                    }
                    outputIsNull[i] = vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (vector1[i] == 1L) {
                        if (!arg2ColVector.isNull[i]) {
                            outputColVector.setVal(i, arg2ColVector.vector[i], arg2ColVector.start[i], arg2ColVector.length[i]);
                        }
                    } else if (!arg3ColVector.isNull[i]) {
                        outputColVector.setVal(i, arg3ColVector.vector[i], arg3ColVector.start[i], arg3ColVector.length[i]);
                    }
                    outputIsNull[i] = vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    if (!arg2ColVector.isNull[i]) {
                        outputColVector.setVal(i, arg2ColVector.vector[i], arg2ColVector.start[i], arg2ColVector.length[i]);
                    }
                } else if (!arg3ColVector.isNull[i]) {
                    outputColVector.setVal(i, arg3ColVector.vector[i], arg3ColVector.start[i], arg3ColVector.length[i]);
                }
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    if (!arg2ColVector.isNull[i]) {
                        outputColVector.setVal(i, arg2ColVector.vector[i], arg2ColVector.start[i], arg2ColVector.length[i]);
                    }
                } else if (!arg3ColVector.isNull[i]) {
                    outputColVector.setVal(i, arg3ColVector.vector[i], arg3ColVector.start[i], arg3ColVector.length[i]);
                }
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
            }
        }
        arg2ColVector.unFlatten();
        arg3ColVector.unFlatten();
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", " + this.getColumnParamString(1, this.inputColumnNum[1]) + ", " + this.getColumnParamString(2, this.inputColumnNum[2]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY_BINARY, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY_BINARY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

