/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncLongToDouble;

public class FuncPowerLongToDouble
extends MathFuncLongToDouble {
    private static final long serialVersionUID = 1L;
    private final double power;

    public FuncPowerLongToDouble(int colNum, double scalarVal, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.power = scalarVal;
    }

    public FuncPowerLongToDouble() {
        this.power = -1.0;
    }

    @Override
    public double func(long l) {
        return Math.pow(l, this.power);
    }

    public double getPower() {
        return this.power;
    }

    @Override
    protected void cleanup(DoubleColumnVector outputColVector, int[] sel, boolean selectedInUse, int n) {
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }
}

