/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hive.common.format.datetime.HiveSqlDateTimeFormatter;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToDate;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;

public class CastStringToDateWithFormat
extends CastStringToDate {
    private static final long serialVersionUID = 1L;
    private HiveSqlDateTimeFormatter formatter;

    public CastStringToDateWithFormat() {
    }

    public CastStringToDateWithFormat(int inputColumn, byte[] patternBytes, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
        if (patternBytes == null) {
            throw new IllegalStateException("Tried to cast (<string> to date with format <pattern>), but <pattern> not found");
        }
        this.formatter = new HiveSqlDateTimeFormatter(new String(patternBytes, StandardCharsets.UTF_8), true);
    }

    @Override
    protected void evaluate(LongColumnVector outputColVector, BytesColumnVector inV, int i) {
        String dateString = new String(inV.vector[i], inV.start[i], inV.length[i], StandardCharsets.UTF_8);
        Date date = this.formatter.parseDate(dateString.replaceAll("\u0000", ""));
        if (date != null) {
            outputColVector.vector[i] = DateWritableV2.dateToDays(date);
        } else {
            super.setNull(outputColVector, i);
        }
    }
}

