/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class CastDecimalToDecimal
extends VectorExpression {
    private static final long serialVersionUID = 1L;

    public CastDecimalToDecimal(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
    }

    public CastDecimalToDecimal() {
    }

    protected void convert(DecimalColumnVector outputColVector, DecimalColumnVector inputColVector, int i) {
        outputColVector.set(i, inputColVector.vector[i]);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DecimalColumnVector inputColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum[0]];
        int[] sel = batch.selected;
        int n = batch.size;
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[this.outputColumnNum];
        boolean[] outputIsNull = outputColVector.isNull;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            outputColVector.isRepeating = true;
            if (inputColVector.noNulls || !inputColVector.isNull[0]) {
                outputColVector.isNull[0] = false;
                this.convert(outputColVector, inputColVector, 0);
            } else {
                outputColVector.isNull[0] = true;
                outputColVector.noNulls = false;
            }
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.convert(outputColVector, inputColVector, i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.convert(outputColVector, inputColVector, i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.convert(outputColVector, inputColVector, i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputColVector.isNull[i]) {
                    outputColVector.isNull[i] = false;
                    this.convert(outputColVector, inputColVector, i);
                    continue;
                }
                outputColVector.isNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!inputColVector.isNull[i]) {
                    outputColVector.isNull[i] = false;
                    this.convert(outputColVector, inputColVector, i);
                    continue;
                }
                outputColVector.isNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.DECIMAL}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN});
        return b.build();
    }
}

