/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import hiveexec.com.google.common.base.Preconditions;
import hiveexec.org.joda.time.Chronology;
import hiveexec.org.joda.time.DateTime;
import hiveexec.org.joda.time.DateTimeFieldType;
import hiveexec.org.joda.time.LocalDateTime;
import hiveexec.org.joda.time.MutableDateTime;
import hiveexec.org.joda.time.ReadWritableInstant;
import hiveexec.org.joda.time.chrono.ISOChronology;
import hiveexec.org.joda.time.format.DateTimeFormat;
import hiveexec.org.joda.time.format.DateTimeFormatter;
import hiveexec.org.joda.time.format.DateTimeFormatterBuilder;
import hiveexec.org.joda.time.format.DateTimeParser;
import hiveexec.org.joda.time.format.DateTimeParserBucket;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.common.type.Timestamp;

public class TimestampParser {
    protected static final String[] stringArray = new String[0];
    protected static final String millisFormatString = "millis";
    protected static final DateTime startingDateValue = new DateTime(1970, 1, 1, 0, 0, 0, 0, (Chronology)ISOChronology.getInstanceUTC());
    protected String[] formatStrings = null;
    protected DateTimeFormatter fmt = null;

    public TimestampParser() {
    }

    public TimestampParser(TimestampParser tsParser) {
        this(tsParser.formatStrings == null ? null : Arrays.copyOf(tsParser.formatStrings, tsParser.formatStrings.length));
    }

    public TimestampParser(List<String> formatStrings) {
        this(formatStrings == null ? null : formatStrings.toArray(stringArray));
    }

    public TimestampParser(String[] formatStrings) {
        this.formatStrings = formatStrings;
        if (formatStrings != null && formatStrings.length > 0) {
            DateTimeParser[] parsers = new DateTimeParser[formatStrings.length];
            for (int idx = 0; idx < formatStrings.length; ++idx) {
                String formatString = formatStrings[idx];
                parsers[idx] = formatString.equalsIgnoreCase(millisFormatString) ? new MillisDateFormatParser() : DateTimeFormat.forPattern((String)formatString).getParser();
            }
            this.fmt = new DateTimeFormatterBuilder().append(null, parsers).toFormatter().withDefaultYear(1970);
        }
    }

    public Timestamp parseTimestamp(String strValue) throws IllegalArgumentException {
        Optional<Timestamp> parsed;
        if (this.fmt != null && (parsed = this.tryParseWithFormat(strValue)).isPresent()) {
            return parsed.get();
        }
        return Timestamp.valueOf(strValue);
    }

    private Optional<Timestamp> tryParseWithFormat(String strValue) {
        Preconditions.checkState(this.fmt != null);
        if (startingDateValue != null) {
            MutableDateTime mdt = new MutableDateTime((Object)startingDateValue, (Chronology)ISOChronology.getInstanceUTC());
            int ret = this.fmt.parseInto((ReadWritableInstant)mdt, strValue, 0);
            if (ret == strValue.length()) {
                return Optional.of(Timestamp.ofEpochMilli(mdt.getMillis()));
            }
            return Optional.empty();
        }
        try {
            LocalDateTime dt = this.fmt.parseLocalDateTime(strValue);
            return Optional.of(Timestamp.ofEpochMilli(dt.toDateTime(ISOChronology.getInstanceUTC().getZone()).getMillis()));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static class MillisDateFormatParser
    implements DateTimeParser {
        private static final ThreadLocal<Matcher> numericMatcher = new ThreadLocal<Matcher>(){

            @Override
            protected Matcher initialValue() {
                return Pattern.compile("(-?\\d+)(\\.\\d+)?$").matcher("");
            }
        };
        private static final DateTimeFieldType[] dateTimeFields = new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.monthOfYear(), DateTimeFieldType.dayOfMonth(), DateTimeFieldType.hourOfDay(), DateTimeFieldType.minuteOfHour(), DateTimeFieldType.secondOfMinute(), DateTimeFieldType.millisOfSecond()};

        public int estimateParsedLength() {
            return 13;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            String substr = text.substring(position);
            Matcher matcher = numericMatcher.get();
            matcher.reset(substr);
            if (!matcher.matches()) {
                return -1;
            }
            long millis = Long.parseLong(matcher.group(1));
            DateTime dt = new DateTime(millis, (Chronology)ISOChronology.getInstanceUTC());
            for (DateTimeFieldType field : dateTimeFields) {
                bucket.saveField(field, dt.get(field));
            }
            return substr.length();
        }
    }
}

