/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.DateValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.DoubleValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.HiveDecimalValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.LongValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.StringValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.TimestampLocalTZValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.TimestampValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.ValueBoundaryScanner;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

abstract class SingleValueBoundaryScanner
extends ValueBoundaryScanner {
    OrderExpressionDef expressionDef;

    public SingleValueBoundaryScanner(BoundaryDef start, BoundaryDef end, OrderExpressionDef expressionDef) {
        super(start, end);
        this.expressionDef = expressionDef;
    }

    @Override
    public int computeStart(int rowIdx, PTFPartition p) throws HiveException {
        switch (this.start.getDirection()) {
            case PRECEDING: {
                return this.computeStartPreceding(rowIdx, p);
            }
            case CURRENT: {
                return this.computeStartCurrentRow(rowIdx, p);
            }
        }
        return this.computeStartFollowing(rowIdx, p);
    }

    protected int computeStartPreceding(int rowIdx, PTFPartition p) throws HiveException {
        int amt = this.start.getAmt();
        if (amt == Integer.MAX_VALUE) {
            return 0;
        }
        Object sortKey = this.computeValue(p.getAt(rowIdx));
        if (sortKey == null) {
            if (this.expressionDef.getOrder() == PTFInvocationSpec.Order.ASC) {
                return 0;
            }
            while (sortKey == null && rowIdx >= 0) {
                if (--rowIdx < 0) continue;
                sortKey = this.computeValue(p.getAt(rowIdx));
            }
            return rowIdx + 1;
        }
        Object rowVal = sortKey;
        int r = rowIdx;
        if (this.expressionDef.getOrder() == PTFInvocationSpec.Order.DESC) {
            while (r >= 0 && !this.isDistanceGreater(rowVal, sortKey, amt)) {
                if (--r < 0) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r + 1;
        }
        while (r >= 0 && !this.isDistanceGreater(sortKey, rowVal, amt)) {
            if (--r < 0) continue;
            rowVal = this.computeValue(p.getAt(r));
        }
        return r + 1;
    }

    protected int computeStartCurrentRow(int rowIdx, PTFPartition p) throws HiveException {
        Object sortKey = this.computeValue(p.getAt(rowIdx));
        if (sortKey == null) {
            while (sortKey == null && rowIdx >= 0) {
                if (--rowIdx < 0) continue;
                sortKey = this.computeValue(p.getAt(rowIdx));
            }
            return rowIdx + 1;
        }
        Object rowVal = sortKey;
        int r = rowIdx;
        while (r >= 0 && this.isEqual(rowVal, sortKey)) {
            if (--r < 0) continue;
            rowVal = this.computeValue(p.getAt(r));
        }
        return r + 1;
    }

    protected int computeStartFollowing(int rowIdx, PTFPartition p) throws HiveException {
        Object sortKey;
        int amt = this.start.getAmt();
        Object rowVal = sortKey = this.computeValue(p.getAt(rowIdx));
        int r = rowIdx;
        if (sortKey == null) {
            if (this.expressionDef.getOrder() == PTFInvocationSpec.Order.DESC) {
                return p.size();
            }
            while (r < p.size() && rowVal == null) {
                if (++r >= p.size()) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r;
        }
        if (this.expressionDef.getOrder() == PTFInvocationSpec.Order.DESC) {
            while (r < p.size() && !this.isDistanceGreater(sortKey, rowVal, amt)) {
                if (++r >= p.size()) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r;
        }
        while (r < p.size() && !this.isDistanceGreater(rowVal, sortKey, amt)) {
            if (++r >= p.size()) continue;
            rowVal = this.computeValue(p.getAt(r));
        }
        return r;
    }

    @Override
    public int computeEnd(int rowIdx, PTFPartition p) throws HiveException {
        switch (this.end.getDirection()) {
            case PRECEDING: {
                return this.computeEndPreceding(rowIdx, p);
            }
            case CURRENT: {
                return this.computeEndCurrentRow(rowIdx, p);
            }
        }
        return this.computeEndFollowing(rowIdx, p);
    }

    protected int computeEndPreceding(int rowIdx, PTFPartition p) throws HiveException {
        int amt = this.end.getAmt();
        Object sortKey = this.computeValue(p.getAt(rowIdx));
        if (sortKey == null) {
            if (this.expressionDef.getOrder() == PTFInvocationSpec.Order.DESC) {
                return p.size();
            }
            return 0;
        }
        Object rowVal = sortKey;
        int r = rowIdx;
        if (this.expressionDef.getOrder() == PTFInvocationSpec.Order.DESC) {
            while (r >= 0 && !this.isDistanceGreater(rowVal, sortKey, amt)) {
                if (--r < 0) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r + 1;
        }
        while (r >= 0 && !this.isDistanceGreater(sortKey, rowVal, amt)) {
            if (--r < 0) continue;
            rowVal = this.computeValue(p.getAt(r));
        }
        return r + 1;
    }

    protected int computeEndCurrentRow(int rowIdx, PTFPartition p) throws HiveException {
        Object sortKey = this.computeValue(p.getAt(rowIdx));
        if (sortKey == null) {
            while (sortKey == null && rowIdx < p.size()) {
                if (++rowIdx >= p.size()) continue;
                sortKey = this.computeValue(p.getAt(rowIdx));
            }
            return rowIdx;
        }
        Object rowVal = sortKey;
        int r = rowIdx;
        while (r < p.size() && this.isEqual(sortKey, rowVal)) {
            if (++r >= p.size()) continue;
            rowVal = this.computeValue(p.getAt(r));
        }
        return r;
    }

    protected int computeEndFollowing(int rowIdx, PTFPartition p) throws HiveException {
        Object sortKey;
        int amt = this.end.getAmt();
        if (amt == Integer.MAX_VALUE) {
            return p.size();
        }
        Object rowVal = sortKey = this.computeValue(p.getAt(rowIdx));
        int r = rowIdx;
        if (sortKey == null) {
            if (this.expressionDef.getOrder() == PTFInvocationSpec.Order.DESC) {
                return p.size();
            }
            while (r < p.size() && rowVal == null) {
                if (++r >= p.size()) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r;
        }
        if (this.expressionDef.getOrder() == PTFInvocationSpec.Order.DESC) {
            while (r < p.size() && !this.isDistanceGreater(sortKey, rowVal, amt)) {
                if (++r >= p.size()) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r;
        }
        while (r < p.size() && !this.isDistanceGreater(rowVal, sortKey, amt)) {
            if (++r >= p.size()) continue;
            rowVal = this.computeValue(p.getAt(r));
        }
        return r;
    }

    public Object computeValue(Object row) throws HiveException {
        Object o = this.expressionDef.getExprEvaluator().evaluate(row);
        return ObjectInspectorUtils.copyToStandardObject(o, this.expressionDef.getOI());
    }

    public abstract boolean isDistanceGreater(Object var1, Object var2, int var3);

    public abstract boolean isEqual(Object var1, Object var2);

    public static SingleValueBoundaryScanner getScanner(BoundaryDef start, BoundaryDef end, OrderDef orderDef) throws HiveException {
        if (orderDef.getExpressions().size() != 1) {
            throw new HiveException("Internal error: initializing SingleValueBoundaryScanner with multiple expression for sorting");
        }
        OrderExpressionDef exprDef = (OrderExpressionDef)orderDef.getExpressions().get(0);
        PrimitiveObjectInspector pOI = (PrimitiveObjectInspector)exprDef.getOI();
        switch (pOI.getPrimitiveCategory()) {
            case BYTE: 
            case INT: 
            case LONG: 
            case SHORT: {
                return new LongValueBoundaryScanner(start, end, exprDef);
            }
            case TIMESTAMP: {
                return new TimestampValueBoundaryScanner(start, end, exprDef);
            }
            case TIMESTAMPLOCALTZ: {
                return new TimestampLocalTZValueBoundaryScanner(start, end, exprDef);
            }
            case DOUBLE: 
            case FLOAT: {
                return new DoubleValueBoundaryScanner(start, end, exprDef);
            }
            case DECIMAL: {
                return new HiveDecimalValueBoundaryScanner(start, end, exprDef);
            }
            case DATE: {
                return new DateValueBoundaryScanner(start, end, exprDef);
            }
            case STRING: {
                return new StringValueBoundaryScanner(start, end, exprDef);
            }
        }
        throw new HiveException(String.format("Internal Error: attempt to setup a Window for datatype %s", new Object[]{pOI.getPrimitiveCategory()}));
    }
}

