/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.PTFTranslator;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFInputDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionEvaluator;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionResolver;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class MatchPath
extends TableFunctionEvaluator {
    private transient String patternStr;
    private transient SymbolsInfo symInfo;
    private transient String resultExprStr;
    private transient SymbolFunction syFn;
    private ResultExprInfo resultExprInfo;
    private HashMap<String, String> inputColumnNamesMap;
    public static final String PATHATTR_NAME = "tpath";

    @Override
    public void execute(PTFPartition.PTFPartitionIterator<Object> pItr, PTFPartition outP) throws HiveException {
        while (pItr.hasNext()) {
            Object iRow = pItr.next();
            SymbolFunctionResult syFnRes = SymbolFunction.match(this.syFn, iRow, pItr);
            if (!syFnRes.matches) continue;
            int sz = syFnRes.nextRow - (pItr.getIndex() - 1);
            Object selectListInput = MatchPath.getSelectListInput(iRow, this.tableDef.getInput().getOutputShape().getOI(), pItr, sz);
            ArrayList<Object> oRow = new ArrayList<Object>();
            for (ExprNodeEvaluator resExprEval : this.resultExprInfo.resultExprEvals) {
                oRow.add(resExprEval.evaluate(selectListInput));
            }
            outP.append(oRow);
        }
    }

    static void throwErrorWithSignature(String message) throws SemanticException {
        throw new SemanticException(String.format("MatchPath signature is: SymbolPattern, one or more SymbolName, expression pairs, the result expression as a select list. Error %s", message));
    }

    public HashMap<String, String> getInputColumnNames() {
        return this.inputColumnNamesMap;
    }

    public void setInputColumnNames(HashMap<String, String> inputColumnNamesMap) {
        this.inputColumnNamesMap = inputColumnNamesMap;
    }

    public ResultExprInfo getResultExprInfo() {
        return this.resultExprInfo;
    }

    public void setResultExprInfo(ResultExprInfo resultExprInfo) {
        this.resultExprInfo = resultExprInfo;
    }

    protected static RowResolver createSelectListRR(MatchPath evaluator, PTFInputDef inpDef) throws SemanticException {
        RowResolver rr = new RowResolver();
        RowResolver inputRR = inpDef.getOutputShape().getRr();
        evaluator.inputColumnNamesMap = new HashMap();
        ArrayList<String> inputColumnNames = new ArrayList<String>();
        ArrayList<ObjectInspector> inpColOIs = new ArrayList<ObjectInspector>();
        for (ColumnInfo inpCInfo : inputRR.getColumnInfos()) {
            ColumnInfo cInfo = new ColumnInfo(inpCInfo);
            String colAlias = cInfo.getAlias();
            String[] tabColAlias = inputRR.reverseLookup(inpCInfo.getInternalName());
            if (tabColAlias != null) {
                colAlias = tabColAlias[1];
            }
            ASTNode inExpr = null;
            inExpr = PTFTranslator.getASTNode((ColumnInfo)inpCInfo, (RowResolver)inputRR);
            if (inExpr != null) {
                rr.putExpression(inExpr, cInfo);
                colAlias = inExpr.toStringTree().toLowerCase();
            } else {
                colAlias = colAlias == null ? cInfo.getInternalName() : colAlias;
                rr.put(cInfo.getTabAlias(), colAlias, cInfo);
            }
            evaluator.inputColumnNamesMap.put(cInfo.getInternalName(), colAlias);
            inputColumnNames.add(colAlias);
            inpColOIs.add(cInfo.getObjectInspector());
        }
        StandardListObjectInspector pathAttrOI = ObjectInspectorFactory.getStandardListObjectInspector(ObjectInspectorFactory.getStandardStructObjectInspector(inputColumnNames, inpColOIs));
        ColumnInfo pathColumn = new ColumnInfo(PATHATTR_NAME, TypeInfoUtils.getTypeInfoFromObjectInspector(pathAttrOI), null, false, false);
        rr.put(null, PATHATTR_NAME, pathColumn);
        return rr;
    }

    protected static StructObjectInspector createSelectListOI(MatchPath evaluator, PTFInputDef inpDef) {
        StructObjectInspector inOI = inpDef.getOutputShape().getOI();
        ArrayList<String> inputColumnNames = new ArrayList<String>();
        ArrayList<String> selectListNames = new ArrayList<String>();
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>();
        for (StructField structField : inOI.getAllStructFieldRefs()) {
            String inputColName = evaluator.inputColumnNamesMap.get(structField.getFieldName());
            if (inputColName == null) continue;
            inputColumnNames.add(inputColName);
            selectListNames.add(structField.getFieldName());
            fieldOIs.add(structField.getFieldObjectInspector());
        }
        StandardListObjectInspector pathAttrOI = ObjectInspectorFactory.getStandardListObjectInspector(ObjectInspectorFactory.getStandardStructObjectInspector(inputColumnNames, fieldOIs));
        ArrayList<ObjectInspector> arrayList = new ArrayList<ObjectInspector>();
        arrayList.addAll(fieldOIs);
        arrayList.add(pathAttrOI);
        selectListNames.add(PATHATTR_NAME);
        return ObjectInspectorFactory.getStandardStructObjectInspector(selectListNames, arrayList);
    }

    public static Object getSelectListInput(Object currRow, ObjectInspector rowOI, PTFPartition.PTFPartitionIterator<Object> pItr, int sz) throws HiveException {
        ArrayList<ArrayList<Object>> oRow = new ArrayList<ArrayList<Object>>();
        List currRowAsStdObject = (List)ObjectInspectorUtils.copyToStandardObject(currRow, rowOI);
        oRow.addAll(currRowAsStdObject);
        oRow.add(MatchPath.getPath(currRow, rowOI, pItr, sz));
        return oRow;
    }

    public static ArrayList<Object> getPath(Object currRow, ObjectInspector rowOI, PTFPartition.PTFPartitionIterator<Object> pItr, int sz) throws HiveException {
        int idx = pItr.getIndex() - 1;
        ArrayList<Object> path = new ArrayList<Object>();
        path.add(ObjectInspectorUtils.copyToStandardObject(currRow, rowOI));
        for (int pSz = 1; pSz < sz && pItr.hasNext(); ++pSz) {
            currRow = pItr.next();
            path.add(ObjectInspectorUtils.copyToStandardObject(currRow, rowOI));
        }
        pItr.resetToIndex(idx);
        return path;
    }

    public static class ResultExpressionParser {
        String resultExprString;
        RowResolver selectListInputRowResolver;
        TypeCheckCtx selectListInputTypeCheckCtx;
        StructObjectInspector selectListInputOI;
        ArrayList<WindowingSpec.WindowExpressionSpec> selectSpec;
        ResultExprInfo resultExprInfo;

        public ResultExpressionParser(String resultExprString, RowResolver selectListInputRowResolver) {
            this.resultExprString = resultExprString;
            this.selectListInputRowResolver = selectListInputRowResolver;
        }

        public void translate() throws SemanticException, HiveException {
            this.setupSelectListInputInfo();
            this.fixResultExprString();
            this.parse();
            this.validateSelectExpr();
            this.buildSelectListEvaluators();
        }

        public ResultExprInfo getResultExprInfo() {
            return this.resultExprInfo;
        }

        private void buildSelectListEvaluators() throws SemanticException, HiveException {
            this.resultExprInfo = new ResultExprInfo();
            this.resultExprInfo.resultExprEvals = new ArrayList();
            this.resultExprInfo.resultExprNames = new ArrayList();
            this.resultExprInfo.resultExprNodes = new ArrayList();
            ArrayList<ObjectInspector> selectListExprOIs = new ArrayList<ObjectInspector>();
            int i = 0;
            for (WindowingSpec.WindowExpressionSpec expr : this.selectSpec) {
                String selectColName = expr.getAlias();
                ASTNode selectColumnNode = expr.getExpression();
                ExprNodeDesc selectColumnExprNode = ResultExpressionParser.buildExprNode(selectColumnNode, this.selectListInputTypeCheckCtx);
                ExprNodeEvaluator selectColumnExprEval = ExprNodeEvaluatorFactory.get((ExprNodeDesc)selectColumnExprNode);
                ObjectInspector selectColumnOI = null;
                selectColumnOI = selectColumnExprEval.initialize((ObjectInspector)this.selectListInputOI);
                selectColName = this.getColumnName(selectColName, selectColumnExprNode, i);
                this.resultExprInfo.resultExprEvals.add(selectColumnExprEval);
                selectListExprOIs.add(selectColumnOI);
                this.resultExprInfo.resultExprNodes.add(selectColumnExprNode);
                this.resultExprInfo.resultExprNames.add(selectColName);
                ++i;
            }
            this.resultExprInfo.resultOI = ObjectInspectorFactory.getStandardStructObjectInspector(this.resultExprInfo.resultExprNames, selectListExprOIs);
        }

        private void setupSelectListInputInfo() throws SemanticException {
            this.selectListInputTypeCheckCtx = new TypeCheckCtx(this.selectListInputRowResolver);
            this.selectListInputTypeCheckCtx.setUnparseTranslator(null);
            this.selectListInputOI = PTFTranslator.getStandardStructOI((RowResolver)this.selectListInputRowResolver);
        }

        private void fixResultExprString() {
            String r = this.resultExprString.trim();
            if (r.length() < 6 || !r.substring(0, 6).toLowerCase().equals("select")) {
                r = "select " + r;
            }
            this.resultExprString = r;
        }

        private void parse() throws SemanticException {
            this.selectSpec = SemanticAnalyzer.parseSelect((String)this.resultExprString);
        }

        private void validateSelectExpr() throws SemanticException {
            for (WindowingSpec.WindowExpressionSpec expr : this.selectSpec) {
                PTFTranslator.validateNoLeadLagInValueBoundarySpec((ASTNode)expr.getExpression());
            }
        }

        private String getColumnName(String alias, ExprNodeDesc exprNode, int colIdx) {
            if (alias != null) {
                return alias;
            }
            if (exprNode instanceof ExprNodeColumnDesc) {
                ExprNodeColumnDesc colDesc = (ExprNodeColumnDesc)exprNode;
                return colDesc.getColumn();
            }
            return "matchpath_col_" + colIdx;
        }

        public static ExprNodeDesc buildExprNode(ASTNode expr, TypeCheckCtx typeCheckCtx) throws SemanticException {
            Map map = TypeCheckProcFactory.genExprNode((ASTNode)expr, (TypeCheckCtx)typeCheckCtx);
            ExprNodeDesc desc = (ExprNodeDesc)map.get(expr);
            if (desc == null) {
                String errMsg = typeCheckCtx.getError();
                if (errMsg == null) {
                    errMsg = "Error in parsing ";
                }
                throw new SemanticException(errMsg);
            }
            return desc;
        }
    }

    public static class SymbolParser {
        String patternStr;
        String[] symbols;
        HashMap<String, Object[]> symbolExprEvalMap;
        ArrayList<SymbolFunction> symbolFunctions;
        Chain symbolFnChain;

        public SymbolParser(String patternStr, ArrayList<String> symbolNames, ArrayList<ExprNodeEvaluator> symbolExprEvals, ArrayList<ObjectInspector> symbolExprOIs) {
            this.patternStr = patternStr;
            this.symbolExprEvalMap = new HashMap();
            int sz = symbolNames.size();
            for (int i = 0; i < sz; ++i) {
                String symbolName = symbolNames.get(i);
                ExprNodeEvaluator symbolExprEval = symbolExprEvals.get(i);
                ObjectInspector symbolExprOI = symbolExprOIs.get(i);
                this.symbolExprEvalMap.put(symbolName.toLowerCase(), new Object[]{symbolExprEval, symbolExprOI});
            }
        }

        public SymbolFunction getSymbolFunction() {
            return this.symbolFnChain;
        }

        public void parse() throws SemanticException {
            this.symbols = this.patternStr.split("\\.");
            this.symbolFunctions = new ArrayList();
            for (String symbol : this.symbols) {
                boolean isStar = symbol.endsWith("*");
                boolean isPlus = symbol.endsWith("+");
                symbol = isStar || isPlus ? symbol.substring(0, symbol.length() - 1) : symbol;
                Object[] symbolDetails = this.symbolExprEvalMap.get(symbol.toLowerCase());
                if (symbolDetails == null) {
                    throw new SemanticException(String.format("Unknown Symbol %s", symbol));
                }
                ExprNodeEvaluator symbolExprEval = (ExprNodeEvaluator)symbolDetails[0];
                ObjectInspector symbolExprOI = (ObjectInspector)symbolDetails[1];
                SymbolFunction sFn = new Symbol(symbolExprEval, symbolExprOI);
                if (isStar) {
                    sFn = new Star(sFn);
                } else if (isPlus) {
                    sFn = new Plus(sFn);
                }
                this.symbolFunctions.add(sFn);
            }
            this.symbolFnChain = new Chain(this.symbolFunctions);
        }
    }

    public static class SymbolFunctionResult {
        public boolean matches;
        public int nextRow;
    }

    public static class Chain
    extends SymbolFunction {
        ArrayList<SymbolFunction> components;

        public Chain(ArrayList<SymbolFunction> components) {
            this.components = components;
        }

        @Override
        protected SymbolFunctionResult match(Object row, PTFPartition.PTFPartitionIterator<Object> pItr) throws HiveException {
            SymbolFunctionResult componentResult = null;
            for (SymbolFunction sFn : this.components) {
                if (row != null) {
                    componentResult = sFn.match(row, pItr);
                    if (!componentResult.matches) {
                        this.result.matches = false;
                        this.result.nextRow = componentResult.nextRow;
                        return this.result;
                    }
                    row = pItr.resetToIndex(componentResult.nextRow);
                    continue;
                }
                if (sFn.isOptional()) continue;
                this.result.matches = false;
                this.result.nextRow = componentResult.nextRow;
                return this.result;
            }
            this.result.matches = true;
            this.result.nextRow = componentResult.nextRow;
            return this.result;
        }

        @Override
        protected boolean isOptional() {
            return false;
        }
    }

    public static class Plus
    extends SymbolFunction {
        SymbolFunction symbolFn;

        public Plus(SymbolFunction symbolFn) {
            this.symbolFn = symbolFn;
        }

        @Override
        protected SymbolFunctionResult match(Object row, PTFPartition.PTFPartitionIterator<Object> pItr) throws HiveException {
            SymbolFunctionResult rowResult = this.symbolFn.match(row, pItr);
            if (!rowResult.matches) {
                this.result.matches = false;
                this.result.nextRow = pItr.getIndex() - 1;
                return this.result;
            }
            this.result.matches = true;
            while (rowResult.matches && pItr.hasNext()) {
                row = pItr.next();
                rowResult = this.symbolFn.match(row, pItr);
            }
            this.result.nextRow = pItr.getIndex() - 1;
            return this.result;
        }

        @Override
        protected boolean isOptional() {
            return false;
        }
    }

    public static class Star
    extends SymbolFunction {
        SymbolFunction symbolFn;

        public Star(SymbolFunction symbolFn) {
            this.symbolFn = symbolFn;
        }

        @Override
        protected SymbolFunctionResult match(Object row, PTFPartition.PTFPartitionIterator<Object> pItr) throws HiveException {
            this.result.matches = true;
            SymbolFunctionResult rowResult = this.symbolFn.match(row, pItr);
            while (rowResult.matches && pItr.hasNext()) {
                row = pItr.next();
                rowResult = this.symbolFn.match(row, pItr);
            }
            this.result.nextRow = pItr.getIndex();
            if (pItr.hasNext()) {
                --this.result.nextRow;
            }
            return this.result;
        }

        @Override
        protected boolean isOptional() {
            return true;
        }
    }

    public static class Symbol
    extends SymbolFunction {
        ExprNodeEvaluator symbolExprEval;
        ObjectInspectorConverters.Converter converter;

        public Symbol(ExprNodeEvaluator symbolExprEval, ObjectInspector symbolOI) {
            this.symbolExprEval = symbolExprEval;
            this.converter = ObjectInspectorConverters.getConverter(symbolOI, (ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector);
        }

        @Override
        protected SymbolFunctionResult match(Object row, PTFPartition.PTFPartitionIterator<Object> pItr) throws HiveException {
            Object val = null;
            val = this.symbolExprEval.evaluate(row);
            val = this.converter.convert(val);
            this.result.matches = (Boolean)val;
            this.result.nextRow = pItr.getIndex();
            return this.result;
        }

        @Override
        protected boolean isOptional() {
            return false;
        }
    }

    public static abstract class SymbolFunction {
        SymbolFunctionResult result = new SymbolFunctionResult();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static SymbolFunctionResult match(SymbolFunction syFn, Object row, PTFPartition.PTFPartitionIterator<Object> pItr) throws HiveException {
            int resetToIdx = pItr.getIndex() - 1;
            try {
                SymbolFunctionResult symbolFunctionResult = syFn.match(row, pItr);
                return symbolFunctionResult;
            }
            finally {
                pItr.resetToIndex(resetToIdx);
            }
        }

        protected abstract SymbolFunctionResult match(Object var1, PTFPartition.PTFPartitionIterator<Object> var2) throws HiveException;

        protected abstract boolean isOptional();
    }

    public static class ResultExprInfo {
        ArrayList<String> resultExprNames;
        ArrayList<ExprNodeDesc> resultExprNodes;
        private transient ArrayList<ExprNodeEvaluator> resultExprEvals;
        private transient StructObjectInspector resultOI;

        public ArrayList<String> getResultExprNames() {
            return this.resultExprNames;
        }

        public void setResultExprNames(ArrayList<String> resultExprNames) {
            this.resultExprNames = resultExprNames;
        }

        public ArrayList<ExprNodeDesc> getResultExprNodes() {
            return this.resultExprNodes;
        }

        public void setResultExprNodes(ArrayList<ExprNodeDesc> resultExprNodes) {
            this.resultExprNodes = resultExprNodes;
        }
    }

    static class SymbolsInfo {
        int sz;
        ArrayList<ExprNodeDesc> symbolExprsDecs;
        ArrayList<ExprNodeEvaluator> symbolExprsEvaluators;
        ArrayList<ObjectInspector> symbolExprsOIs;
        ArrayList<String> symbolExprsNames;

        SymbolsInfo(int sz) {
            this.sz = sz;
            this.symbolExprsEvaluators = new ArrayList(sz);
            this.symbolExprsOIs = new ArrayList(sz);
            this.symbolExprsNames = new ArrayList(sz);
            this.symbolExprsDecs = new ArrayList(sz);
        }

        void add(String name, PTFExpressionDef arg) {
            this.symbolExprsNames.add(name);
            this.symbolExprsEvaluators.add(arg.getExprEvaluator());
            this.symbolExprsOIs.add(arg.getOI());
            this.symbolExprsDecs.add(arg.getExprNode());
        }
    }

    public static class MatchPathResolver
    extends TableFunctionResolver {
        @Override
        protected TableFunctionEvaluator createEvaluator(PTFDesc ptfDesc, PartitionedTableFunctionDef tDef) {
            return new MatchPath();
        }

        @Override
        public void setupOutputOI() throws SemanticException {
            int argsNum;
            MatchPath evaluator = (MatchPath)this.getEvaluator();
            PartitionedTableFunctionDef tDef = evaluator.getTableDef();
            List args = tDef.getArgs();
            int n = argsNum = args == null ? 0 : args.size();
            if (argsNum < 4) {
                MatchPath.throwErrorWithSignature("at least 4 arguments required");
            }
            this.validateAndSetupPatternStr(evaluator, args);
            this.validateAndSetupSymbolInfo(evaluator, args, argsNum);
            this.validateAndSetupResultExprStr(evaluator, args, argsNum);
            this.setupSymbolFunctionChain(evaluator);
            RowResolver selectListInputRR = MatchPath.createSelectListRR(evaluator, tDef.getInput());
            ResultExpressionParser resultExprParser = new ResultExpressionParser(evaluator.resultExprStr, selectListInputRR);
            try {
                resultExprParser.translate();
            }
            catch (HiveException he) {
                throw new SemanticException(he);
            }
            evaluator.resultExprInfo = resultExprParser.getResultExprInfo();
            StructObjectInspector OI = evaluator.resultExprInfo.resultOI;
            this.setOutputOI(OI);
        }

        @Override
        public List<String> getReferencedColumns() throws SemanticException {
            MatchPath matchPath = (MatchPath)this.evaluator;
            ArrayList<String> columns = new ArrayList<String>();
            for (ExprNodeDesc exprNode : ((MatchPath)matchPath).resultExprInfo.resultExprNodes) {
                Utilities.mergeUniqElems(columns, (List)exprNode.getCols());
            }
            for (ExprNodeDesc exprNode : ((MatchPath)matchPath).symInfo.symbolExprsDecs) {
                Utilities.mergeUniqElems(columns, (List)exprNode.getCols());
            }
            return columns;
        }

        private void validateAndSetupPatternStr(MatchPath evaluator, List<PTFExpressionDef> args) throws SemanticException {
            PTFExpressionDef symboPatternArg = args.get(0);
            ObjectInspector symbolPatternArgOI = symboPatternArg.getOI();
            if (!ObjectInspectorUtils.isConstantObjectInspector(symbolPatternArgOI) || symbolPatternArgOI.getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveObjectInspector)symbolPatternArgOI).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                MatchPath.throwErrorWithSignature("Currently the symbol Pattern must be a Constant String.");
            }
            evaluator.patternStr = ((ConstantObjectInspector)symbolPatternArgOI).getWritableConstantValue().toString();
        }

        private void validateAndSetupSymbolInfo(MatchPath evaluator, List<PTFExpressionDef> args, int argsNum) throws SemanticException {
            int symbolArgsSz = argsNum - 2;
            if (symbolArgsSz % 2 != 0) {
                MatchPath.throwErrorWithSignature("Symbol Name, Expression need to be specified in pairs: there are odd number of symbol args");
            }
            evaluator.symInfo = new SymbolsInfo(symbolArgsSz / 2);
            for (int i = 1; i <= symbolArgsSz; i += 2) {
                PTFExpressionDef symbolNameArg = args.get(i);
                ObjectInspector symbolNameArgOI = symbolNameArg.getOI();
                if (!ObjectInspectorUtils.isConstantObjectInspector(symbolNameArgOI) || symbolNameArgOI.getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveObjectInspector)symbolNameArgOI).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                    MatchPath.throwErrorWithSignature(String.format("Currently a Symbol Name(%s) must be a Constant String", symbolNameArg.getExpressionTreeString()));
                }
                String symbolName = ((ConstantObjectInspector)symbolNameArgOI).getWritableConstantValue().toString();
                PTFExpressionDef symolExprArg = args.get(i + 1);
                ObjectInspector symolExprArgOI = symolExprArg.getOI();
                if (symolExprArgOI.getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveObjectInspector)symolExprArgOI).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN) {
                    MatchPath.throwErrorWithSignature(String.format("Currently a Symbol Expression(%s) must be a boolean expression", symolExprArg.getExpressionTreeString()));
                }
                evaluator.symInfo.add(symbolName, symolExprArg);
            }
        }

        private void validateAndSetupResultExprStr(MatchPath evaluator, List<PTFExpressionDef> args, int argsNum) throws SemanticException {
            PTFExpressionDef resultExprArg = args.get(argsNum - 1);
            ObjectInspector resultExprArgOI = resultExprArg.getOI();
            if (!ObjectInspectorUtils.isConstantObjectInspector(resultExprArgOI) || resultExprArgOI.getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveObjectInspector)resultExprArgOI).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                MatchPath.throwErrorWithSignature("Currently the result Expr parameter must be a Constant String.");
            }
            evaluator.resultExprStr = ((ConstantObjectInspector)resultExprArgOI).getWritableConstantValue().toString();
        }

        private void setupSymbolFunctionChain(MatchPath evaluator) throws SemanticException {
            SymbolParser syP = new SymbolParser(evaluator.patternStr, ((MatchPath)evaluator).symInfo.symbolExprsNames, ((MatchPath)evaluator).symInfo.symbolExprsEvaluators, ((MatchPath)evaluator).symInfo.symbolExprsOIs);
            syP.parse();
            evaluator.syFn = syP.getSymbolFunction();
        }

        @Override
        public boolean transformsRawInput() {
            return false;
        }

        @Override
        public void initializeOutputOI() throws HiveException {
            try {
                MatchPath evaluator = (MatchPath)this.getEvaluator();
                PartitionedTableFunctionDef tDef = evaluator.getTableDef();
                List args = tDef.getArgs();
                int argsNum = args.size();
                this.validateAndSetupPatternStr(evaluator, args);
                this.validateAndSetupSymbolInfo(evaluator, args, argsNum);
                this.validateAndSetupResultExprStr(evaluator, args, argsNum);
                this.setupSymbolFunctionChain(evaluator);
                StructObjectInspector selectListInputOI = MatchPath.createSelectListOI(evaluator, tDef.getInput());
                ResultExprInfo resultExprInfo = evaluator.resultExprInfo;
                ArrayList<ObjectInspector> selectListExprOIs = new ArrayList<ObjectInspector>();
                resultExprInfo.resultExprEvals = new ArrayList();
                for (int i = 0; i < resultExprInfo.resultExprNodes.size(); ++i) {
                    ExprNodeDesc selectColumnExprNode = resultExprInfo.resultExprNodes.get(i);
                    ExprNodeEvaluator selectColumnExprEval = ExprNodeEvaluatorFactory.get((ExprNodeDesc)selectColumnExprNode);
                    ObjectInspector selectColumnOI = selectColumnExprEval.initialize((ObjectInspector)selectListInputOI);
                    resultExprInfo.resultExprEvals.add(selectColumnExprEval);
                    selectListExprOIs.add(selectColumnOI);
                }
                resultExprInfo.resultOI = ObjectInspectorFactory.getStandardStructObjectInspector(resultExprInfo.resultExprNames, selectListExprOIs);
                this.setOutputOI(resultExprInfo.resultOI);
            }
            catch (SemanticException se) {
                throw new HiveException(se);
            }
        }

        public ArrayList<String> getOutputColumnNames() {
            MatchPath evaluator = (MatchPath)this.getEvaluator();
            return evaluator.resultExprInfo.getResultExprNames();
        }
    }
}

