/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import org.apache.hadoop.hive.ql.plan.ColStatistics;

public class ColStatistics {
    private String colName;
    private String colType;
    private long countDistint;
    private long numNulls;
    private double avgColLen;
    private long numTrues;
    private long numFalses;
    private Range range;
    private boolean isPrimaryKey;
    private boolean isEstimated;

    public ColStatistics(String colName, String colType) {
        this.setColumnName(colName);
        this.setColumnType(colType);
        this.setPrimaryKey(false);
        this.setIsEstimated(false);
    }

    public ColStatistics() {
        this(null, null);
    }

    public String getColumnName() {
        return this.colName;
    }

    public void setColumnName(String colName) {
        this.colName = colName;
    }

    public String getColumnType() {
        return this.colType;
    }

    public void setColumnType(String colType) {
        this.colType = colType;
    }

    public long getCountDistint() {
        return this.countDistint;
    }

    public void setCountDistint(long countDistint) {
        this.countDistint = countDistint;
    }

    public long getNumNulls() {
        return this.numNulls;
    }

    public void setNumNulls(long numNulls) {
        this.numNulls = numNulls;
    }

    public double getAvgColLen() {
        return this.avgColLen;
    }

    public void setAvgColLen(double avgColLen) {
        this.avgColLen = avgColLen;
    }

    public long getNumTrues() {
        return this.numTrues;
    }

    public void setNumTrues(long numTrues) {
        this.numTrues = numTrues;
    }

    public long getNumFalses() {
        return this.numFalses;
    }

    public void setNumFalses(long numFalses) {
        this.numFalses = numFalses;
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Number minVal, Number maxVal) {
        this.range = new Range(minVal, maxVal);
    }

    public void setRange(Range r) {
        this.range = r;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" colName: ");
        sb.append(this.colName);
        sb.append(" colType: ");
        sb.append(this.colType);
        sb.append(" countDistincts: ");
        sb.append(this.countDistint);
        sb.append(" numNulls: ");
        sb.append(this.numNulls);
        sb.append(" avgColLen: ");
        sb.append(this.avgColLen);
        sb.append(" numTrues: ");
        sb.append(this.numTrues);
        sb.append(" numFalses: ");
        sb.append(this.numFalses);
        if (this.range != null) {
            sb.append(" ");
            sb.append(this.range);
        }
        sb.append(" isPrimaryKey: ");
        sb.append(this.isPrimaryKey);
        sb.append(" isEstimated: ");
        sb.append(this.isEstimated);
        return sb.toString();
    }

    public ColStatistics clone() {
        ColStatistics clone = new ColStatistics(this.colName, this.colType);
        clone.setAvgColLen(this.avgColLen);
        clone.setCountDistint(this.countDistint);
        clone.setNumNulls(this.numNulls);
        clone.setNumTrues(this.numTrues);
        clone.setNumFalses(this.numFalses);
        clone.setPrimaryKey(this.isPrimaryKey);
        clone.setIsEstimated(this.isEstimated);
        if (this.range != null) {
            clone.setRange(this.range.clone());
        }
        return clone;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setPrimaryKey(boolean isPrimaryKey) {
        this.isPrimaryKey = isPrimaryKey;
    }

    public void setIsEstimated(boolean isEstimated) {
        this.isEstimated = isEstimated;
    }

    public boolean isEstimated() {
        return this.isEstimated;
    }
}

