/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import hiveexec.com.google.common.base.Function;
import hiveexec.com.google.common.base.Splitter;
import hiveexec.com.google.common.collect.ImmutableList;
import hiveexec.com.google.common.collect.ImmutableMap;
import hiveexec.com.google.common.collect.Lists;
import hiveexec.com.google.common.collect.Maps;
import hiveexec.com.google.common.collect.Sets;
import hiveexec.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.jdo.JDODataStoreException;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexBuilder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.common.log.InPlaceUpdate;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.io.HdfsUtils;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.SynchronizedMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleRequest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventRequestData;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMNullablePool;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionTask;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.CheckConstraint;
import org.apache.hadoop.hive.ql.metadata.CheckJDOException;
import org.apache.hadoop.hive.ql.metadata.DefaultConstraint;
import org.apache.hadoop.hive.ql.metadata.ForeignKeyInfo;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMaterializedViewsRegistry;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.NotNullConstraint;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hadoop.hive.ql.metadata.SessionHiveMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.StorageHandlerInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.UniqueConstraint;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveAugmentMaterializationRule;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.session.CreateTableAutomaticGrant;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.TxnIdUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive {
    private static final Logger LOG = LoggerFactory.getLogger((String)"hive.ql.metadata.Hive");
    private HiveConf conf = null;
    private IMetaStoreClient metaStoreClient;
    private SynchronizedMetaStoreClient syncMetaStoreClient;
    private UserGroupInformation owner;
    private final ConcurrentHashMap<String, Long> metaCallTimeMap = new ConcurrentHashMap();
    private static ThreadLocal<Hive> hiveDB = new ThreadLocal<Hive>(){

        @Override
        protected Hive initialValue() {
            return null;
        }

        @Override
        public synchronized void remove() {
            if (this.get() != null) {
                ((Hive)this.get()).close();
            }
            super.remove();
        }
    };
    private static final AtomicInteger didRegisterAllFuncs = new AtomicInteger(0);
    private static final int REG_FUNCS_NO = 0;
    private static final int REG_FUNCS_DONE = 2;
    private static final int REG_FUNCS_PENDING = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAllFunctionsOnce() throws HiveException {
        boolean breakLoop = false;
        block21: while (!breakLoop) {
            int val = didRegisterAllFuncs.get();
            switch (val) {
                case 0: {
                    if (!didRegisterAllFuncs.compareAndSet(val, 1)) continue block21;
                    breakLoop = true;
                    continue block21;
                }
                case 1: {
                    AtomicInteger atomicInteger = didRegisterAllFuncs;
                    synchronized (atomicInteger) {
                        try {
                            didRegisterAllFuncs.wait(100L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }
                case 2: {
                    return;
                }
            }
            throw new AssertionError(val);
        }
        try {
            this.reloadFunctions();
            didRegisterAllFuncs.compareAndSet(1, 2);
        }
        catch (Exception e) {
            LOG.warn("Failed to register all functions.", (Throwable)e);
            didRegisterAllFuncs.compareAndSet(1, 0);
            throw new HiveException(e);
        }
        finally {
            AtomicInteger atomicInteger = didRegisterAllFuncs;
            synchronized (atomicInteger) {
                didRegisterAllFuncs.notifyAll();
            }
        }
    }

    public void reloadFunctions() throws HiveException {
        HashSet registryFunctions = new HashSet(FunctionRegistry.getFunctionNames((String)".+\\..+"));
        for (org.apache.hadoop.hive.metastore.api.Function function : this.getAllFunctions()) {
            String functionName = function.getFunctionName();
            try {
                LOG.info("Registering function " + functionName + " " + function.getClassName());
                String qualFunc = FunctionUtils.qualifyFunctionName(functionName, function.getDbName());
                FunctionRegistry.registerPermanentFunction((String)qualFunc, (String)function.getClassName(), (boolean)false, (FunctionInfo.FunctionResource[])FunctionTask.toFunctionResource((List)function.getResourceUris()));
                registryFunctions.remove(qualFunc);
            }
            catch (Exception e) {
                LOG.warn("Failed to register persistent function " + functionName + ":" + function.getClassName() + ". Ignore and continue.");
            }
        }
        for (String functionName : registryFunctions) {
            try {
                FunctionRegistry.unregisterPermanentFunction((String)functionName);
            }
            catch (Exception e) {
                LOG.warn("Failed to unregister persistent function " + functionName + "on reload. Ignore and continue.");
            }
        }
    }

    public static Hive get(Configuration c, Class<?> clazz) throws HiveException {
        return Hive.get(c instanceof HiveConf ? (HiveConf)c : new HiveConf(c, clazz));
    }

    public static Hive get(HiveConf c) throws HiveException {
        return Hive.getInternal(c, false, false, true);
    }

    public static Hive getWithFastCheck(HiveConf c) throws HiveException {
        return Hive.getWithFastCheck(c, true);
    }

    public static Hive getWithFastCheck(HiveConf c, boolean doRegisterAllFns) throws HiveException {
        return Hive.getInternal(c, false, true, doRegisterAllFns);
    }

    public static Hive getWithoutRegisterFns(HiveConf c) throws HiveException {
        return Hive.getInternal(c, false, false, false);
    }

    private static Hive getInternal(HiveConf c, boolean needsRefresh, boolean isFastCheck, boolean doRegisterAllFns) throws HiveException {
        Hive db = hiveDB.get();
        if (db == null || !db.isCurrentUserOwner() || needsRefresh || c != null && !Hive.isCompatible(db, c, isFastCheck)) {
            db = Hive.create(c, false, db, doRegisterAllFns);
        }
        if (c != null) {
            db.conf = c;
        }
        return db;
    }

    private static Hive create(HiveConf c, boolean needsRefresh, Hive db, boolean doRegisterAllFns) throws HiveException {
        if (db != null) {
            LOG.debug("Creating new db. db = " + db + ", needsRefresh = " + needsRefresh + ", db.isCurrentUserOwner = " + db.isCurrentUserOwner());
            db.close();
        }
        Hive.closeCurrent();
        if (c == null) {
            c = Hive.createHiveConf();
        }
        c.set("fs.scheme.class", "dfs");
        Hive newdb = new Hive(c, doRegisterAllFns);
        hiveDB.set(newdb);
        return newdb;
    }

    private static HiveConf createHiveConf() {
        SessionState session = SessionState.get();
        return session == null ? new HiveConf(Hive.class) : session.getConf();
    }

    private static boolean isCompatible(Hive db, HiveConf c, boolean isFastCheck) {
        if (isFastCheck) {
            return !(db.metaStoreClient != null && !db.metaStoreClient.isSameConfObj((Configuration)c) || db.syncMetaStoreClient != null && !db.syncMetaStoreClient.isSameConfObj((Configuration)c));
        }
        return !(db.metaStoreClient != null && !db.metaStoreClient.isCompatibleWith((Configuration)c) || db.syncMetaStoreClient != null && !db.syncMetaStoreClient.isCompatibleWith((Configuration)c));
    }

    public static Hive get() throws HiveException {
        return Hive.get(true);
    }

    public static Hive get(boolean doRegisterAllFns) throws HiveException {
        return Hive.getInternal(null, false, false, doRegisterAllFns);
    }

    public static Hive get(HiveConf c, boolean needsRefresh) throws HiveException {
        return Hive.getInternal(c, needsRefresh, false, true);
    }

    public static void set(Hive hive) {
        hiveDB.set(hive);
    }

    public static void closeCurrent() {
        hiveDB.remove();
    }

    private Hive(HiveConf c, boolean doRegisterAllFns) throws HiveException {
        this.conf = c;
        if (doRegisterAllFns) {
            this.registerAllFunctionsOnce();
        }
    }

    private boolean isCurrentUserOwner() throws HiveException {
        try {
            return this.owner == null || this.owner.equals((Object)UserGroupInformation.getCurrentUser());
        }
        catch (IOException e) {
            throw new HiveException("Error getting current user: " + e.getMessage(), e);
        }
    }

    private void close() {
        LOG.debug("Closing current thread's connection to Hive Metastore.");
        if (this.metaStoreClient != null) {
            this.metaStoreClient.close();
            this.metaStoreClient = null;
        }
        if (this.syncMetaStoreClient != null) {
            this.syncMetaStoreClient.close();
        }
        if (this.owner != null) {
            this.owner = null;
        }
    }

    public void createDatabase(Database db, boolean ifNotExist) throws AlreadyExistsException, HiveException {
        try {
            this.getMSC().createDatabase(db);
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExist) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createDatabase(Database db) throws AlreadyExistsException, HiveException {
        this.createDatabase(db, false);
    }

    public void dropDatabase(String name) throws HiveException, NoSuchObjectException {
        this.dropDatabase(name, true, false, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws HiveException, NoSuchObjectException {
        this.dropDatabase(name, deleteData, ignoreUnknownDb, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().dropDatabase(name, deleteData, ignoreUnknownDb, cascade);
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat) throws HiveException {
        this.createTable(tableName, columns, partCols, fileInputFormat, fileOutputFormat, -1, null);
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat, int bucketCount, List<String> bucketCols) throws HiveException {
        this.createTable(tableName, columns, partCols, fileInputFormat, fileOutputFormat, bucketCount, bucketCols, null);
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat, int bucketCount, List<String> bucketCols, Map<String, String> parameters) throws HiveException {
        if (columns == null) {
            throw new HiveException("columns not specified for table " + tableName);
        }
        Table tbl = this.newTable(tableName);
        tbl.setInputFormatClass(fileInputFormat.getName());
        tbl.setOutputFormatClass(fileOutputFormat.getName());
        for (String col : columns) {
            FieldSchema field = new FieldSchema(col, "string", "default");
            tbl.getCols().add(field);
        }
        if (partCols != null) {
            for (String partCol : partCols) {
                FieldSchema part = new FieldSchema();
                part.setName(partCol);
                part.setType("string");
                tbl.getPartCols().add(part);
            }
        }
        tbl.setSerializationLib(LazySimpleSerDe.class.getName());
        tbl.setNumBuckets(bucketCount);
        tbl.setBucketCols(bucketCols);
        if (parameters != null) {
            tbl.setParameters(parameters);
        }
        this.createTable(tbl);
    }

    public void alterTable(Table newTbl, EnvironmentContext environmentContext) throws HiveException {
        this.alterTable(newTbl.getDbName(), newTbl.getTableName(), newTbl, false, environmentContext);
    }

    public void alterTable(String fullyQlfdTblName, Table newTbl, EnvironmentContext environmentContext) throws HiveException {
        this.alterTable(fullyQlfdTblName, newTbl, false, environmentContext);
    }

    public void alterTable(String fullyQlfdTblName, Table newTbl, boolean cascade, EnvironmentContext environmentContext) throws HiveException {
        String[] names = Utilities.getDbTableName((String)fullyQlfdTblName);
        this.alterTable(names[0], names[1], newTbl, cascade, environmentContext);
    }

    public void alterTable(String dbName, String tblName, Table newTbl, boolean cascade, EnvironmentContext environmentContext) throws HiveException {
        try {
            if (newTbl.getParameters() != null) {
                newTbl.getParameters().remove("transient_lastDdlTime");
            }
            newTbl.checkValidity(this.conf);
            if (environmentContext == null) {
                environmentContext = new EnvironmentContext();
            }
            if (cascade) {
                environmentContext.putToProperties("CASCADE", "true");
            }
            this.getMSC().alter_table_with_environmentContext(dbName, tblName, newTbl.getTTable(), environmentContext);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter table. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter table. " + e.getMessage(), e);
        }
    }

    public void updateCreationMetadata(String dbName, String tableName, CreationMetadata cm) throws HiveException {
        try {
            this.getMSC().updateCreationMetadata(dbName, tableName, cm);
        }
        catch (TException e) {
            throw new HiveException("Unable to update creation metadata " + e.getMessage(), e);
        }
    }

    public void alterPartition(String tblName, Partition newPart, EnvironmentContext environmentContext) throws InvalidOperationException, HiveException {
        String[] names = Utilities.getDbTableName((String)tblName);
        this.alterPartition(names[0], names[1], newPart, environmentContext);
    }

    public void alterPartition(String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws InvalidOperationException, HiveException {
        try {
            this.validatePartition(newPart);
            String location = newPart.getLocation();
            if (location != null) {
                location = Utilities.getQualifiedPath((HiveConf)this.conf, (Path)new Path(location));
                newPart.setLocation(location);
            }
            this.getSynchronizedMSC().alter_partition(dbName, tblName, newPart.getTPartition(), environmentContext);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
    }

    private void validatePartition(Partition newPart) throws HiveException {
        if (newPart.getParameters() != null) {
            newPart.getParameters().remove("transient_lastDdlTime");
        }
        newPart.checkValidity();
    }

    public void alterPartitions(String tblName, List<Partition> newParts, EnvironmentContext environmentContext) throws InvalidOperationException, HiveException {
        String[] names = Utilities.getDbTableName((String)tblName);
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> newTParts = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
        try {
            for (Partition tmpPart : newParts) {
                String location;
                if (tmpPart.getParameters() != null) {
                    tmpPart.getParameters().remove("transient_lastDdlTime");
                }
                if ((location = tmpPart.getLocation()) != null) {
                    location = Utilities.getQualifiedPath((HiveConf)this.conf, (Path)new Path(location));
                    tmpPart.setLocation(location);
                }
                newTParts.add(tmpPart.getTPartition());
            }
            this.getMSC().alter_partitions(names[0], names[1], newTParts, environmentContext);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter partition. " + e.getMessage(), e);
        }
    }

    public void renamePartition(Table tbl, Map<String, String> oldPartSpec, Partition newPart) throws HiveException {
        try {
            LinkedHashMap<String, String> newPartSpec = newPart.getSpec();
            if (oldPartSpec.keySet().size() != tbl.getPartCols().size() || newPartSpec.keySet().size() != tbl.getPartCols().size()) {
                throw new HiveException("Unable to rename partition to the same name: number of partition cols don't match. ");
            }
            if (!oldPartSpec.keySet().equals(newPartSpec.keySet())) {
                throw new HiveException("Unable to rename partition to the same name: old and new partition cols don't match. ");
            }
            ArrayList<String> pvals = new ArrayList<String>();
            for (FieldSchema field : tbl.getPartCols()) {
                String val = oldPartSpec.get(field.getName());
                if (val == null || val.length() == 0) {
                    throw new HiveException("get partition: Value for key " + field.getName() + " is null or empty");
                }
                if (val == null) continue;
                pvals.add(val);
            }
            this.getMSC().renamePartition(tbl.getDbName(), tbl.getTableName(), pvals, newPart.getTPartition());
        }
        catch (InvalidOperationException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), e);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), e);
        }
        catch (TException e) {
            throw new HiveException("Unable to rename partition. " + e.getMessage(), e);
        }
    }

    public void alterDatabase(String dbName, Database db) throws HiveException {
        try {
            this.getMSC().alterDatabase(dbName, db);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter database " + dbName + ". " + e.getMessage(), e);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Database " + dbName + " does not exists.", e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter database " + dbName + ". " + e.getMessage(), e);
        }
    }

    public void createTable(Table tbl) throws HiveException {
        this.createTable(tbl, false);
    }

    public void createTable(Table tbl, boolean ifNotExists, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) throws HiveException {
        try {
            CreateTableAutomaticGrant grants;
            if (tbl.getDbName() == null || "".equals(tbl.getDbName().trim())) {
                tbl.setDbName(SessionState.get().getCurrentDatabase());
            }
            if (tbl.getCols().size() == 0 || tbl.getSd().getColsSize() == 0) {
                tbl.setFields(HiveMetaStoreUtils.getFieldsFromDeserializer((String)tbl.getTableName(), (Deserializer)tbl.getDeserializer()));
            }
            tbl.checkValidity(this.conf);
            if (tbl.getParameters() != null) {
                tbl.getParameters().remove("transient_lastDdlTime");
            }
            org.apache.hadoop.hive.metastore.api.Table tTbl = tbl.getTTable();
            PrincipalPrivilegeSet principalPrivs = new PrincipalPrivilegeSet();
            SessionState ss = SessionState.get();
            if (ss != null && (grants = ss.getCreateTableGrants()) != null) {
                principalPrivs.setUserPrivileges(grants.getUserGrants());
                principalPrivs.setGroupPrivileges(grants.getGroupGrants());
                principalPrivs.setRolePrivileges(grants.getRoleGrants());
                tTbl.setPrivileges(principalPrivs);
            }
            if (primaryKeys == null && foreignKeys == null && uniqueConstraints == null && notNullConstraints == null && defaultConstraints == null && checkConstraints == null) {
                this.getMSC().createTable(tTbl);
            } else {
                this.getMSC().createTableWithConstraints(tTbl, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints);
            }
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExists) {
                throw new HiveException(e);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createTable(Table tbl, boolean ifNotExists) throws HiveException {
        this.createTable(tbl, ifNotExists, null, null, null, null, null, null);
    }

    public static List<FieldSchema> getFieldsFromDeserializerForMsStorage(Table tbl, Deserializer deserializer) throws SerDeException, MetaException {
        List schema = HiveMetaStoreUtils.getFieldsFromDeserializer((String)tbl.getTableName(), (Deserializer)deserializer);
        for (FieldSchema field : schema) {
            field.setType("<derived from deserializer>");
        }
        return schema;
    }

    public void dropTable(String tableName, boolean ifPurge) throws HiveException {
        String[] names = Utilities.getDbTableName((String)tableName);
        this.dropTable(names[0], names[1], true, true, ifPurge);
    }

    public void dropTable(String tableName) throws HiveException {
        this.dropTable(tableName, false);
    }

    public void dropTable(String dbName, String tableName) throws HiveException {
        this.dropTable(dbName, tableName, true, true, false);
    }

    public void dropTable(String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTab) throws HiveException {
        this.dropTable(dbName, tableName, deleteData, ignoreUnknownTab, false);
    }

    public void dropTable(String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws HiveException {
        try {
            this.getMSC().dropTable(dbName, tableName, deleteData, ignoreUnknownTab, ifPurge);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw new HiveException(e);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void truncateTable(String dbDotTableName, Map<String, String> partSpec) throws HiveException {
        try {
            Table table = this.getTable(dbDotTableName, true);
            List<String> partNames = null == partSpec ? null : this.getPartitionNames(table.getDbName(), table.getTableName(), partSpec, (short)-1);
            this.getMSC().truncateTable(table.getDbName(), table.getTableName(), partNames);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public Table getTable(String tableName) throws HiveException {
        return this.getTable(tableName, true);
    }

    public Table getTable(String tableName, boolean throwException) throws HiveException {
        String[] names = Utilities.getDbTableName((String)tableName);
        return this.getTable(names[0], names[1], throwException);
    }

    public Table getTable(String dbName, String tableName) throws HiveException {
        if (tableName.contains(".")) {
            String[] names = Utilities.getDbTableName((String)tableName);
            return this.getTable(names[0], names[1], true);
        }
        return this.getTable(dbName, tableName, true);
    }

    public Table getTable(String dbName, String tableName, boolean throwException) throws HiveException {
        if (tableName == null || tableName.equals("")) {
            throw new HiveException("empty table creation??");
        }
        org.apache.hadoop.hive.metastore.api.Table tTable = null;
        try {
            tTable = this.getMSC().getTable(dbName, tableName);
        }
        catch (NoSuchObjectException e) {
            if (throwException) {
                LOG.error("Table " + dbName + "." + tableName + " not found: " + e.getMessage());
                throw new InvalidTableException(tableName);
            }
            return null;
        }
        catch (Exception e) {
            throw new HiveException("Unable to fetch table " + tableName + ". " + e.getMessage(), e);
        }
        if (!TableType.VIRTUAL_VIEW.toString().equals(tTable.getTableType())) {
            char[] b;
            String sf;
            Map parameters = tTable.getSd().getParameters();
            String string = sf = parameters != null ? (String)parameters.get("serialization.format") : null;
            if (sf != null && (b = sf.toCharArray()).length == 1 && b[0] < '\n') {
                parameters.put("serialization.format", Integer.toString(b[0]));
            }
            if (MetadataTypedColumnsetSerDe.class.getName().equals(tTable.getSd().getSerdeInfo().getSerializationLib()) && tTable.getSd().getColsSize() > 0 && ((FieldSchema)tTable.getSd().getCols().get(0)).getType().indexOf(60) == -1) {
                tTable.getSd().getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
            }
        }
        return new Table(tTable);
    }

    public List<String> getAllTables() throws HiveException {
        return this.getTablesByType(SessionState.get().getCurrentDatabase(), null, null);
    }

    public List<String> getAllTables(String dbName) throws HiveException {
        return this.getTablesByType(dbName, ".*", null);
    }

    public List<Table> getAllTableObjects(String dbName) throws HiveException {
        return this.getTableObjects(dbName, ".*", null);
    }

    public List<String> getAllMaterializedViews(String dbName) throws HiveException {
        return this.getTablesByType(dbName, ".*", TableType.MATERIALIZED_VIEW);
    }

    public List<Table> getAllMaterializedViewObjects(String dbName) throws HiveException {
        return this.getTableObjects(dbName, ".*", TableType.MATERIALIZED_VIEW);
    }

    private List<Table> getTableObjects(String dbName, String pattern, TableType tableType) throws HiveException {
        try {
            return Lists.transform(this.getMSC().getTableObjectsByName(dbName, this.getTablesByType(dbName, pattern, tableType)), new Function<org.apache.hadoop.hive.metastore.api.Table, Table>(){

                @Override
                public Table apply(org.apache.hadoop.hive.metastore.api.Table table) {
                    return new Table(table);
                }
            });
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private List<Table> getTableObjects(String dbName, List<String> tableNames) throws HiveException {
        try {
            return Lists.transform(this.getMSC().getTableObjectsByName(dbName, tableNames), new Function<org.apache.hadoop.hive.metastore.api.Table, Table>(){

                @Override
                public Table apply(org.apache.hadoop.hive.metastore.api.Table table) {
                    return new Table(table);
                }
            });
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getTablesByPattern(String tablePattern) throws HiveException {
        return this.getTablesByType(SessionState.get().getCurrentDatabase(), tablePattern, null);
    }

    public List<String> getTablesByPattern(String dbName, String tablePattern) throws HiveException {
        return this.getTablesByType(dbName, tablePattern, null);
    }

    public List<String> getTablesForDb(String database, String tablePattern) throws HiveException {
        return this.getTablesByType(database, tablePattern, null);
    }

    public List<String> getTablesByType(String dbName, String pattern, TableType type) throws HiveException {
        if (dbName == null) {
            dbName = SessionState.get().getCurrentDatabase();
        }
        try {
            if (type != null) {
                if (pattern != null) {
                    return this.getMSC().getTables(dbName, pattern, type);
                }
                return this.getMSC().getTables(dbName, ".*", type);
            }
            if (pattern != null) {
                return this.getMSC().getTables(dbName, pattern);
            }
            return this.getMSC().getTables(dbName, ".*");
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<RelOptMaterialization> getAllValidMaterializedViews(List<String> tablesUsed, boolean forceMVContentsUpToDate) throws HiveException {
        ArrayList<RelOptMaterialization> result = new ArrayList<RelOptMaterialization>();
        try {
            for (String dbName : this.getMSC().getAllDatabases()) {
                List<String> materializedViewNames = this.getMaterializedViewsForRewriting(dbName);
                if (materializedViewNames.isEmpty()) continue;
                result.addAll(this.getValidMaterializedViews(dbName, materializedViewNames, tablesUsed, forceMVContentsUpToDate));
            }
            return result;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<RelOptMaterialization> getValidMaterializedView(String dbName, String materializedViewName, List<String> tablesUsed, boolean forceMVContentsUpToDate) throws HiveException {
        return this.getValidMaterializedViews(dbName, ImmutableList.of(materializedViewName), tablesUsed, forceMVContentsUpToDate);
    }

    private List<RelOptMaterialization> getValidMaterializedViews(String dbName, List<String> materializedViewNames, List<String> tablesUsed, boolean forceMVContentsUpToDate) throws HiveException {
        String validTxnsList = this.conf.get("hive.txn.valid.txns");
        ValidTxnWriteIdList currentTxnWriteIds = SessionState.get().getTxnMgr().getValidWriteIds(tablesUsed, validTxnsList);
        boolean tryIncrementalRewriting = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_INCREMENTAL);
        boolean tryIncrementalRebuild = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REBUILD_INCREMENTAL);
        long defaultDiff = HiveConf.getTimeVar(this.conf, HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_TIME_WINDOW, TimeUnit.MILLISECONDS);
        long currentTime = System.currentTimeMillis();
        try {
            ArrayList<RelOptMaterialization> result = new ArrayList<RelOptMaterialization>();
            List<Table> materializedViewTables = this.getTableObjects(dbName, materializedViewNames);
            for (Table materializedViewTable : materializedViewTables) {
                RelNode viewScan;
                RelOptHiveTable cachedMaterializedViewTable;
                RelOptMaterialization materialization;
                boolean ignore;
                String timeWindowString = materializedViewTable.getProperty("rewriting.time.window");
                long diff = StringUtils.isEmpty((String)timeWindowString) ? defaultDiff : HiveConf.toTime(timeWindowString, HiveConf.getDefaultTimeUnit(HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_REWRITING_TIME_WINDOW), TimeUnit.MILLISECONDS);
                CreationMetadata creationMetadata = materializedViewTable.getCreationMetadata();
                boolean outdated = false;
                if (diff < 0L) {
                    outdated = forceMVContentsUpToDate;
                } else if (forceMVContentsUpToDate || diff == 0L || creationMetadata.getMaterializationTime() < currentTime - diff) {
                    if (currentTxnWriteIds == null) {
                        LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as we could not obtain current txn ids");
                        continue;
                    }
                    if (creationMetadata.getValidTxnList() == null || creationMetadata.getValidTxnList().isEmpty()) {
                        LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as we could not obtain materialization txn ids");
                        continue;
                    }
                    ignore = false;
                    ValidTxnWriteIdList mvTxnWriteIds = new ValidTxnWriteIdList(creationMetadata.getValidTxnList());
                    for (String qName : tablesUsed) {
                        if (!creationMetadata.getTablesUsed().contains(qName)) continue;
                        ValidWriteIdList tableCurrentWriteIds = currentTxnWriteIds.getTableValidWriteIdList(qName);
                        if (tableCurrentWriteIds == null) {
                            LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as it is outdated and cannot be considered for  rewriting because it uses non-transactional table " + qName);
                            ignore = true;
                            break;
                        }
                        ValidWriteIdList tableWriteIds = mvTxnWriteIds.getTableValidWriteIdList(qName);
                        if (tableWriteIds == null) {
                            LOG.warn("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as details about txn ids for table " + qName + " could not be found in " + mvTxnWriteIds);
                            ignore = true;
                            break;
                        }
                        if (outdated || TxnIdUtils.checkEquivalentWriteIds(tableCurrentWriteIds, tableWriteIds)) continue;
                        LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " contents are outdated");
                        outdated = true;
                    }
                    if (ignore) continue;
                }
                if (outdated) {
                    ignore = false;
                    if (forceMVContentsUpToDate && !tryIncrementalRebuild) {
                        ignore = true;
                    } else if (!forceMVContentsUpToDate && !tryIncrementalRewriting) {
                        ignore = true;
                    } else {
                        Materialization invalidationInfo = this.getMSC().getMaterializationInvalidationInfo(creationMetadata, this.conf.get("hive.txn.valid.txns"));
                        boolean bl = ignore = invalidationInfo == null || invalidationInfo.isSourceTablesUpdateDeleteModified();
                    }
                    if (ignore) {
                        LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " ignored for rewriting as its contents are outdated");
                        continue;
                    }
                }
                if ((materialization = HiveMaterializedViewsRegistry.get().getRewritingMaterializedView(dbName, materializedViewTable.getTableName())) != null && (cachedMaterializedViewTable = (viewScan = materialization.tableRel) instanceof Project ? (RelOptHiveTable)viewScan.getInput(0).getTable() : (RelOptHiveTable)viewScan.getTable()).getHiveTableMD().getCreateTime() == materializedViewTable.getCreateTime()) {
                    if (outdated) {
                        materialization = Hive.augmentMaterializationWithTimeInformation(materialization, validTxnsList, new ValidTxnWriteIdList(creationMetadata.getValidTxnList()));
                    }
                    result.add(materialization);
                    continue;
                }
                if (HiveMaterializedViewsRegistry.get().isInitialized()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Materialized view " + materializedViewTable.getFullyQualifiedName() + " was not in the cache");
                    }
                    if ((materialization = HiveMaterializedViewsRegistry.get().createMaterializedView(this.conf, materializedViewTable)) == null) continue;
                    if (outdated) {
                        materialization = Hive.augmentMaterializationWithTimeInformation(materialization, validTxnsList, new ValidTxnWriteIdList(creationMetadata.getValidTxnList()));
                    }
                    result.add(materialization);
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.info("Materialized view " + materializedViewTable.getFullyQualifiedName() + " was skipped because cache has not been loaded yet");
            }
            return result;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private static RelOptMaterialization augmentMaterializationWithTimeInformation(RelOptMaterialization materialization, String validTxnsList, ValidTxnWriteIdList materializationTxnList) throws LockException {
        final ArrayList tablesUsed = new ArrayList();
        new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (node instanceof TableScan) {
                    TableScan ts = (TableScan)node;
                    tablesUsed.add(((RelOptHiveTable)ts.getTable()).getHiveTableMD().getFullyQualifiedName());
                }
                super.visit(node, ordinal, parent);
            }
        }.go(materialization.queryRel);
        ValidTxnWriteIdList currentTxnList = SessionState.get().getTxnMgr().getValidWriteIds(tablesUsed, validTxnsList);
        RexBuilder rexBuilder = materialization.queryRel.getCluster().getRexBuilder();
        HepProgramBuilder augmentMaterializationProgram = new HepProgramBuilder().addRuleInstance((RelOptRule)new HiveAugmentMaterializationRule(rexBuilder, currentTxnList, materializationTxnList));
        HepPlanner augmentMaterializationPlanner = new HepPlanner(augmentMaterializationProgram.build());
        augmentMaterializationPlanner.setRoot(materialization.queryRel);
        RelNode modifiedQueryRel = augmentMaterializationPlanner.findBestExp();
        return new RelOptMaterialization(materialization.tableRel, modifiedQueryRel, null, materialization.qualifiedTableName);
    }

    private List<String> getMaterializedViewsForRewriting(String dbName) throws HiveException {
        try {
            return this.getMSC().getMaterializedViewsForRewriting(dbName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getAllDatabases() throws HiveException {
        try {
            return this.getMSC().getAllDatabases();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getDatabasesByPattern(String databasePattern) throws HiveException {
        try {
            return this.getMSC().getDatabases(databasePattern);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean grantPrivileges(PrivilegeBag privileges) throws HiveException {
        try {
            return this.getMSC().grant_privileges(privileges);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean revokePrivileges(PrivilegeBag privileges, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().revoke_privileges(privileges, grantOption);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean databaseExists(String dbName) throws HiveException {
        return this.getDatabase(dbName) != null;
    }

    public Database getDatabase(String dbName) throws HiveException {
        try {
            return this.getMSC().getDatabase(dbName);
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public Database getDatabase(String catName, String dbName) throws HiveException {
        try {
            return this.getMSC().getDatabase(catName, dbName);
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public Database getDatabaseCurrent() throws HiveException {
        String currentDb = SessionState.get().getCurrentDatabase();
        return this.getDatabase(currentDb);
    }

    public Partition loadPartition(Path loadPath, Table tbl, Map<String, String> partSpec, LoadTableDesc.LoadFileType loadFileType, boolean inheritTableSpecs, boolean isSkewedStoreAsSubdir, boolean isSrcLocal, boolean isAcidIUDoperation, boolean hasFollowingStatsTask, Long writeId, int stmtId, boolean isInsertOverwrite) throws HiveException {
        Path tblDataLocationPath = tbl.getDataLocation();
        boolean isMmTableWrite = AcidUtils.isInsertOnlyTable(tbl.getParameters());
        assert (tbl.getPath() != null) : "null==getPath() for " + tbl.getTableName();
        boolean isFullAcidTable = AcidUtils.isFullAcidTable((Table)tbl);
        boolean isTxnTable = AcidUtils.isTransactionalTable((Table)tbl);
        try {
            Partition oldPart = this.getPartition(tbl, partSpec, false);
            Path oldPartPath = oldPart != null ? oldPart.getDataLocation() : null;
            Path newPartPath = null;
            if (inheritTableSpecs) {
                FileSystem loadPathFS;
                FileSystem oldPartPathFS;
                Path partPath = new Path(tbl.getDataLocation(), Warehouse.makePartPath(partSpec));
                newPartPath = new Path(tblDataLocationPath.toUri().getScheme(), tblDataLocationPath.toUri().getAuthority(), partPath.toUri().getPath());
                if (oldPart != null && FileUtils.equalsFileSystem(oldPartPathFS = oldPartPath.getFileSystem((Configuration)this.getConf()), loadPathFS = loadPath.getFileSystem((Configuration)this.getConf()))) {
                    newPartPath = oldPartPath;
                }
            } else {
                newPartPath = oldPartPath;
            }
            PerfLogger perfLogger = SessionState.getPerfLogger();
            perfLogger.PerfLogBegin("MoveTask", "FileMoves");
            List<Path> newFiles = Collections.synchronizedList(new ArrayList());
            if ((isMmTableWrite || isFullAcidTable) && loadPath.equals((Object)newPartPath)) {
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("not moving " + loadPath + " to " + newPartPath + " (MM)");
                }
                assert (!isAcidIUDoperation);
                if (this.areEventsForDmlNeeded(tbl, oldPart)) {
                    newFiles = this.listFilesCreatedByQuery(loadPath, writeId, stmtId);
                }
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("maybe deleting stuff from " + oldPartPath + " (new " + newPartPath + ") for replace");
                }
            } else {
                boolean isManaged;
                Path destPath = newPartPath;
                if (isMmTableWrite) {
                    assert (!isAcidIUDoperation);
                    destPath = new Path(destPath, isInsertOverwrite ? AcidUtils.baseDir((long)writeId) : AcidUtils.deltaSubdir((long)writeId, (long)writeId, (int)stmtId));
                }
                if (!isAcidIUDoperation && isFullAcidTable) {
                    destPath = this.fixFullAcidPathForLoadData(loadFileType, destPath, writeId, stmtId, tbl);
                }
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("moving " + loadPath + " to " + destPath);
                }
                boolean bl = isManaged = tbl.getTableType() == TableType.MANAGED_TABLE;
                if (!isTxnTable && (loadFileType == LoadTableDesc.LoadFileType.REPLACE_ALL || oldPart == null && !isAcidIUDoperation)) {
                    boolean isAutoPurge = "true".equalsIgnoreCase(tbl.getProperty("auto.purge"));
                    boolean needRecycle = !tbl.isTemporary() && ReplChangeManager.isSourceOfReplication((Database)Hive.get().getDatabase(tbl.getDbName()));
                    this.replaceFiles(tbl.getPath(), loadPath, destPath, oldPartPath, this.getConf(), isSrcLocal, isAutoPurge, newFiles, FileUtils.HIDDEN_FILES_PATH_FILTER, needRecycle, isManaged);
                } else {
                    FileSystem fs = tbl.getDataLocation().getFileSystem((Configuration)this.conf);
                    Hive.copyFiles(this.conf, loadPath, destPath, fs, isSrcLocal, isAcidIUDoperation, loadFileType == LoadTableDesc.LoadFileType.OVERWRITE_EXISTING, newFiles, tbl.getNumBuckets() > 0, isFullAcidTable, isManaged);
                }
            }
            perfLogger.PerfLogEnd("MoveTask", "FileMoves");
            Partition newTPart = oldPart != null ? oldPart : new Partition(tbl, partSpec, newPartPath);
            this.alterPartitionSpecInMemory(tbl, partSpec, newTPart.getTPartition(), inheritTableSpecs, newPartPath.toString());
            this.validatePartition(newTPart);
            if (this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML) && !tbl.isTemporary() && null != oldPart) {
                this.fireInsertEvent(tbl, partSpec, loadFileType == LoadTableDesc.LoadFileType.REPLACE_ALL, newFiles);
            }
            if (!hasFollowingStatsTask) {
                StatsSetupConst.clearColumnStatsState(newTPart.getParameters());
            }
            if (isSkewedStoreAsSubdir) {
                org.apache.hadoop.hive.metastore.api.Partition newCreatedTpart = newTPart.getTPartition();
                SkewedInfo skewedInfo = newCreatedTpart.getSd().getSkewedInfo();
                Map<List<String>, String> skewedColValueLocationMaps = this.constructListBucketingLocationMap(newPartPath, skewedInfo);
                skewedInfo.setSkewedColValueLocationMaps(skewedColValueLocationMaps);
                newCreatedTpart.getSd().setSkewedInfo(skewedInfo);
            }
            if (!this.getConf().getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                StatsSetupConst.setBasicStatsState(newTPart.getParameters(), (String)"false");
            }
            if (oldPart == null) {
                newTPart.getTPartition().setParameters(new HashMap());
                if (this.getConf().getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                    StatsSetupConst.setStatsStateForCreateTable(newTPart.getParameters(), (List)MetaStoreUtils.getColumnNames(tbl.getCols()), (String)"true");
                }
                List filesForStats = null;
                filesForStats = isTxnTable ? AcidUtils.getAcidFilesForStats((Table)newTPart.getTable(), (Path)newPartPath, (Configuration)this.conf, null) : HiveStatsUtils.getFileStatusRecurse((Path)newPartPath, (int)-1, (FileSystem)newPartPath.getFileSystem((Configuration)this.conf));
                if (filesForStats != null) {
                    MetaStoreUtils.populateQuickStats((List)filesForStats, newTPart.getParameters());
                } else {
                    MetaStoreUtils.clearQuickStats(newTPart.getParameters());
                }
                try {
                    LOG.debug("Adding new partition " + newTPart.getSpec());
                    this.getSynchronizedMSC().add_partition(newTPart.getTPartition());
                }
                catch (AlreadyExistsException aee) {
                    LOG.debug("Caught AlreadyExistsException, trying to alter partition instead");
                    this.setStatsPropAndAlterPartition(hasFollowingStatsTask, tbl, newTPart);
                }
                catch (Exception e) {
                    try {
                        FileSystem newPathFileSystem = newPartPath.getFileSystem((Configuration)this.getConf());
                        boolean isAutoPurge = "true".equalsIgnoreCase(tbl.getProperty("auto.purge"));
                        FileStatus status = newPathFileSystem.getFileStatus(newPartPath);
                        Hive.trashFiles(newPathFileSystem, new FileStatus[]{status}, this.getConf(), isAutoPurge);
                    }
                    catch (IOException io) {
                        LOG.error("Could not delete partition directory contents after failed partition creation: ", (Throwable)io);
                    }
                    throw e;
                }
            } else {
                this.setStatsPropAndAlterPartition(hasFollowingStatsTask, tbl, newTPart);
            }
            return newTPart;
        }
        catch (IOException e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        catch (MetaException e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        catch (InvalidOperationException e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        catch (TException e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    private Path fixFullAcidPathForLoadData(LoadTableDesc.LoadFileType loadFileType, Path destPath, long writeId, int stmtId, Table tbl) throws HiveException {
        switch (loadFileType) {
            case REPLACE_ALL: {
                destPath = new Path(destPath, AcidUtils.baseDir((long)writeId));
                break;
            }
            case KEEP_EXISTING: {
                destPath = new Path(destPath, AcidUtils.deltaSubdir((long)writeId, (long)writeId, (int)stmtId));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected " + LoadTableDesc.LoadFileType.class.getName() + " " + loadFileType);
            }
        }
        try {
            FileSystem fs = tbl.getDataLocation().getFileSystem((Configuration)SessionState.getSessionConf());
            if (!FileUtils.mkdir(fs, destPath, this.conf)) {
                LOG.warn(destPath + " already exists?!?!");
            }
        }
        catch (IOException e) {
            throw new HiveException("load: error while creating " + destPath + ";loadFileType=" + loadFileType, e);
        }
        return destPath;
    }

    private boolean areEventsForDmlNeeded(Table tbl, Partition oldPart) {
        return this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML) && !tbl.isTemporary() && oldPart != null;
    }

    private List<Path> listFilesCreatedByQuery(Path loadPath, long writeId, int stmtId) throws HiveException {
        FileStatus[] srcs;
        FileSystem srcFs;
        ArrayList<Path> newFiles = new ArrayList<Path>();
        final String filePrefix = AcidUtils.deltaSubdir((long)writeId, (long)writeId, (int)stmtId);
        try {
            srcFs = loadPath.getFileSystem((Configuration)this.conf);
            srcs = srcFs.listStatus(loadPath);
        }
        catch (IOException e) {
            LOG.error("Error listing files", (Throwable)e);
            throw new HiveException(e);
        }
        if (srcs == null) {
            LOG.info("No sources specified: " + loadPath);
            return newFiles;
        }
        PathFilter subdirFilter = null;
        for (FileStatus src : srcs) {
            if (src.isDirectory()) {
                if (subdirFilter == null) {
                    subdirFilter = new PathFilter(){

                        public boolean accept(Path path) {
                            return path.getName().startsWith(filePrefix);
                        }
                    };
                }
                try {
                    for (FileStatus srcFile : srcFs.listStatus(src.getPath(), subdirFilter)) {
                        newFiles.add(srcFile.getPath());
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException(e);
                }
            }
            if (!src.getPath().getName().startsWith(filePrefix)) continue;
            newFiles.add(src.getPath());
        }
        return newFiles;
    }

    private void setStatsPropAndAlterPartition(boolean hasFollowingStatsTask, Table tbl, Partition newTPart) throws MetaException, TException {
        EnvironmentContext environmentContext = null;
        if (hasFollowingStatsTask) {
            environmentContext = new EnvironmentContext();
            environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        }
        LOG.debug("Altering existing partition " + newTPart.getSpec());
        this.getSynchronizedMSC().alter_partition(tbl.getDbName(), tbl.getTableName(), newTPart.getTPartition(), environmentContext);
    }

    private void walkDirTree(FileStatus fSta, FileSystem fSys, Map<List<String>, String> skewedColValueLocationMaps, Path newPartPath, SkewedInfo skewedInfo) throws IOException {
        if (!fSta.isDir()) {
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Processing LB leaf " + fSta.getPath());
            }
            this.constructOneLBLocationMap(fSta, skewedColValueLocationMaps, newPartPath, skewedInfo);
            return;
        }
        FileStatus[] children = fSys.listStatus(fSta.getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
        if (children != null) {
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Processing LB dir " + fSta.getPath());
            }
            for (FileStatus child : children) {
                this.walkDirTree(child, fSys, skewedColValueLocationMaps, newPartPath, skewedInfo);
            }
        }
    }

    private void constructOneLBLocationMap(FileStatus fSta, Map<List<String>, String> skewedColValueLocationMaps, Path newPartPath, SkewedInfo skewedInfo) {
        String partDirName;
        Path lbdPath = fSta.getPath().getParent();
        ArrayList<String> skewedValue = new ArrayList<String>();
        String lbDirName = FileUtils.unescapePathName(lbdPath.toString());
        String lbDirSuffix = lbDirName.replace(partDirName = FileUtils.unescapePathName(newPartPath.toString()), "");
        if (lbDirSuffix.startsWith("/")) {
            lbDirSuffix = lbDirSuffix.substring(1);
        }
        String[] dirNames = lbDirSuffix.split("/");
        int keysFound = 0;
        int dirsToTake = 0;
        int colCount = skewedInfo.getSkewedColNames().size();
        while (dirsToTake < dirNames.length && keysFound < colCount) {
            String dirName;
            if ((dirName = dirNames[dirsToTake++]).equalsIgnoreCase("HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME")) {
                ++keysFound;
                continue;
            }
            String[] kv = dirName.split("=");
            if (kv.length == 2) {
                skewedValue.add(kv[1]);
                ++keysFound;
                continue;
            }
            LOG.warn("Skipping unknown directory " + dirName + " when expecting LB keys or default directory (from " + lbDirName + ")");
        }
        for (int i = 0; i < dirNames.length - dirsToTake; ++i) {
            lbdPath = lbdPath.getParent();
        }
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("Saving LB location " + lbdPath + " based on " + colCount + " keys and " + fSta.getPath());
        }
        if (skewedValue.size() > 0 && skewedValue.size() == colCount && !skewedColValueLocationMaps.containsKey(skewedValue)) {
            skewedColValueLocationMaps.put(skewedValue, lbdPath.toString());
        }
    }

    private Map<List<String>, String> constructListBucketingLocationMap(Path newPartPath, SkewedInfo skewedInfo) throws IOException, FileNotFoundException {
        HashMap<List<String>, String> skewedColValueLocationMaps = new HashMap<List<String>, String>();
        FileSystem fSys = newPartPath.getFileSystem((Configuration)this.conf);
        this.walkDirTree(fSys.getFileStatus(newPartPath), fSys, skewedColValueLocationMaps, newPartPath, skewedInfo);
        return skewedColValueLocationMaps;
    }

    private Set<Path> getValidPartitionsInPath(int numDP, int numLB, Path loadPath, Long writeId, int stmtId, boolean isMmTable, boolean isInsertOverwrite) throws HiveException {
        int partsToLoad;
        HashSet<Path> validPartitions = new HashSet<Path>();
        try {
            FileSystem fs = loadPath.getFileSystem((Configuration)this.conf);
            if (!isMmTable) {
                List leafStatus = HiveStatsUtils.getFileStatusRecurse((Path)loadPath, (int)numDP, (FileSystem)fs);
                for (FileStatus s : leafStatus) {
                    if (!s.isDirectory()) {
                        throw new HiveException("partition " + s.getPath() + " is not a directory!");
                    }
                    Path dpPath = s.getPath();
                    validPartitions.add(dpPath);
                }
            } else {
                Path[] leafStatus;
                Utilities.FILE_OP_LOGGER.trace("Looking for dynamic partitions in {} ({} levels)", (Object)loadPath, (Object)numDP);
                for (Path p : leafStatus = Utilities.getMmDirectoryCandidates((FileSystem)fs, (Path)loadPath, (int)numDP, null, (long)writeId, (int)-1, (Configuration)this.conf, (Boolean)isInsertOverwrite)) {
                    Path dpPath = p.getParent();
                    if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                        Utilities.FILE_OP_LOGGER.trace("Found DP " + dpPath);
                    }
                    validPartitions.add(dpPath);
                }
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        if ((partsToLoad = validPartitions.size()) == 0) {
            LOG.warn("No partition is generated by dynamic partitioning");
        }
        if (partsToLoad > this.conf.getIntVar(HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS)) {
            throw new HiveException("Number of dynamic partitions created is " + partsToLoad + ", which is more than " + this.conf.getIntVar(HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS) + ". To solve this try to set " + HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS.varname + " to at least " + partsToLoad + '.');
        }
        return validPartitions;
    }

    public Map<Map<String, String>, Partition> loadDynamicPartitions(Path loadPath, String tableName, Map<String, String> partSpec, final LoadTableDesc.LoadFileType loadFileType, int numDP, final int numLB, final boolean isAcid, final long writeId, final int stmtId, final boolean hasFollowingStatsTask, AcidUtils.Operation operation, final boolean isInsertOverwrite) throws HiveException {
        PrintStream printStream;
        boolean inPlaceEligible;
        final Map<Map<String, String>, Partition> partitionsMap = Collections.synchronizedMap(new LinkedHashMap());
        int poolSize = this.conf.getInt(HiveConf.ConfVars.HIVE_LOAD_DYNAMIC_PARTITIONS_THREAD_COUNT.varname, 1);
        ExecutorService pool = Executors.newFixedThreadPool(poolSize, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("load-dynamic-partitions-%d").build());
        final Table tbl = this.getTable(tableName);
        Set<Path> validPartitions = this.getValidPartitionsInPath(numDP, numLB, loadPath, writeId, stmtId, AcidUtils.isInsertOnlyTable(tbl.getParameters()), isInsertOverwrite);
        final int partsToLoad = validPartitions.size();
        final AtomicInteger partitionsLoaded = new AtomicInteger(0);
        boolean bl = inPlaceEligible = this.conf.getLong("fs.trash.interval", 0L) <= 0L && InPlaceUpdate.canRenderInPlace((HiveConf)this.conf) && !SessionState.getConsole().getIsSilent();
        if (inPlaceEligible) {
            SessionState.getConsole();
            printStream = SessionState.LogHelper.getInfoStream();
        } else {
            printStream = null;
        }
        final PrintStream ps = printStream;
        final SessionState parentSession = SessionState.get();
        LinkedList<Future<Void>> futures = Lists.newLinkedList();
        try {
            final ConcurrentHashMap<Long, RawStore> rawStoreMap = new ConcurrentHashMap<Long, RawStore>();
            for (final Path path : validPartitions) {
                final LinkedHashMap<String, String> fullPartSpec = Maps.newLinkedHashMap(partSpec);
                if (!Warehouse.makeSpecFromName(fullPartSpec, (Path)path, new HashSet<String>(partSpec.keySet()))) {
                    Utilities.FILE_OP_LOGGER.warn("Ignoring invalid DP directory " + path);
                    continue;
                }
                futures.add(pool.submit(new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        try {
                            SessionState.setCurrentSessionState((SessionState)parentSession);
                            LOG.info("New loading path = " + path + " with partSpec " + fullPartSpec);
                            Partition newPartition = Hive.this.loadPartition(path, tbl, fullPartSpec, loadFileType, true, numLB > 0, false, isAcid, hasFollowingStatsTask, writeId, stmtId, isInsertOverwrite);
                            partitionsMap.put(fullPartSpec, newPartition);
                            if (inPlaceEligible) {
                                PrintStream printStream = ps;
                                synchronized (printStream) {
                                    InPlaceUpdate.rePositionCursor((PrintStream)ps);
                                    partitionsLoaded.incrementAndGet();
                                    InPlaceUpdate.reprintLine((PrintStream)ps, (String)("Loaded : " + partitionsLoaded.get() + "/" + partsToLoad + " partitions."));
                                }
                            }
                            if (Hive.this.getMSC().isLocalMetaStore() && !rawStoreMap.containsKey(Thread.currentThread().getId())) {
                                rawStoreMap.put(Thread.currentThread().getId(), HiveMetaStore.HMSHandler.getRawStore());
                            }
                            return null;
                        }
                        catch (Exception t) {
                            LOG.error("Exception when loading partition with parameters  partPath=" + path + ",  table=" + tbl.getTableName() + ",  partSpec=" + fullPartSpec + ",  loadFileType=" + loadFileType.toString() + ",  listBucketingLevel=" + numLB + ",  isAcid=" + isAcid + ",  hasFollowingStatsTask=" + hasFollowingStatsTask, (Throwable)t);
                            throw t;
                        }
                    }
                }));
            }
            pool.shutdown();
            LOG.debug("Number of partitions to be added is " + futures.size());
            for (Future future : futures) {
                future.get();
            }
            rawStoreMap.forEach((k, rs) -> rs.shutdown());
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.debug("Cancelling " + futures.size() + " dynamic loading tasks");
            for (Future future : futures) {
                future.cancel(true);
            }
            throw new HiveException("Exception when loading " + partsToLoad + " in table " + tbl.getTableName() + " with loadPath=" + loadPath, e);
        }
        try {
            if (isAcid) {
                ArrayList<String> partNames = new ArrayList<String>(partitionsMap.size());
                for (Partition partition : partitionsMap.values()) {
                    partNames.add(partition.getName());
                }
                this.getMSC().addDynamicPartitions(parentSession.getTxnMgr().getCurrentTxnId(), writeId, tbl.getDbName(), tbl.getTableName(), partNames, AcidUtils.toDataOperationType((AcidUtils.Operation)operation));
            }
            LOG.info("Loaded " + partitionsMap.size() + " partitions");
            return partitionsMap;
        }
        catch (TException te) {
            throw new HiveException("Exception updating metastore for acid table " + tableName + " with partitions " + partitionsMap.values(), te);
        }
    }

    public void loadTable(Path loadPath, String tableName, LoadTableDesc.LoadFileType loadFileType, boolean isSrcLocal, boolean isSkewedStoreAsSubdir, boolean isAcidIUDoperation, boolean hasFollowingStatsTask, Long writeId, int stmtId, boolean isInsertOverwrite) throws HiveException {
        List<Path> newFiles = Collections.synchronizedList(new ArrayList());
        Table tbl = this.getTable(tableName);
        assert (tbl.getPath() != null) : "null==getPath() for " + tbl.getTableName();
        boolean isTxnTable = AcidUtils.isTransactionalTable((Table)tbl);
        boolean isMmTable = AcidUtils.isInsertOnlyTable((Table)tbl);
        boolean isFullAcidTable = AcidUtils.isFullAcidTable((Table)tbl);
        if ((isMmTable || isFullAcidTable) && loadPath.equals((Object)tbl.getPath())) {
            if (Utilities.FILE_OP_LOGGER.isDebugEnabled()) {
                Utilities.FILE_OP_LOGGER.debug("not moving " + loadPath + " to " + tbl.getPath() + " (MM)");
            }
            newFiles = this.listFilesCreatedByQuery(loadPath, writeId, stmtId);
        } else {
            boolean isManaged;
            Path tblPath;
            Path destPath = tblPath = tbl.getPath();
            if (isMmTable) {
                assert (!isAcidIUDoperation);
                destPath = new Path(destPath, isInsertOverwrite ? AcidUtils.baseDir((long)writeId) : AcidUtils.deltaSubdir((long)writeId, (long)writeId, (int)stmtId));
            }
            if (!isAcidIUDoperation && isFullAcidTable) {
                destPath = this.fixFullAcidPathForLoadData(loadFileType, destPath, writeId, stmtId, tbl);
            }
            Utilities.FILE_OP_LOGGER.debug("moving " + loadPath + " to " + tblPath + " (replace = " + loadFileType + ")");
            boolean bl = isManaged = tbl.getTableType() == TableType.MANAGED_TABLE;
            if (loadFileType == LoadTableDesc.LoadFileType.REPLACE_ALL && !isTxnTable) {
                boolean isAutopurge = "true".equalsIgnoreCase(tbl.getProperty("auto.purge"));
                boolean needRecycle = !tbl.isTemporary() && ReplChangeManager.isSourceOfReplication((Database)Hive.get().getDatabase(tbl.getDbName()));
                this.replaceFiles(tblPath, loadPath, destPath, tblPath, this.conf, isSrcLocal, isAutopurge, newFiles, FileUtils.HIDDEN_FILES_PATH_FILTER, needRecycle, isManaged);
            } else {
                try {
                    FileSystem fs = tbl.getDataLocation().getFileSystem((Configuration)this.conf);
                    Hive.copyFiles(this.conf, loadPath, destPath, fs, isSrcLocal, isAcidIUDoperation, loadFileType == LoadTableDesc.LoadFileType.OVERWRITE_EXISTING, newFiles, tbl.getNumBuckets() > 0, isFullAcidTable, isManaged);
                }
                catch (IOException e) {
                    throw new HiveException("addFiles: filesystem error in check phase", e);
                }
            }
        }
        if (!this.getConf().getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
            StatsSetupConst.setBasicStatsState(tbl.getParameters(), (String)"false");
        }
        if (!hasFollowingStatsTask) {
            StatsSetupConst.clearColumnStatsState(tbl.getParameters());
        }
        try {
            if (isSkewedStoreAsSubdir) {
                SkewedInfo skewedInfo = tbl.getSkewedInfo();
                Map<List<String>, String> skewedColValueLocationMaps = this.constructListBucketingLocationMap(tbl.getPath(), skewedInfo);
                skewedInfo.setSkewedColValueLocationMaps(skewedColValueLocationMaps);
            }
        }
        catch (IOException e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        EnvironmentContext environmentContext = null;
        if (hasFollowingStatsTask) {
            environmentContext = new EnvironmentContext();
            environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
        }
        this.alterTable(tbl, environmentContext);
        if (this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML) && !tbl.isTemporary()) {
            this.fireInsertEvent(tbl, null, loadFileType == LoadTableDesc.LoadFileType.REPLACE_ALL, newFiles);
        } else {
            this.fireInsertEvent(tbl, null, loadFileType == LoadTableDesc.LoadFileType.REPLACE_ALL, null);
        }
    }

    public Partition createPartition(Table tbl, Map<String, String> partSpec) throws HiveException {
        try {
            return new Partition(tbl, this.getMSC().add_partition(Partition.createMetaPartitionObject(tbl, partSpec, null)));
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public List<Partition> createPartitions(AddPartitionDesc addPartitionDesc) throws HiveException {
        Table tbl = this.getTable(addPartitionDesc.getDbName(), addPartitionDesc.getTableName());
        int size = addPartitionDesc.getPartitionCount();
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> in = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>(size);
        for (int i = 0; i < size; ++i) {
            in.add(Hive.convertAddSpecToMetaPartition(tbl, addPartitionDesc.getPartition(i), this.conf));
        }
        ArrayList<Partition> out = new ArrayList<Partition>();
        try {
            if (!addPartitionDesc.getReplicationSpec().isInReplicationScope()) {
                for (org.apache.hadoop.hive.metastore.api.Partition outPart : this.getMSC().add_partitions(in, addPartitionDesc.isIfNotExists(), true)) {
                    out.add(new Partition(tbl, outPart));
                }
            } else {
                ArrayList<org.apache.hadoop.hive.metastore.api.Partition> partsToAdd = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
                ArrayList<org.apache.hadoop.hive.metastore.api.Partition> partsToAlter = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
                ArrayList<String> part_names = new ArrayList<String>();
                for (org.apache.hadoop.hive.metastore.api.Partition p : in) {
                    part_names.add(Warehouse.makePartName(tbl.getPartitionKeys(), (List)p.getValues()));
                    try {
                        org.apache.hadoop.hive.metastore.api.Partition ptn = this.getMSC().getPartition(addPartitionDesc.getDbName(), addPartitionDesc.getTableName(), p.getValues());
                        if (!addPartitionDesc.getReplicationSpec().allowReplacementInto(ptn.getParameters())) continue;
                        partsToAlter.add(p);
                    }
                    catch (NoSuchObjectException nsoe) {
                        partsToAdd.add(p);
                    }
                }
                for (org.apache.hadoop.hive.metastore.api.Partition outPart : this.getMSC().add_partitions(partsToAdd, addPartitionDesc.isIfNotExists(), true)) {
                    out.add(new Partition(tbl, outPart));
                }
                this.getMSC().alter_partitions(addPartitionDesc.getDbName(), addPartitionDesc.getTableName(), partsToAlter, null);
                for (org.apache.hadoop.hive.metastore.api.Partition outPart : this.getMSC().getPartitionsByNames(addPartitionDesc.getDbName(), addPartitionDesc.getTableName(), part_names)) {
                    out.add(new Partition(tbl, outPart));
                }
            }
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return out;
    }

    public static org.apache.hadoop.hive.metastore.api.Partition convertAddSpecToMetaPartition(Table tbl, AddPartitionDesc.OnePartitionDesc addSpec, HiveConf conf) throws HiveException {
        Path location;
        Path path = location = addSpec.getLocation() != null ? new Path(tbl.getPath(), addSpec.getLocation()) : null;
        if (location != null) {
            location = new Path(Utilities.getQualifiedPath((HiveConf)conf, (Path)location));
        }
        org.apache.hadoop.hive.metastore.api.Partition part = Partition.createMetaPartitionObject(tbl, addSpec.getPartSpec(), location);
        if (addSpec.getPartParams() != null) {
            part.setParameters(addSpec.getPartParams());
        }
        if (addSpec.getInputFormat() != null) {
            part.getSd().setInputFormat(addSpec.getInputFormat());
        }
        if (addSpec.getOutputFormat() != null) {
            part.getSd().setOutputFormat(addSpec.getOutputFormat());
        }
        if (addSpec.getNumBuckets() != -1) {
            part.getSd().setNumBuckets(addSpec.getNumBuckets());
        }
        if (addSpec.getCols() != null) {
            part.getSd().setCols(addSpec.getCols());
        }
        if (addSpec.getSerializationLib() != null) {
            part.getSd().getSerdeInfo().setSerializationLib(addSpec.getSerializationLib());
        }
        if (addSpec.getSerdeParams() != null) {
            part.getSd().getSerdeInfo().setParameters(addSpec.getSerdeParams());
        }
        if (addSpec.getBucketCols() != null) {
            part.getSd().setBucketCols(addSpec.getBucketCols());
        }
        if (addSpec.getSortCols() != null) {
            part.getSd().setSortCols(addSpec.getSortCols());
        }
        return part;
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec, boolean forceCreate) throws HiveException {
        return this.getPartition(tbl, partSpec, forceCreate, null, true);
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec, boolean forceCreate, String partPath, boolean inheritTableSpecs) throws HiveException {
        tbl.validatePartColumnNames(partSpec, true);
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : tbl.getPartCols()) {
            String val = partSpec.get(field.getName());
            if (val == null && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONING) || val != null && val.length() == 0) {
                throw new HiveException("get partition: Value for key " + field.getName() + " is null or empty");
            }
            if (val == null) continue;
            pvals.add(val);
        }
        org.apache.hadoop.hive.metastore.api.Partition tpart = null;
        try {
            tpart = this.getSynchronizedMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, Hive.getUserName(), this.getGroupNames());
        }
        catch (NoSuchObjectException nsoe) {
            tpart = null;
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        try {
            if (forceCreate) {
                if (tpart == null) {
                    LOG.debug("creating partition for table " + tbl.getTableName() + " with partition spec : " + partSpec);
                    try {
                        tpart = this.getSynchronizedMSC().appendPartition(tbl.getDbName(), tbl.getTableName(), pvals);
                    }
                    catch (AlreadyExistsException aee) {
                        LOG.debug("Caught already exists exception, trying to alter partition instead");
                        tpart = this.getSynchronizedMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, Hive.getUserName(), this.getGroupNames());
                        this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                    }
                    catch (Exception e) {
                        if (CheckJDOException.isJDODataStoreException(e)) {
                            LOG.debug("Caught JDO exception, trying to alter partition instead");
                            tpart = this.getSynchronizedMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, Hive.getUserName(), this.getGroupNames());
                            if (tpart == null) {
                                throw e;
                            }
                            this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                        }
                        throw e;
                    }
                } else {
                    this.alterPartitionSpec(tbl, partSpec, tpart, inheritTableSpecs, partPath);
                    this.fireInsertEvent(tbl, partSpec, true, null);
                }
            }
            if (tpart == null) {
                return null;
            }
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return new Partition(tbl, tpart);
    }

    private void alterPartitionSpec(Table tbl, Map<String, String> partSpec, org.apache.hadoop.hive.metastore.api.Partition tpart, boolean inheritTableSpecs, String partPath) throws HiveException, InvalidOperationException {
        this.alterPartitionSpecInMemory(tbl, partSpec, tpart, inheritTableSpecs, partPath);
        String fullName = tbl.getTableName();
        if (!StringUtils.isEmpty((String)tbl.getDbName())) {
            fullName = tbl.getFullyQualifiedName();
        }
        this.alterPartition(fullName, new Partition(tbl, tpart), null);
    }

    private void alterPartitionSpecInMemory(Table tbl, Map<String, String> partSpec, org.apache.hadoop.hive.metastore.api.Partition tpart, boolean inheritTableSpecs, String partPath) throws HiveException, InvalidOperationException {
        LOG.debug("altering partition for table " + tbl.getTableName() + " with partition spec : " + partSpec);
        if (inheritTableSpecs) {
            tpart.getSd().setOutputFormat(tbl.getTTable().getSd().getOutputFormat());
            tpart.getSd().setInputFormat(tbl.getTTable().getSd().getInputFormat());
            tpart.getSd().getSerdeInfo().setSerializationLib(tbl.getSerializationLib());
            tpart.getSd().getSerdeInfo().setParameters(tbl.getTTable().getSd().getSerdeInfo().getParameters());
            tpart.getSd().setBucketCols(tbl.getBucketCols());
            tpart.getSd().setNumBuckets(tbl.getNumBuckets());
            tpart.getSd().setSortCols(tbl.getSortCols());
        }
        if (partPath == null || partPath.trim().equals("")) {
            throw new HiveException("new partition path should not be null or empty.");
        }
        tpart.getSd().setLocation(partPath);
    }

    private void fireInsertEvent(Table tbl, Map<String, String> partitionSpec, boolean replace, List<Path> newFiles) throws HiveException {
        if (this.conf.getBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML)) {
            LOG.debug("Firing dml insert event");
            if (tbl.isTemporary()) {
                LOG.debug("Not firing dml insert event as " + tbl.getTableName() + " is temporary");
                return;
            }
            try {
                FileSystem fileSystem = tbl.getDataLocation().getFileSystem((Configuration)this.conf);
                FireEventRequestData data = new FireEventRequestData();
                InsertEventRequestData insertData = new InsertEventRequestData();
                insertData.setReplace(replace);
                data.setInsertData(insertData);
                if (newFiles != null && !newFiles.isEmpty()) {
                    Hive.addInsertFileInformation(newFiles, fileSystem, insertData);
                } else {
                    insertData.setFilesAdded(new ArrayList());
                }
                FireEventRequest rqst = new FireEventRequest(true, data);
                rqst.setDbName(tbl.getDbName());
                rqst.setTableName(tbl.getTableName());
                if (partitionSpec != null && partitionSpec.size() > 0) {
                    ArrayList<String> partVals = new ArrayList<String>(partitionSpec.size());
                    for (FieldSchema fs : tbl.getPartitionKeys()) {
                        partVals.add(partitionSpec.get(fs.getName()));
                    }
                    rqst.setPartitionVals(partVals);
                }
                this.getSynchronizedMSC().fireListenerEvent(rqst);
            }
            catch (IOException | TException e) {
                throw new HiveException(e);
            }
        }
    }

    private static void addInsertFileInformation(List<Path> newFiles, FileSystem fileSystem, InsertEventRequestData insertData) throws IOException {
        LinkedList<Path> directories = null;
        for (Path p : newFiles) {
            if (fileSystem.isDirectory(p)) {
                if (directories == null) {
                    directories = new LinkedList<Path>();
                }
                directories.add(p);
                continue;
            }
            Hive.addInsertNonDirectoryInformation(p, fileSystem, insertData);
        }
        if (directories == null) {
            return;
        }
        while (!directories.isEmpty()) {
            Path dir = (Path)directories.poll();
            FileStatus[] contents = fileSystem.listStatus(dir);
            if (contents == null) continue;
            for (FileStatus status : contents) {
                if (status.isDirectory()) {
                    directories.add(status.getPath());
                    continue;
                }
                Hive.addInsertNonDirectoryInformation(status.getPath(), fileSystem, insertData);
            }
        }
    }

    private static void addInsertNonDirectoryInformation(Path p, FileSystem fileSystem, InsertEventRequestData insertData) throws IOException {
        insertData.addToFilesAdded(p.toString());
        FileChecksum cksum = fileSystem.getFileChecksum(p);
        if (cksum != null) {
            String checksumString = org.apache.hadoop.util.StringUtils.byteToHexString((byte[])cksum.getBytes(), (int)0, (int)cksum.getLength());
            insertData.addToFilesAddedChecksum(checksumString);
        } else {
            insertData.addToFilesAddedChecksum("");
        }
    }

    public boolean dropPartition(String tblName, List<String> part_vals, boolean deleteData) throws HiveException {
        String[] names = Utilities.getDbTableName((String)tblName);
        return this.dropPartition(names[0], names[1], part_vals, deleteData);
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws HiveException {
        return this.dropPartition(db_name, tbl_name, part_vals, PartitionDropOptions.instance().deleteData(deleteData));
    }

    public boolean dropPartition(String dbName, String tableName, List<String> partVals, PartitionDropOptions options) throws HiveException {
        try {
            return this.getMSC().dropPartition(dbName, tableName, partVals, options);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Partition or table doesn't exist.", e);
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    public List<Partition> dropPartitions(Table table, List<String> partDirNames, boolean deleteData, boolean ifExists) throws HiveException {
        ArrayList<DropTableDesc.PartSpec> partSpecs = new ArrayList<DropTableDesc.PartSpec>(partDirNames.size());
        String[] parts = null;
        String[] partExprParts = null;
        HashMap<String, String> colTypes = new HashMap<String, String>();
        for (FieldSchema fieldSchema : table.getPartitionKeys()) {
            colTypes.put(fieldSchema.getName(), fieldSchema.getType());
        }
        int partSpecKey = 0;
        for (String partDir : partDirNames) {
            ExprNodeGenericFuncDesc expr = null;
            for (String part : parts = partDir.split("/")) {
                partExprParts = part.split("=");
                assert (partExprParts.length == 2);
                String partCol = partExprParts[0];
                PrimitiveTypeInfo pti = TypeInfoFactory.getPrimitiveTypeInfo((String)colTypes.get(partCol));
                ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)pti, partCol, null, true);
                ExprNodeGenericFuncDesc op = DDLSemanticAnalyzer.makeBinaryPredicate((String)"=", (ExprNodeDesc)column, (ExprNodeDesc)new ExprNodeConstantDesc((TypeInfo)pti, (Object)partExprParts[1]));
                expr = expr == null ? op : DDLSemanticAnalyzer.makeBinaryPredicate((String)"and", (ExprNodeDesc)expr, (ExprNodeDesc)op);
            }
            partSpecs.add(new DropTableDesc.PartSpec(expr, partSpecKey));
            ++partSpecKey;
        }
        String[] stringArray = Utilities.getDbTableName((String)table.getFullyQualifiedName());
        return this.dropPartitions(stringArray[0], stringArray[1], partSpecs, deleteData, ifExists);
    }

    public List<Partition> dropPartitions(String tblName, List<DropTableDesc.PartSpec> partSpecs, boolean deleteData, boolean ifExists) throws HiveException {
        String[] names = Utilities.getDbTableName((String)tblName);
        return this.dropPartitions(names[0], names[1], partSpecs, deleteData, ifExists);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<DropTableDesc.PartSpec> partSpecs, boolean deleteData, boolean ifExists) throws HiveException {
        return this.dropPartitions(dbName, tblName, partSpecs, PartitionDropOptions.instance().deleteData(deleteData).ifExists(ifExists));
    }

    public List<Partition> dropPartitions(String tblName, List<DropTableDesc.PartSpec> partSpecs, PartitionDropOptions dropOptions) throws HiveException {
        String[] names = Utilities.getDbTableName((String)tblName);
        return this.dropPartitions(names[0], names[1], partSpecs, dropOptions);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<DropTableDesc.PartSpec> partSpecs, PartitionDropOptions dropOptions) throws HiveException {
        try {
            Table tbl = this.getTable(dbName, tblName);
            ArrayList<org.apache.hadoop.hive.metastore.utils.ObjectPair> partExprs = new ArrayList<org.apache.hadoop.hive.metastore.utils.ObjectPair>(partSpecs.size());
            for (DropTableDesc.PartSpec partSpec : partSpecs) {
                partExprs.add(new org.apache.hadoop.hive.metastore.utils.ObjectPair((Object)partSpec.getPrefixLength(), (Object)SerializationUtilities.serializeExpressionToKryo((ExprNodeGenericFuncDesc)partSpec.getPartSpec())));
            }
            List tParts = this.getMSC().dropPartitions(dbName, tblName, partExprs, dropOptions);
            return Hive.convertFromMetastore(tbl, tParts);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Partition or table doesn't exist.", e);
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    public List<String> getPartitionNames(String tblName, short max) throws HiveException {
        String[] names = Utilities.getDbTableName((String)tblName);
        return this.getPartitionNames(names[0], names[1], max);
    }

    public List<String> getPartitionNames(String dbName, String tblName, short max) throws HiveException {
        List names = null;
        try {
            names = this.getMSC().listPartitionNames(dbName, tblName, max);
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return names;
    }

    public List<String> getPartitionNames(String dbName, String tblName, Map<String, String> partSpec, short max) throws HiveException {
        List names = null;
        Table t = this.getTable(dbName, tblName);
        List pvals = MetaStoreUtils.getPvals(t.getPartCols(), partSpec);
        try {
            names = this.getMSC().listPartitionNames(dbName, tblName, pvals, max);
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return names;
    }

    public List<Partition> getPartitions(Table tbl) throws HiveException {
        if (tbl.isPartitioned()) {
            List tParts;
            try {
                tParts = this.getMSC().listPartitionsWithAuthInfo(tbl.getDbName(), tbl.getTableName(), (short)-1, Hive.getUserName(), this.getGroupNames());
            }
            catch (Exception e) {
                LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                throw new HiveException(e);
            }
            ArrayList<Partition> parts = new ArrayList<Partition>(tParts.size());
            for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
                parts.add(new Partition(tbl, tpart));
            }
            return parts;
        }
        Partition part = new Partition(tbl);
        ArrayList<Partition> parts = new ArrayList<Partition>(1);
        parts.add(part);
        return parts;
    }

    public Set<Partition> getAllPartitionsOf(Table tbl) throws HiveException {
        List tParts;
        if (!tbl.isPartitioned()) {
            return Sets.newHashSet(new Partition(tbl));
        }
        try {
            tParts = this.getMSC().listPartitions(tbl.getDbName(), tbl.getTableName(), (short)-1);
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        LinkedHashSet<Partition> parts = new LinkedHashSet<Partition>(tParts.size());
        for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
            parts.add(new Partition(tbl, tpart));
        }
        return parts;
    }

    public List<Partition> getPartitions(Table tbl, Map<String, String> partialPartSpec, short limit) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        List partialPvals = MetaStoreUtils.getPvals(tbl.getPartCols(), partialPartSpec);
        List partitions = null;
        try {
            partitions = this.getMSC().listPartitionsWithAuthInfo(tbl.getDbName(), tbl.getTableName(), partialPvals, limit, Hive.getUserName(), this.getGroupNames());
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        ArrayList<Partition> qlPartitions = new ArrayList<Partition>();
        for (org.apache.hadoop.hive.metastore.api.Partition p : partitions) {
            qlPartitions.add(new Partition(tbl, p));
        }
        return qlPartitions;
    }

    public List<Partition> getPartitions(Table tbl, Map<String, String> partialPartSpec) throws HiveException {
        return this.getPartitions(tbl, partialPartSpec, (short)-1);
    }

    public List<Partition> getPartitionsByNames(Table tbl, Map<String, String> partialPartSpec) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        List<String> names = this.getPartitionNames(tbl.getDbName(), tbl.getTableName(), partialPartSpec, (short)-1);
        List<Partition> partitions = this.getPartitionsByNames(tbl, names);
        return partitions;
    }

    public List<Partition> getPartitionsByNames(Table tbl, List<String> partNames) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>(partNames.size());
        int batchSize = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX);
        int nParts = partNames.size();
        int nBatches = nParts / batchSize;
        try {
            List tParts;
            for (int i = 0; i < nBatches; ++i) {
                List tParts2 = this.getMSC().getPartitionsByNames(tbl.getDbName(), tbl.getTableName(), partNames.subList(i * batchSize, (i + 1) * batchSize));
                if (tParts2 == null) continue;
                for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts2) {
                    partitions.add(new Partition(tbl, tpart));
                }
            }
            if (nParts > nBatches * batchSize && (tParts = this.getMSC().getPartitionsByNames(tbl.getDbName(), tbl.getTableName(), partNames.subList(nBatches * batchSize, nParts))) != null) {
                for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
                    partitions.add(new Partition(tbl, tpart));
                }
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return partitions;
    }

    public List<Partition> getPartitionsByFilter(Table tbl, String filter) throws HiveException, MetaException, NoSuchObjectException, TException {
        if (!tbl.isPartitioned()) {
            throw new HiveException(ErrorMsg.TABLE_NOT_PARTITIONED, tbl.getTableName());
        }
        List tParts = this.getMSC().listPartitionsByFilter(tbl.getDbName(), tbl.getTableName(), filter, (short)-1);
        return Hive.convertFromMetastore(tbl, tParts);
    }

    private static List<Partition> convertFromMetastore(Table tbl, List<org.apache.hadoop.hive.metastore.api.Partition> partitions) throws HiveException {
        if (partitions == null) {
            return new ArrayList<Partition>();
        }
        ArrayList<Partition> results = new ArrayList<Partition>(partitions.size());
        for (org.apache.hadoop.hive.metastore.api.Partition tPart : partitions) {
            results.add(new Partition(tbl, tPart));
        }
        return results;
    }

    public boolean getPartitionsByExpr(Table tbl, ExprNodeGenericFuncDesc expr, HiveConf conf, List<Partition> result) throws HiveException, TException {
        assert (result != null);
        byte[] exprBytes = SerializationUtilities.serializeExpressionToKryo((ExprNodeGenericFuncDesc)expr);
        String defaultPartitionName = HiveConf.getVar(conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> msParts = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
        boolean hasUnknownParts = this.getMSC().listPartitionsByExpr(tbl.getDbName(), tbl.getTableName(), exprBytes, defaultPartitionName, (short)-1, msParts);
        result.addAll(Hive.convertFromMetastore(tbl, msParts));
        return hasUnknownParts;
    }

    public int getNumPartitionsByFilter(Table tbl, String filter) throws HiveException, MetaException, NoSuchObjectException, TException {
        if (!tbl.isPartitioned()) {
            throw new HiveException("Partition spec should only be supplied for a partitioned table");
        }
        int numParts = this.getMSC().getNumPartitionsByFilter(tbl.getDbName(), tbl.getTableName(), filter);
        return numParts;
    }

    public void validatePartitionNameCharacters(List<String> partVals) throws HiveException {
        try {
            this.getMSC().validatePartitionNameCharacters(partVals);
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void createRole(String roleName, String ownerName) throws HiveException {
        try {
            this.getMSC().create_role(new Role(roleName, -1, ownerName));
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void dropRole(String roleName) throws HiveException {
        try {
            this.getMSC().drop_role(roleName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getAllRoleNames() throws HiveException {
        try {
            return this.getMSC().listRoleNames();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<RolePrincipalGrant> getRoleGrantInfoForPrincipal(String principalName, PrincipalType principalType) throws HiveException {
        try {
            GetRoleGrantsForPrincipalRequest req = new GetRoleGrantsForPrincipalRequest(principalName, principalType);
            GetRoleGrantsForPrincipalResponse resp = this.getMSC().get_role_grants_for_principal(req);
            return resp.getPrincipalGrants();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean grantRole(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().grant_role(roleName, userName, principalType, grantor, grantorType, grantOption);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean revokeRole(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().revoke_role(roleName, userName, principalType, grantOption);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<Role> listRoles(String userName, PrincipalType principalType) throws HiveException {
        try {
            return this.getMSC().list_roles(userName, principalType);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectType objectType, String db_name, String table_name, List<String> part_values, String column_name, String user_name, List<String> group_names) throws HiveException {
        try {
            HiveObjectRef hiveObj = new HiveObjectRef(objectType, db_name, table_name, part_values, column_name);
            return this.getMSC().get_privilege_set(hiveObj, user_name, group_names);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<HiveObjectPrivilege> showPrivilegeGrant(HiveObjectType objectType, String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues, String columnName) throws HiveException {
        try {
            HiveObjectRef hiveObj = new HiveObjectRef(objectType, dbName, tableName, partValues, columnName);
            return this.getMSC().list_privileges(principalName, principalType, hiveObj);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private static void copyFiles(final HiveConf conf, final FileSystem destFs, FileStatus[] srcs, final FileSystem srcFs, final Path destf, final boolean isSrcLocal, final boolean isOverwrite, final List<Path> newFiles, boolean acidRename, boolean isManaged) throws HiveException {
        HdfsUtils.HadoopFileStatus fullDestStatus;
        try {
            fullDestStatus = new HdfsUtils.HadoopFileStatus((Configuration)conf, destFs, destf);
        }
        catch (IOException e1) {
            throw new HiveException(e1);
        }
        if (!fullDestStatus.getFileStatus().isDirectory()) {
            throw new HiveException(destf + " is not a directory.");
        }
        LinkedList<Future<ObjectPair<Path, Path>>> futures = new LinkedList<Future<ObjectPair<Path, Path>>>();
        ExecutorService pool = conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25) > 0 ? Executors.newFixedThreadPool(conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Move-Thread-%d").build()) : null;
        int taskId = 0;
        Arrays.sort(srcs);
        String configuredOwner = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_LOAD_DATA_OWNER);
        for (FileStatus src : srcs) {
            Object[] files;
            if (src.isDirectory()) {
                try {
                    files = srcFs.listStatus(src.getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
                }
                catch (IOException e) {
                    pool.shutdownNow();
                    throw new HiveException(e);
                }
            } else {
                files = new FileStatus[]{src};
            }
            final SessionState parentSession = SessionState.get();
            Arrays.sort(files);
            for (Object srcFile : files) {
                final Path srcP = srcFile.getPath();
                boolean needToCopy = Hive.needToCopy(srcP, destf, srcFs, destFs, configuredOwner, isManaged);
                final boolean isRenameAllowed = !needToCopy && !isSrcLocal;
                final String msg = "Unable to move source " + srcP + " to destination " + destf;
                if (null == pool) {
                    try {
                        Path destPath = Hive.mvFile(conf, srcFs, srcP, destFs, destf, isSrcLocal, isOverwrite, isRenameAllowed, acidRename ? taskId++ : -1);
                        if (null == newFiles) continue;
                        newFiles.add(destPath);
                        continue;
                    }
                    catch (Exception e) {
                        throw Hive.getHiveException(e, msg, "Failed to move: {}");
                    }
                }
                final int finalTaskId = acidRename ? taskId++ : -1;
                futures.add(pool.submit(new Callable<ObjectPair<Path, Path>>(){

                    @Override
                    public ObjectPair<Path, Path> call() throws HiveException {
                        SessionState.setCurrentSessionState((SessionState)parentSession);
                        try {
                            Path destPath = Hive.mvFile(conf, srcFs, srcP, destFs, destf, isSrcLocal, isOverwrite, isRenameAllowed, finalTaskId);
                            if (null != newFiles) {
                                newFiles.add(destPath);
                            }
                            return ObjectPair.create((Object)srcP, (Object)destPath);
                        }
                        catch (Exception e) {
                            throw Hive.getHiveException(e, msg);
                        }
                    }
                }));
            }
        }
        if (null != pool) {
            pool.shutdown();
            for (Future future : futures) {
                try {
                    ObjectPair pair = (ObjectPair)future.get();
                    LOG.debug("Moved src: {}, to dest: {}", (Object)((Path)pair.getFirst()).toString(), (Object)((Path)pair.getSecond()).toString());
                }
                catch (Exception e) {
                    throw Hive.handlePoolException(pool, e);
                }
            }
        }
    }

    private static boolean isSubDir(Path srcf, Path destf, FileSystem srcFs, FileSystem destFs, boolean isSrcLocal) {
        if (srcf == null) {
            LOG.debug("The source path is null for isSubDir method.");
            return false;
        }
        String fullF1 = Hive.getQualifiedPathWithoutSchemeAndAuthority(srcf, srcFs).toString() + "/";
        String fullF2 = Hive.getQualifiedPathWithoutSchemeAndAuthority(destf, destFs).toString() + "/";
        boolean isInTest = HiveConf.getBoolVar(srcFs.getConf(), HiveConf.ConfVars.HIVE_IN_TEST);
        LOG.debug("The source path is " + fullF1 + " and the destination path is " + fullF2);
        if (isInTest) {
            return fullF1.startsWith(fullF2);
        }
        String schemaSrcf = srcf.toUri().getScheme();
        String schemaDestf = destf.toUri().getScheme();
        if (schemaDestf == null && isSrcLocal) {
            LOG.debug("The source file is in the local while the dest not.");
            return false;
        }
        if (schemaSrcf != null && schemaDestf != null && !schemaSrcf.equals(schemaDestf)) {
            LOG.debug("The source path's schema is " + schemaSrcf + " and the destination path's schema is " + schemaDestf + ".");
            return false;
        }
        LOG.debug("The source path is " + fullF1 + " and the destination path is " + fullF2);
        return fullF1.startsWith(fullF2);
    }

    private static Path getQualifiedPathWithoutSchemeAndAuthority(Path srcf, FileSystem fs) {
        Path currentWorkingDir = fs.getWorkingDirectory();
        Path path = srcf.makeQualified(srcf.toUri(), currentWorkingDir);
        return ShimLoader.getHadoopShims().getPathWithoutSchemeAndAuthority(path);
    }

    private static String getPathName(int taskId) {
        return Utilities.replaceTaskId((String)"000000", (int)taskId) + "_0";
    }

    private static Path mvFile(HiveConf conf, FileSystem sourceFs, Path sourcePath, FileSystem destFs, Path destDirPath, boolean isSrcLocal, boolean isOverwrite, boolean isRenameAllowed, int taskId) throws IOException {
        String fullname = sourcePath.getName();
        String name = taskId == -1 ? FilenameUtils.getBaseName((String)sourcePath.getName()) : Hive.getPathName(taskId);
        String type = FilenameUtils.getExtension((String)sourcePath.getName());
        Path destFilePath = new Path(destDirPath, taskId == -1 ? fullname : name);
        int counter = 1;
        while (destFs.exists(destFilePath)) {
            if (isOverwrite) {
                destFs.delete(destFilePath, false);
                break;
            }
            destFilePath = new Path(destDirPath, name + "_copy_" + counter + (taskId == -1 && !type.isEmpty() ? "." + type : ""));
            ++counter;
        }
        if (isRenameAllowed) {
            destFs.rename(sourcePath, destFilePath);
        } else if (isSrcLocal) {
            destFs.copyFromLocalFile(sourcePath, destFilePath);
        } else {
            FileUtils.copy(sourceFs, sourcePath, destFs, destFilePath, true, false, conf);
        }
        return destFilePath;
    }

    public static void clearDestForSubDirSrc(HiveConf conf, Path dest, Path src, boolean isSrcLocal) throws IOException {
        FileSystem destFS = dest.getFileSystem((Configuration)conf);
        FileSystem srcFS = src.getFileSystem((Configuration)conf);
        if (Hive.isSubDir(src, dest, srcFS, destFS, isSrcLocal)) {
            FileStatus[] existingFiles;
            Path fullDestPath;
            Path fullSrcPath = Hive.getQualifiedPathWithoutSchemeAndAuthority(src, srcFS);
            if (fullSrcPath.equals((Object)(fullDestPath = Hive.getQualifiedPathWithoutSchemeAndAuthority(dest, destFS)))) {
                return;
            }
            Path parent = fullSrcPath;
            while (!parent.getParent().equals((Object)fullDestPath)) {
                parent = parent.getParent();
            }
            for (FileStatus fileStatus : existingFiles = destFS.listStatus(dest, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                if (fileStatus.getPath().getName().equals(parent.getName())) continue;
                destFS.delete(fileStatus.getPath(), true);
            }
        }
    }

    public static void listNewFilesRecursively(FileSystem destFs, Path dest, List<Path> newFiles) throws HiveException {
        try {
            for (FileStatus fileStatus : destFs.listStatus(dest, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                if (fileStatus.isDirectory()) {
                    Hive.listNewFilesRecursively(destFs, fileStatus.getPath(), newFiles);
                    continue;
                }
                newFiles.add(fileStatus.getPath());
            }
        }
        catch (IOException e) {
            LOG.error("Failed to get source file statuses", (Throwable)e);
            throw new HiveException(e.getMessage(), e);
        }
    }

    public void recycleDirToCmPath(Path dataPath, boolean isPurge) throws HiveException {
        try {
            CmRecycleRequest request = new CmRecycleRequest(dataPath.toString(), isPurge);
            this.getMSC().recycleDirToCmPath(request);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public static boolean moveFile(HiveConf conf, Path srcf, Path destf, boolean replace, boolean isSrcLocal, boolean isManaged) throws HiveException {
        FileSystem srcFs;
        FileSystem destFs;
        try {
            destFs = destf.getFileSystem((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error("Failed to get dest fs", (Throwable)e);
            throw new HiveException(e.getMessage(), e);
        }
        try {
            srcFs = srcf.getFileSystem((Configuration)conf);
        }
        catch (IOException e) {
            LOG.error("Failed to get src fs", (Throwable)e);
            throw new HiveException(e.getMessage(), e);
        }
        HdfsUtils.HadoopFileStatus destStatus = null;
        String configuredOwner = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_LOAD_DATA_OWNER);
        boolean srcIsSubDirOfDest = Hive.isSubDir(srcf, destf, srcFs, destFs, isSrcLocal);
        boolean destIsSubDirOfSrc = Hive.isSubDir(destf, srcf, destFs, srcFs, false);
        String msg = "Unable to move source " + srcf + " to destination " + destf;
        try {
            if (replace) {
                try {
                    destStatus = new HdfsUtils.HadoopFileStatus((Configuration)conf, destFs, destf);
                    if (replace && !srcIsSubDirOfDest) {
                        destFs.delete(destf, true);
                        LOG.debug("The path " + destf.toString() + " is deleted");
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            HdfsUtils.HadoopFileStatus desiredStatus = destStatus;
            final SessionState parentSession = SessionState.get();
            if (isSrcLocal) {
                destFs.copyFromLocalFile(srcf, destf);
                return true;
            }
            if (Hive.needToCopy(srcf, destf, srcFs, destFs, configuredOwner, isManaged)) {
                LOG.debug("Copying source " + srcf + " to " + destf + " because HDFS encryption zones are different.");
                return FileUtils.copy(srcf.getFileSystem((Configuration)conf), srcf, destf.getFileSystem((Configuration)conf), destf, true, replace, conf);
            }
            if (srcIsSubDirOfDest || destIsSubDirOfSrc) {
                ExecutorService pool;
                FileStatus[] srcs = destFs.listStatus(srcf, FileUtils.HIDDEN_FILES_PATH_FILTER);
                LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
                ExecutorService executorService = pool = conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25) > 0 ? Executors.newFixedThreadPool(conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Move-Thread-%d").build()) : null;
                if (destIsSubDirOfSrc && !destFs.exists(destf)) {
                    if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                        Utilities.FILE_OP_LOGGER.trace("Creating " + destf);
                    }
                    destFs.mkdirs(destf);
                }
                for (final FileStatus srcStatus : srcs) {
                    final Path destFile = new Path(destf, srcStatus.getPath().getName());
                    final String poolMsg = "Unable to move source " + srcStatus.getPath() + " to destination " + destFile;
                    if (null == pool) {
                        boolean success = false;
                        if (destFs instanceof DistributedFileSystem) {
                            ((DistributedFileSystem)destFs).rename(srcStatus.getPath(), destFile, new Options.Rename[]{Options.Rename.OVERWRITE});
                            success = true;
                        } else {
                            destFs.delete(destFile, false);
                            success = destFs.rename(srcStatus.getPath(), destFile);
                        }
                        if (success) continue;
                        throw new IOException("rename for src path: " + srcStatus.getPath() + " to dest:" + destf + " returned false");
                    }
                    futures.add(pool.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws HiveException {
                            SessionState.setCurrentSessionState((SessionState)parentSession);
                            String group = srcStatus.getGroup();
                            try {
                                boolean success = false;
                                if (destFs instanceof DistributedFileSystem) {
                                    ((DistributedFileSystem)destFs).rename(srcStatus.getPath(), destFile, new Options.Rename[]{Options.Rename.OVERWRITE});
                                    success = true;
                                } else {
                                    destFs.delete(destFile, false);
                                    success = destFs.rename(srcStatus.getPath(), destFile);
                                }
                                if (!success) {
                                    throw new IOException("rename for src path: " + srcStatus.getPath() + " to dest path:" + destFile + " returned false");
                                }
                            }
                            catch (Exception e) {
                                throw Hive.getHiveException(e, poolMsg);
                            }
                            return null;
                        }
                    }));
                }
                if (null != pool) {
                    pool.shutdown();
                    for (Future future : futures) {
                        try {
                            future.get();
                        }
                        catch (Exception e) {
                            throw Hive.handlePoolException(pool, e);
                        }
                    }
                }
                return true;
            }
            return destFs.rename(srcf, destf);
        }
        catch (Exception e) {
            throw Hive.getHiveException(e, msg);
        }
    }

    private static HiveException getHiveException(Exception e, String msg) {
        return Hive.getHiveException(e, msg, null);
    }

    private static HiveException handlePoolException(ExecutorService pool, Exception e) {
        HiveException he = null;
        if (e instanceof HiveException) {
            he = (HiveException)e;
            if (he.getCanonicalErrorMsg() != ErrorMsg.GENERIC_ERROR) {
                if (he.getCanonicalErrorMsg() == ErrorMsg.UNRESOLVED_RT_EXCEPTION) {
                    LOG.error("Failed to move: {}", (Object)he.getMessage());
                } else {
                    LOG.error("Failed to move: {}", (Object)he.getRemoteErrorMsg());
                }
            }
        } else {
            LOG.error("Failed to move: {}", (Object)e.getMessage());
            he = new HiveException(e.getCause());
        }
        pool.shutdownNow();
        return he;
    }

    private static HiveException getHiveException(Exception e, String msg, String logMsg) {
        String hiveErrMsg = null;
        hiveErrMsg = e.getMessage() != null ? String.format("%s%s%s", msg, ": ", Splitter.on(System.getProperty("line.separator")).split(e.getMessage()).iterator().next()) : msg;
        ErrorMsg errorMsg = ErrorMsg.getErrorMsg(e);
        if (logMsg != null) {
            LOG.info(String.format(logMsg, e.getMessage()));
        }
        if (errorMsg != ErrorMsg.UNRESOLVED_RT_EXCEPTION) {
            return new HiveException((Throwable)e, e.getMessage(), errorMsg, hiveErrMsg);
        }
        return new HiveException(msg, e);
    }

    private static boolean needToCopy(Path srcf, Path destf, FileSystem srcFs, FileSystem destFs, String configuredOwner, boolean isManaged) throws HiveException {
        block11: {
            if (!FileUtils.equalsFileSystem(srcFs, destFs)) {
                return true;
            }
            if (isManaged && !configuredOwner.isEmpty() && srcFs instanceof DistributedFileSystem) {
                try {
                    FileStatus srcs = srcFs.getFileStatus(srcf);
                    String runningUser = UserGroupInformation.getLoginUser().getUserName();
                    boolean isOwned = FileUtils.isOwnerOfFileHierarchy(srcFs, srcs, configuredOwner, false);
                    if (configuredOwner.equals(runningUser)) {
                        if (!isOwned || !FileUtils.isActionPermittedForFileHierarchy(srcFs, srcs, configuredOwner, FsAction.WRITE, false)) {
                            return true;
                        }
                        break block11;
                    }
                    if (!isOwned) {
                        throw new HiveException("Load Data failed for " + srcf + " as the file is not owned by " + configuredOwner + " and load data is also not ran as " + configuredOwner);
                    }
                    return true;
                }
                catch (IOException e) {
                    throw new HiveException("Could not fetch FileStatus for source file");
                }
                catch (HiveException e) {
                    throw new HiveException(e);
                }
                catch (Exception e) {
                    throw new HiveException(" Failed in looking up Permissions on file + " + srcf);
                }
            }
        }
        HadoopShims.HdfsEncryptionShim srcHdfsEncryptionShim = SessionState.get().getHdfsEncryptionShim(srcFs);
        HadoopShims.HdfsEncryptionShim destHdfsEncryptionShim = SessionState.get().getHdfsEncryptionShim(destFs);
        try {
            return srcHdfsEncryptionShim != null && destHdfsEncryptionShim != null && (srcHdfsEncryptionShim.isPathEncrypted(srcf) || destHdfsEncryptionShim.isPathEncrypted(destf)) && !srcHdfsEncryptionShim.arePathsOnSameEncryptionZone(srcf, destf, destHdfsEncryptionShim);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    protected static void copyFiles(HiveConf conf, Path srcf, Path destf, FileSystem fs, boolean isSrcLocal, boolean isAcidIUD, boolean isOverwrite, List<Path> newFiles, boolean isBucketed, boolean isFullAcidTable, boolean isManaged) throws HiveException {
        FileStatus[] srcs;
        FileSystem srcFs;
        try {
            if (!fs.exists(destf)) {
                FileUtils.mkdir(fs, destf, conf);
            }
        }
        catch (IOException e) {
            throw new HiveException("copyFiles: error while checking/creating destination directory!!!", e);
        }
        try {
            srcFs = srcf.getFileSystem((Configuration)conf);
            srcs = srcFs.globStatus(srcf);
        }
        catch (IOException e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException("addFiles: filesystem error in check phase. " + e.getMessage(), e);
        }
        if (srcs == null) {
            LOG.info("No sources specified to move: " + srcf);
            return;
        }
        if (isAcidIUD) {
            Hive.moveAcidFiles(srcFs, srcs, destf, newFiles);
        } else {
            Hive.copyFiles(conf, fs, srcs, srcFs, destf, isSrcLocal, isOverwrite, newFiles, isFullAcidTable && !isBucketed, isManaged);
        }
    }

    public static void moveAcidFiles(FileSystem fs, FileStatus[] stats, Path dst, List<Path> newFiles) throws HiveException {
        HashSet<Path> createdDeltaDirs = new HashSet<Path>();
        for (FileStatus stat : stats) {
            Path srcPath = stat.getPath();
            LOG.debug("Acid move Looking for original buckets in " + srcPath);
            FileStatus[] origBucketStats = null;
            try {
                origBucketStats = fs.listStatus(srcPath, AcidUtils.originalBucketFilter);
                if (origBucketStats == null || origBucketStats.length == 0) {
                    FileStatus[] unionSubdirs = fs.globStatus(new Path(srcPath, "HIVE_UNION_SUBDIR_[0-9]*"));
                    ArrayList buckets = new ArrayList();
                    for (FileStatus unionSubdir : unionSubdirs) {
                        Collections.addAll(buckets, fs.listStatus(unionSubdir.getPath(), AcidUtils.originalBucketFilter));
                    }
                    origBucketStats = buckets.toArray(new FileStatus[buckets.size()]);
                }
            }
            catch (IOException e) {
                String msg = "Unable to look for bucket files in src path " + srcPath.toUri().toString();
                LOG.error(msg);
                throw new HiveException(msg, e);
            }
            LOG.debug("Acid move found " + origBucketStats.length + " original buckets");
            for (FileStatus origBucketStat : origBucketStats) {
                Path origBucketPath = origBucketStat.getPath();
                Hive.moveAcidFiles("delta_", AcidUtils.deltaFileFilter, fs, dst, origBucketPath, createdDeltaDirs, newFiles);
                Hive.moveAcidFiles("delete_delta_", AcidUtils.deleteEventDeltaDirFilter, fs, dst, origBucketPath, createdDeltaDirs, newFiles);
                Hive.moveAcidFiles("base_", AcidUtils.baseFileFilter, fs, dst, origBucketPath, createdDeltaDirs, newFiles);
            }
        }
    }

    private static void moveAcidFiles(String deltaFileType, PathFilter pathFilter, FileSystem fs, Path dst, Path origBucketPath, Set<Path> createdDeltaDirs, List<Path> newFiles) throws HiveException {
        LOG.debug("Acid move looking for " + deltaFileType + " files in bucket " + origBucketPath);
        FileStatus[] deltaStats = null;
        try {
            deltaStats = fs.listStatus(origBucketPath, pathFilter);
        }
        catch (IOException e) {
            throw new HiveException("Unable to look for " + deltaFileType + " files in original bucket " + origBucketPath.toUri().toString(), e);
        }
        LOG.debug("Acid move found " + deltaStats.length + " " + deltaFileType + " files");
        for (FileStatus deltaStat : deltaStats) {
            Path deltaPath = deltaStat.getPath();
            Path deltaDest = new Path(dst, deltaPath.getName());
            try {
                if (!createdDeltaDirs.contains(deltaDest)) {
                    try {
                        if (fs.mkdirs(deltaDest)) {
                            fs.rename(AcidUtils.OrcAcidVersion.getVersionFilePath((Path)deltaStat.getPath()), AcidUtils.OrcAcidVersion.getVersionFilePath((Path)deltaDest));
                        }
                        createdDeltaDirs.add(deltaDest);
                    }
                    catch (IOException swallowIt) {
                        LOG.info("Unable to create " + deltaFileType + " directory " + deltaDest + ", assuming it already exists: " + swallowIt.getMessage());
                    }
                }
                FileStatus[] bucketStats = fs.listStatus(deltaPath, AcidUtils.bucketFileFilter);
                LOG.debug("Acid move found " + bucketStats.length + " bucket files");
                for (FileStatus bucketStat : bucketStats) {
                    Path bucketSrc = bucketStat.getPath();
                    Path bucketDest = new Path(deltaDest, bucketSrc.getName());
                    String msg = "Unable to move source " + bucketSrc + " to destination " + bucketDest;
                    LOG.info("Moving bucket " + bucketSrc.toUri().toString() + " to " + bucketDest.toUri().toString());
                    try {
                        fs.rename(bucketSrc, bucketDest);
                        if (newFiles == null) continue;
                        newFiles.add(bucketDest);
                    }
                    catch (Exception e) {
                        throw Hive.getHiveException(e, msg);
                    }
                }
            }
            catch (IOException e) {
                throw new HiveException("Error moving acid files " + e.getMessage(), e);
            }
        }
    }

    protected void replaceFiles(Path tablePath, Path srcf, Path destf, Path oldPath, HiveConf conf, boolean isSrcLocal, boolean purge, List<Path> newFiles, PathFilter deletePathFilter, boolean isNeedRecycle, boolean isManaged) throws HiveException {
        try {
            boolean destfExist;
            FileStatus[] srcs;
            FileSystem destFs = destf.getFileSystem((Configuration)conf);
            try {
                FileSystem srcFs = srcf.getFileSystem((Configuration)conf);
                srcs = srcFs.globStatus(srcf);
            }
            catch (IOException e) {
                throw new HiveException("Getting globStatus " + srcf.toString(), e);
            }
            if (srcs == null) {
                LOG.info("No sources specified to move: " + srcf);
                return;
            }
            if (oldPath != null) {
                this.deleteOldPathForReplace(destf, oldPath, conf, purge, deletePathFilter, isNeedRecycle);
            }
            if (!(destfExist = FileUtils.mkdir(destFs, destf, conf))) {
                throw new IOException("Directory " + destf.toString() + " does not exist and could not be created.");
            }
            if (srcs.length == 1 && srcs[0].isDirectory()) {
                if (!Hive.moveFile(conf, srcs[0].getPath(), destf, true, isSrcLocal, isManaged)) {
                    throw new IOException("Error moving: " + srcf + " into: " + destf);
                }
                if (null != newFiles) {
                    Hive.listNewFilesRecursively(destFs, destf, newFiles);
                }
            } else {
                for (FileStatus src : srcs) {
                    Path destFile = new Path(destf, src.getPath().getName());
                    if (!Hive.moveFile(conf, src.getPath(), destFile, true, isSrcLocal, isManaged)) {
                        throw new IOException("Error moving: " + srcf + " into: " + destf);
                    }
                    if (null == newFiles) continue;
                    newFiles.add(destFile);
                }
            }
        }
        catch (IOException e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    private void deleteOldPathForReplace(Path destPath, Path oldPath, HiveConf conf, boolean purge, PathFilter pathFilter, boolean isNeedRecycle) throws HiveException {
        Utilities.FILE_OP_LOGGER.debug("Deleting old paths for replace in " + destPath + " and old path " + oldPath);
        boolean isOldPathUnderDestf = false;
        try {
            FileSystem oldFs = oldPath.getFileSystem((Configuration)conf);
            FileSystem destFs = destPath.getFileSystem((Configuration)conf);
            isOldPathUnderDestf = Hive.isSubDir(oldPath, destPath, oldFs, destFs, false);
            if (isOldPathUnderDestf) {
                this.cleanUpOneDirectoryForReplace(oldPath, oldFs, pathFilter, conf, purge, isNeedRecycle);
            }
        }
        catch (IOException e) {
            if (isOldPathUnderDestf) {
                throw new HiveException("Directory " + oldPath.toString() + " could not be cleaned up.", e);
            }
            LOG.warn("Directory " + oldPath.toString() + " cannot be cleaned: " + e, (Throwable)e);
        }
    }

    private void cleanUpOneDirectoryForReplace(Path path, FileSystem fs, PathFilter pathFilter, HiveConf conf, boolean purge, boolean isNeedRecycle) throws IOException, HiveException {
        FileStatus[] statuses;
        if (isNeedRecycle && conf.getBoolVar(HiveConf.ConfVars.REPLCMENABLED)) {
            this.recycleDirToCmPath(path, purge);
        }
        if ((statuses = fs.listStatus(path, pathFilter)) == null || statuses.length == 0) {
            return;
        }
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            String s = "Deleting files under " + path + " for replace: ";
            for (FileStatus file : statuses) {
                s = s + file.getPath().getName() + ", ";
            }
            Utilities.FILE_OP_LOGGER.trace(s);
        }
        if (!Hive.trashFiles(fs, statuses, conf, purge)) {
            throw new HiveException("Old path " + path + " has not been cleaned up.");
        }
    }

    public static boolean trashFiles(final FileSystem fs, FileStatus[] statuses, final Configuration conf, final boolean purge) throws IOException {
        boolean result = true;
        if (statuses == null || statuses.length == 0) {
            return false;
        }
        LinkedList<Future<Boolean>> futures = new LinkedList<Future<Boolean>>();
        ExecutorService pool = conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25) > 0 ? Executors.newFixedThreadPool(conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 25), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Delete-Thread-%d").build()) : null;
        final SessionState parentSession = SessionState.get();
        for (final FileStatus status : statuses) {
            if (null == pool) {
                result &= FileUtils.moveToTrash(fs, status.getPath(), conf, purge);
                continue;
            }
            futures.add(pool.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    SessionState.setCurrentSessionState((SessionState)parentSession);
                    return FileUtils.moveToTrash(fs, status.getPath(), conf, purge);
                }
            }));
        }
        if (null != pool) {
            pool.shutdown();
            for (Future future : futures) {
                try {
                    result &= ((Boolean)future.get()).booleanValue();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error("Failed to delete: ", (Throwable)e);
                    pool.shutdownNow();
                    throw new IOException(e);
                }
            }
        }
        return result;
    }

    public static boolean isHadoop1() {
        return ShimLoader.getMajorVersion().startsWith("0.20");
    }

    public List<Partition> exchangeTablePartitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destDb, String destinationTableName) throws HiveException {
        try {
            List partitions = this.getMSC().exchange_partitions(partitionSpecs, sourceDb, sourceTable, destDb, destinationTableName);
            return Hive.convertFromMetastore(this.getTable(destDb, destinationTableName), partitions);
        }
        catch (Exception ex) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
            throw new HiveException(ex);
        }
    }

    private IMetaStoreClient createMetaStoreClient(boolean allowEmbedded) throws MetaException {
        HiveMetaHookLoader hookLoader = new HiveMetaHookLoader(){

            public HiveMetaHook getHook(org.apache.hadoop.hive.metastore.api.Table tbl) throws MetaException {
                HiveStorageHandler storageHandler = Hive.this.createStorageHandler(tbl);
                return storageHandler == null ? null : storageHandler.getMetaHook();
            }
        };
        if (this.conf.getBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH)) {
            return new SessionHiveMetaStoreClient(this.conf, hookLoader, allowEmbedded);
        }
        return RetryingMetaStoreClient.getProxy((Configuration)this.conf, (HiveMetaHookLoader)hookLoader, this.metaCallTimeMap, (String)SessionHiveMetaStoreClient.class.getName(), (boolean)allowEmbedded);
    }

    @Nullable
    private HiveStorageHandler createStorageHandler(org.apache.hadoop.hive.metastore.api.Table tbl) throws MetaException {
        try {
            if (tbl == null) {
                return null;
            }
            HiveStorageHandler storageHandler = HiveUtils.getStorageHandler(this.conf, (String)tbl.getParameters().get("storage_handler"));
            return storageHandler;
        }
        catch (HiveException ex) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
            throw new MetaException("Failed to load storage handler:  " + ex.getMessage());
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Unstable
    public synchronized SynchronizedMetaStoreClient getSynchronizedMSC() throws MetaException {
        if (this.syncMetaStoreClient == null) {
            this.syncMetaStoreClient = new SynchronizedMetaStoreClient(this.getMSC(true, false));
        }
        return this.syncMetaStoreClient;
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Unstable
    public synchronized IMetaStoreClient getMSC() throws MetaException {
        return this.getMSC(true, false);
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive"})
    @InterfaceStability.Unstable
    public synchronized IMetaStoreClient getMSC(boolean allowEmbedded, boolean forceCreate) throws MetaException {
        if (this.metaStoreClient == null || forceCreate) {
            try {
                this.owner = UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                String msg = "Error getting current user: " + e.getMessage();
                LOG.error(msg, (Throwable)e);
                throw new MetaException(msg + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            }
            try {
                this.metaStoreClient = this.createMetaStoreClient(allowEmbedded);
            }
            catch (RuntimeException ex) {
                for (Throwable t = ex.getCause(); t != null; t = t.getCause()) {
                    if (!(t instanceof JDODataStoreException) || t.getMessage() == null || !t.getMessage().contains("autoCreate")) continue;
                    LOG.error("Cannot initialize metastore due to autoCreate error", t);
                    throw new SchemaException("Hive metastore database is not initialized. Please use schematool (e.g. ./schematool -initSchema -dbType ...) to create the schema. If needed, don't forget to include the option to auto-create the underlying database in your JDBC connection string (e.g. ?createDatabaseIfNotExist=true for mysql)");
                }
                throw ex;
            }
            String metaStoreUris = this.conf.getVar(HiveConf.ConfVars.METASTOREURIS);
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)metaStoreUris)) {
                this.metaStoreClient = HiveMetaStoreClient.newSynchronizedClient((IMetaStoreClient)this.metaStoreClient);
            }
        }
        return this.metaStoreClient;
    }

    private static String getUserName() {
        return SessionState.getUserFromAuthenticator();
    }

    private List<String> getGroupNames() {
        SessionState ss = SessionState.get();
        if (ss != null && ss.getAuthenticator() != null) {
            return ss.getAuthenticator().getGroupNames();
        }
        return null;
    }

    public static List<FieldSchema> getFieldsFromDeserializer(String name, Deserializer serde) throws HiveException {
        try {
            return HiveMetaStoreUtils.getFieldsFromDeserializer((String)name, (Deserializer)serde);
        }
        catch (SerDeException e) {
            throw new HiveException("Error in getting fields from serde. " + e.getMessage(), e);
        }
        catch (MetaException e) {
            throw new HiveException("Error in getting fields from serde." + e.getMessage(), e);
        }
    }

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws HiveException {
        try {
            return this.getMSC().setPartitionColumnStatistics(request);
        }
        catch (Exception e) {
            LOG.debug(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws HiveException {
        try {
            return this.getMSC().getTableColumnStatistics(dbName, tableName, colNames);
        }
        catch (Exception e) {
            LOG.debug(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames) throws HiveException {
        try {
            return this.getMSC().getPartitionColumnStatistics(dbName, tableName, partNames, colNames);
        }
        catch (Exception e) {
            LOG.debug(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName) {
        try {
            return this.getMSC().getAggrColStatsFor(dbName, tblName, colNames, partName);
        }
        catch (Exception e) {
            LOG.debug(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return new AggrStats(new ArrayList(), 0L);
        }
    }

    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws HiveException {
        try {
            return this.getMSC().deleteTableColumnStatistics(dbName, tableName, colName);
        }
        catch (Exception e) {
            LOG.debug(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName) throws HiveException {
        try {
            return this.getMSC().deletePartitionColumnStatistics(dbName, tableName, partName, colName);
        }
        catch (Exception e) {
            LOG.debug(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public Table newTable(String tableName) throws HiveException {
        String[] names = Utilities.getDbTableName((String)tableName);
        return new Table(names[0], names[1]);
    }

    public String getDelegationToken(String owner, String renewer) throws HiveException {
        try {
            return this.getMSC().getDelegationToken(owner, renewer);
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void cancelDelegationToken(String tokenStrForm) throws HiveException {
        try {
            this.getMSC().cancelDelegationToken(tokenStrForm);
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    @Deprecated
    public void compact(String dbname, String tableName, String partName, String compactType, Map<String, String> tblproperties) throws HiveException {
        this.compact2(dbname, tableName, partName, compactType, tblproperties);
    }

    public CompactionResponse compact2(String dbname, String tableName, String partName, String compactType, Map<String, String> tblproperties) throws HiveException {
        try {
            CompactionType cr = null;
            if ("major".equalsIgnoreCase(compactType)) {
                cr = CompactionType.MAJOR;
            } else if ("minor".equalsIgnoreCase(compactType)) {
                cr = CompactionType.MINOR;
            } else {
                throw new RuntimeException("Unknown compaction type " + compactType);
            }
            return this.getMSC().compact2(dbname, tableName, partName, cr, tblproperties);
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public ShowCompactResponse showCompactions() throws HiveException {
        try {
            return this.getMSC().showCompactions();
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public GetOpenTxnsInfoResponse showTransactions() throws HiveException {
        try {
            return this.getMSC().showTxns();
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void abortTransactions(List<Long> txnids) throws HiveException {
        try {
            this.getMSC().abortTxns(txnids);
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public void createFunction(org.apache.hadoop.hive.metastore.api.Function func) throws HiveException {
        try {
            this.getMSC().createFunction(func);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void alterFunction(String dbName, String funcName, org.apache.hadoop.hive.metastore.api.Function newFunction) throws HiveException {
        try {
            this.getMSC().alterFunction(dbName, funcName, newFunction);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void dropFunction(String dbName, String funcName) throws HiveException {
        try {
            this.getMSC().dropFunction(dbName, funcName);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public org.apache.hadoop.hive.metastore.api.Function getFunction(String dbName, String funcName) throws HiveException {
        try {
            return this.getMSC().getFunction(dbName, funcName);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Function> getAllFunctions() throws HiveException {
        try {
            List functions = this.getMSC().getAllFunctions().getFunctions();
            return functions == null ? new ArrayList() : functions;
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public List<String> getFunctions(String dbName, String pattern) throws HiveException {
        try {
            return this.getMSC().getFunctions(dbName, pattern);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void setMetaConf(String propName, String propValue) throws HiveException {
        try {
            this.getMSC().setMetaConf(propName, propValue);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public String getMetaConf(String propName) throws HiveException {
        try {
            return this.getMSC().getMetaConf(propName);
        }
        catch (TException te) {
            throw new HiveException(te);
        }
    }

    public void clearMetaCallTiming() {
        this.metaCallTimeMap.clear();
    }

    public ImmutableMap<String, Long> dumpAndClearMetaCallTiming(String phase) {
        boolean phaseInfoLogged = false;
        if (LOG.isDebugEnabled()) {
            phaseInfoLogged = this.logDumpPhase(phase);
            LOG.debug("Total time spent in each metastore function (ms): " + this.metaCallTimeMap);
        }
        if (LOG.isInfoEnabled()) {
            for (Map.Entry<String, Long> callTime : this.metaCallTimeMap.entrySet()) {
                if (callTime.getValue() <= 1000L) continue;
                if (!phaseInfoLogged) {
                    phaseInfoLogged = this.logDumpPhase(phase);
                }
                LOG.info("Total time spent in this metastore function was greater than 1000ms : " + callTime);
            }
        }
        ImmutableMap<String, Long> result = ImmutableMap.copyOf(this.metaCallTimeMap);
        this.metaCallTimeMap.clear();
        return result;
    }

    private boolean logDumpPhase(String phase) {
        LOG.info("Dumping metastore api call timing information for : " + phase + " phase");
        return true;
    }

    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> fileIds) throws HiveException {
        try {
            return this.getMSC().getFileMetadata(fileIds);
        }
        catch (TException e) {
            throw new HiveException(e);
        }
    }

    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataByExpr(List<Long> fileIds, ByteBuffer sarg, boolean doGetFooters) throws HiveException {
        try {
            return this.getMSC().getFileMetadataBySarg(fileIds, sarg, doGetFooters);
        }
        catch (TException e) {
            throw new HiveException(e);
        }
    }

    public void clearFileMetadata(List<Long> fileIds) throws HiveException {
        try {
            this.getMSC().clearFileMetadata(fileIds);
        }
        catch (TException e) {
            throw new HiveException(e);
        }
    }

    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) throws HiveException {
        try {
            this.getMSC().putFileMetadata(fileIds, metadata);
        }
        catch (TException e) {
            throw new HiveException(e);
        }
    }

    public void cacheFileMetadata(String dbName, String tableName, String partName, boolean allParts) throws HiveException {
        try {
            boolean willCache = this.getMSC().cacheFileMetadata(dbName, tableName, partName, allParts);
            if (!willCache) {
                throw new HiveException("Caching file metadata is not supported by metastore or for this file format");
            }
        }
        catch (TException e) {
            throw new HiveException(e);
        }
    }

    public void dropConstraint(String dbName, String tableName, String constraintName) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().dropConstraint(dbName, tableName, constraintName);
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<SQLPrimaryKey> getPrimaryKeyList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getPrimaryKeys(new PrimaryKeysRequest(dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<SQLForeignKey> getForeignKeyList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getForeignKeys(new ForeignKeysRequest(null, null, dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<SQLUniqueConstraint> getUniqueConstraintList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getUniqueConstraints(new UniqueConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<SQLNotNullConstraint> getNotNullConstraintList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getNotNullConstraints(new NotNullConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<SQLDefaultConstraint> getDefaultConstraintList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getDefaultConstraints(new DefaultConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<SQLCheckConstraint> getCheckConstraintList(String dbName, String tblName) throws HiveException, NoSuchObjectException {
        try {
            return this.getMSC().getCheckConstraints(new CheckConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public PrimaryKeyInfo getPrimaryKeys(String dbName, String tblName) throws HiveException {
        return this.getPrimaryKeys(dbName, tblName, false);
    }

    public PrimaryKeyInfo getReliablePrimaryKeys(String dbName, String tblName) throws HiveException {
        return this.getPrimaryKeys(dbName, tblName, true);
    }

    private PrimaryKeyInfo getPrimaryKeys(String dbName, String tblName, boolean onlyReliable) throws HiveException {
        try {
            List primaryKeys = this.getMSC().getPrimaryKeys(new PrimaryKeysRequest(dbName, tblName));
            if (onlyReliable && primaryKeys != null && !primaryKeys.isEmpty()) {
                primaryKeys = primaryKeys.stream().filter(pk -> pk.isRely_cstr()).collect(Collectors.toList());
            }
            return new PrimaryKeyInfo(primaryKeys, tblName, dbName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public ForeignKeyInfo getForeignKeys(String dbName, String tblName) throws HiveException {
        return this.getForeignKeys(dbName, tblName, false);
    }

    public ForeignKeyInfo getReliableForeignKeys(String dbName, String tblName) throws HiveException {
        return this.getForeignKeys(dbName, tblName, true);
    }

    private ForeignKeyInfo getForeignKeys(String dbName, String tblName, boolean onlyReliable) throws HiveException {
        try {
            List foreignKeys = this.getMSC().getForeignKeys(new ForeignKeysRequest(null, null, dbName, tblName));
            if (onlyReliable && foreignKeys != null && !foreignKeys.isEmpty()) {
                foreignKeys = foreignKeys.stream().filter(fk -> fk.isRely_cstr()).collect(Collectors.toList());
            }
            return new ForeignKeyInfo(foreignKeys, tblName, dbName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public UniqueConstraint getUniqueConstraints(String dbName, String tblName) throws HiveException {
        return this.getUniqueConstraints(dbName, tblName, false);
    }

    public UniqueConstraint getReliableUniqueConstraints(String dbName, String tblName) throws HiveException {
        return this.getUniqueConstraints(dbName, tblName, true);
    }

    private UniqueConstraint getUniqueConstraints(String dbName, String tblName, boolean onlyReliable) throws HiveException {
        try {
            List uniqueConstraints = this.getMSC().getUniqueConstraints(new UniqueConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (onlyReliable && uniqueConstraints != null && !uniqueConstraints.isEmpty()) {
                uniqueConstraints = uniqueConstraints.stream().filter(uk -> uk.isRely_cstr()).collect(Collectors.toList());
            }
            return new UniqueConstraint(uniqueConstraints, tblName, dbName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public NotNullConstraint getNotNullConstraints(String dbName, String tblName) throws HiveException {
        return this.getNotNullConstraints(dbName, tblName, false);
    }

    public NotNullConstraint getReliableNotNullConstraints(String dbName, String tblName) throws HiveException {
        return this.getNotNullConstraints(dbName, tblName, true);
    }

    public NotNullConstraint getEnabledNotNullConstraints(String dbName, String tblName) throws HiveException {
        try {
            List notNullConstraints = this.getMSC().getNotNullConstraints(new NotNullConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (notNullConstraints != null && !notNullConstraints.isEmpty()) {
                notNullConstraints = notNullConstraints.stream().filter(nnc -> nnc.isEnable_cstr()).collect(Collectors.toList());
            }
            return new NotNullConstraint(notNullConstraints, tblName, dbName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public CheckConstraint getEnabledCheckConstraints(String dbName, String tblName) throws HiveException {
        try {
            List checkConstraints = this.getMSC().getCheckConstraints(new CheckConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (checkConstraints != null && !checkConstraints.isEmpty()) {
                checkConstraints = checkConstraints.stream().filter(nnc -> nnc.isEnable_cstr()).collect(Collectors.toList());
            }
            return new CheckConstraint(checkConstraints);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public DefaultConstraint getEnabledDefaultConstraints(String dbName, String tblName) throws HiveException {
        try {
            List defaultConstraints = this.getMSC().getDefaultConstraints(new DefaultConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (defaultConstraints != null && !defaultConstraints.isEmpty()) {
                defaultConstraints = defaultConstraints.stream().filter(nnc -> nnc.isEnable_cstr()).collect(Collectors.toList());
            }
            return new DefaultConstraint(defaultConstraints, tblName, dbName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private NotNullConstraint getNotNullConstraints(String dbName, String tblName, boolean onlyReliable) throws HiveException {
        try {
            List notNullConstraints = this.getMSC().getNotNullConstraints(new NotNullConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (onlyReliable && notNullConstraints != null && !notNullConstraints.isEmpty()) {
                notNullConstraints = notNullConstraints.stream().filter(nnc -> nnc.isRely_cstr()).collect(Collectors.toList());
            }
            return new NotNullConstraint(notNullConstraints, tblName, dbName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public DefaultConstraint getDefaultConstraints(String dbName, String tblName) throws HiveException {
        try {
            List defaultConstraints = this.getMSC().getDefaultConstraints(new DefaultConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (defaultConstraints != null && !defaultConstraints.isEmpty()) {
                defaultConstraints = defaultConstraints.stream().collect(Collectors.toList());
            }
            return new DefaultConstraint(defaultConstraints, tblName, dbName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public CheckConstraint getCheckConstraints(String dbName, String tblName) throws HiveException {
        try {
            List checkConstraints = this.getMSC().getCheckConstraints(new CheckConstraintsRequest(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName, tblName));
            if (checkConstraints != null && !checkConstraints.isEmpty()) {
                checkConstraints = checkConstraints.stream().collect(Collectors.toList());
            }
            return new CheckConstraint(checkConstraints);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addPrimaryKey(primaryKeyCols);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void addForeignKey(List<SQLForeignKey> foreignKeyCols) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addForeignKey(foreignKeyCols);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void addUniqueConstraint(List<SQLUniqueConstraint> uniqueConstraintCols) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addUniqueConstraint(uniqueConstraintCols);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void addNotNullConstraint(List<SQLNotNullConstraint> notNullConstraintCols) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addNotNullConstraint(notNullConstraintCols);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void addDefaultConstraint(List<SQLDefaultConstraint> defaultConstraints) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addDefaultConstraint(defaultConstraints);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void addCheckConstraint(List<SQLCheckConstraint> checkConstraints) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().addCheckConstraint(checkConstraints);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createResourcePlan(WMResourcePlan resourcePlan, String copyFromName) throws HiveException {
        try {
            this.getMSC().createResourcePlan(resourcePlan, copyFromName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public WMFullResourcePlan getResourcePlan(String rpName) throws HiveException {
        try {
            return this.getMSC().getResourcePlan(rpName);
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<WMResourcePlan> getAllResourcePlans() throws HiveException {
        try {
            return this.getMSC().getAllResourcePlans();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void dropResourcePlan(String rpName) throws HiveException {
        try {
            this.getMSC().dropResourcePlan(rpName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public WMFullResourcePlan alterResourcePlan(String rpName, WMNullableResourcePlan resourcePlan, boolean canActivateDisabled, boolean isForceDeactivate, boolean isReplace) throws HiveException {
        try {
            return this.getMSC().alterResourcePlan(rpName, resourcePlan, canActivateDisabled, isForceDeactivate, isReplace);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public WMFullResourcePlan getActiveResourcePlan() throws HiveException {
        try {
            return this.getMSC().getActiveResourcePlan();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public WMValidateResourcePlanResponse validateResourcePlan(String rpName) throws HiveException {
        try {
            return this.getMSC().validateResourcePlan(rpName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createWMTrigger(WMTrigger trigger) throws HiveException {
        try {
            this.getMSC().createWMTrigger(trigger);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void alterWMTrigger(WMTrigger trigger) throws HiveException {
        try {
            this.getMSC().alterWMTrigger(trigger);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void dropWMTrigger(String rpName, String triggerName) throws HiveException {
        try {
            this.getMSC().dropWMTrigger(rpName, triggerName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createWMPool(WMPool pool) throws HiveException {
        try {
            this.getMSC().createWMPool(pool);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void alterWMPool(WMNullablePool pool, String poolPath) throws HiveException {
        try {
            this.getMSC().alterWMPool(pool, poolPath);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void dropWMPool(String resourcePlanName, String poolPath) throws HiveException {
        try {
            this.getMSC().dropWMPool(resourcePlanName, poolPath);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createOrUpdateWMMapping(WMMapping mapping, boolean isUpdate) throws HiveException {
        try {
            this.getMSC().createOrUpdateWMMapping(mapping, isUpdate);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void dropWMMapping(WMMapping mapping) throws HiveException {
        try {
            this.getMSC().dropWMMapping(mapping);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createOrDropTriggerToPoolMapping(String resourcePlanName, String triggerName, String poolPath, boolean shouldDrop) throws HiveException {
        try {
            this.getMSC().createOrDropTriggerToPoolMapping(resourcePlanName, triggerName, poolPath, shouldDrop);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Nullable
    public StorageHandlerInfo getStorageHandlerInfo(Table table) throws HiveException {
        try {
            HiveStorageHandler storageHandler = this.createStorageHandler(table.getTTable());
            return storageHandler == null ? null : storageHandler.getStorageHandlerInfo(table.getTTable());
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public static class SchemaException
    extends MetaException {
        private static final long serialVersionUID = 1L;

        public SchemaException(String message) {
            super(message);
        }
    }
}

