/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class FilterDecimalColEqualDecimalColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum1;
    private final int colNum2;

    public FilterDecimalColEqualDecimalColumn(int colNum1, int colNum2) {
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public FilterDecimalColEqualDecimalColumn() {
        this.colNum1 = -1;
        this.colNum2 = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DecimalColumnVector inputColVector1 = (DecimalColumnVector)batch.cols[this.colNum1];
        DecimalColumnVector inputColVector2 = (DecimalColumnVector)batch.cols[this.colNum2];
        int[] sel = batch.selected;
        boolean[] nullPos1 = inputColVector1.isNull;
        boolean[] nullPos2 = inputColVector2.isNull;
        HiveDecimalWritable[] vector1 = inputColVector1.vector;
        HiveDecimalWritable[] vector2 = inputColVector2.vector;
        if (inputColVector1.noNulls && inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (vector1[0].compareTo(vector2[0]) != 0) {
                    batch.size = 0;
                }
            } else if (inputColVector1.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (vector1[0].compareTo(vector2[i]) != 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (vector1[0].compareTo(vector2[i]) != 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (vector1[i].compareTo(vector2[0]) != 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (vector1[i].compareTo(vector2[0]) != 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (vector1[i].compareTo(vector2[i]) != 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (vector1[i].compareTo(vector2[i]) != 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector1.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (nullPos2[0] || vector1[0].compareTo(vector2[0]) != 0) {
                    batch.size = 0;
                }
            } else if (inputColVector1.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (nullPos2[i] || vector1[0].compareTo(vector2[i]) != 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (nullPos2[i] || vector1[0].compareTo(vector2[i]) != 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (nullPos2[0]) {
                    batch.size = 0;
                    return;
                }
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (vector1[i].compareTo(vector2[0]) != 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (vector1[i].compareTo(vector2[0]) != 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos2[i] || vector1[i].compareTo(vector2[i]) != 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos2[i] || vector1[i].compareTo(vector2[i]) != 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (nullPos1[0] || vector1[0].compareTo(vector2[0]) != 0) {
                    batch.size = 0;
                    return;
                }
            } else if (inputColVector1.isRepeating) {
                if (nullPos1[0]) {
                    batch.size = 0;
                    return;
                }
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (vector1[0].compareTo(vector2[i]) != 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (vector1[0].compareTo(vector2[i]) != 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (nullPos1[i] || vector1[i].compareTo(vector2[0]) != 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (nullPos1[i] || vector1[i].compareTo(vector2[0]) != 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos1[i] || vector1[i].compareTo(vector2[i]) != 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos1[i] || vector1[i].compareTo(vector2[i]) != 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            if (nullPos1[0] || nullPos2[0] || vector1[0].compareTo(vector2[0]) != 0) {
                batch.size = 0;
            }
        } else if (inputColVector1.isRepeating) {
            if (nullPos1[0]) {
                batch.size = 0;
                return;
            }
            if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos2[i] || vector1[0].compareTo(vector2[i]) != 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos2[i] || vector1[0].compareTo(vector2[i]) != 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (nullPos2[0]) {
                batch.size = 0;
                return;
            }
            if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos1[i] || vector1[i].compareTo(vector2[0]) != 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos1[i] || vector1[i].compareTo(vector2[0]) != 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos1[i] || nullPos2[i] || vector1[i].compareTo(vector2[i]) != 0) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos1[i] || nullPos2[i] || vector1[i].compareTo(vector2[i]) != 0) continue;
                sel[newSize++] = i;
            }
            if (newSize < batch.size) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum1) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"decimal"), VectorExpressionDescriptor.ArgumentType.getType((String)"decimal")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

