/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongScalarEqualLongColumn;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;

public class DateScalarEqualDateColumn
extends LongScalarEqualLongColumn {
    private static final long serialVersionUID = 1L;

    public DateScalarEqualDateColumn(long value, int colNum, int outputColumnNum) {
        super(value, colNum, outputColumnNum);
    }

    public DateScalarEqualDateColumn() {
    }

    @Override
    public String vectorExpressionParameters() {
        Date dt = Date.ofEpochMilli(DateWritableV2.daysToMillis((int)this.value));
        return "date " + dt.toString() + ", " + this.getColumnParamString(0, this.colNum);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.getType((String)"date"), VectorExpressionDescriptor.ArgumentType.getType((String)"date")}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

