/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexBaseCol;

public class VectorUDFMapIndexStringCol
extends VectorUDFMapIndexBaseCol {
    public VectorUDFMapIndexStringCol() {
    }

    public VectorUDFMapIndexStringCol(int mapColumnNum, int indexColumnNum, int outputColumnNum) {
        super(mapColumnNum, indexColumnNum, outputColumnNum);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.getMapColumnNum()) + ", key: " + this.getColumnParamString(1, this.getIndexColumnNum());
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.MAP, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }

    @Override
    protected Object getKeyByIndex(ColumnVector cv, int index) {
        BytesColumnVector bytesCV = (BytesColumnVector)cv;
        return ArrayUtils.subarray((byte[])bytesCV.vector[index], (int)bytesCV.start[index], (int)(bytesCV.start[index] + bytesCV.length[index]));
    }

    @Override
    protected boolean compareKeyInternal(Object columnKey, Object otherKey) {
        return Arrays.equals((byte[])columnKey, (byte[])otherKey);
    }
}

