/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexBaseScalar;

public class VectorUDFMapIndexDoubleScalar
extends VectorUDFMapIndexBaseScalar {
    private HiveDecimal key;

    public VectorUDFMapIndexDoubleScalar() {
    }

    public VectorUDFMapIndexDoubleScalar(int mapColumnNum, HiveDecimal key, int outputColumnNum) {
        super(mapColumnNum, outputColumnNum);
        this.key = key;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.getMapColumnNum()) + ", key: " + this.key;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.MAP, VectorExpressionDescriptor.ArgumentType.DECIMAL}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }

    @Override
    protected Object getKeyByIndex(ColumnVector cv, int index) {
        return ((DoubleColumnVector)cv).vector[index];
    }

    @Override
    public Object getCurrentKey(int index) {
        return this.key;
    }

    @Override
    protected boolean compareKeyInternal(Object columnKey, Object otherKey) {
        return otherKey.equals(((HiveDecimal)columnKey).doubleValue());
    }
}

