/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.DateParser;

public class VectorUDFDateAddColScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum;
    private final int numDays;
    protected boolean isPositive = true;
    private final transient Text text = new Text();
    private final transient DateParser dateParser = new DateParser();
    private transient PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;

    public VectorUDFDateAddColScalar(int colNum, long numDays, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
        this.numDays = (int)numDays;
    }

    public VectorUDFDateAddColScalar() {
        this.colNum = -1;
        this.numDays = 0;
    }

    @Override
    public void transientInit() throws HiveException {
        super.transientInit();
        this.primitiveCategory = ((PrimitiveTypeInfo)this.inputTypeInfos[0]).getPrimitiveCategory();
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        ColumnVector inputCol = batch.cols[this.colNum];
        int n = inputCol.isRepeating ? 1 : batch.size;
        int[] sel = batch.selected;
        boolean selectedInUse = !inputCol.isRepeating && batch.selectedInUse;
        boolean[] outputIsNull = outputColVector.isNull;
        if (batch.size == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        switch (this.primitiveCategory) {
            case DATE: {
                if (inputCol.isRepeating) {
                    if (inputCol.noNulls || !inputCol.isNull[0]) {
                        outputColVector.isNull[0] = false;
                        outputColVector.vector[0] = this.evaluateDate(inputCol, 0);
                    } else {
                        outputColVector.isNull[0] = true;
                        outputColVector.noNulls = false;
                    }
                    outputColVector.isRepeating = true;
                    break;
                }
                if (inputCol.noNulls) {
                    if (batch.selectedInUse) {
                        if (!outputColVector.noNulls) {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outputIsNull[i] = false;
                                outputColVector.vector[i] = this.evaluateDate(inputCol, i);
                            }
                        } else {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outputColVector.vector[i] = this.evaluateDate(inputCol, i);
                            }
                        }
                    } else {
                        if (!outputColVector.noNulls) {
                            Arrays.fill(outputIsNull, false);
                            outputColVector.noNulls = true;
                        }
                        for (int i = 0; i != n; ++i) {
                            outputColVector.vector[i] = this.evaluateDate(inputCol, i);
                        }
                    }
                } else {
                    outputColVector.noNulls = false;
                    if (selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outputColVector.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outputColVector.vector[i] = this.evaluateDate(inputCol, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputColVector.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outputColVector.vector[i] = this.evaluateDate(inputCol, i);
                        }
                    }
                }
                break;
            }
            case TIMESTAMP: {
                if (inputCol.isRepeating) {
                    if (inputCol.noNulls || !inputCol.isNull[0]) {
                        outputColVector.isNull[0] = false;
                        outputColVector.vector[0] = this.evaluateTimestamp(inputCol, 0);
                    } else {
                        outputColVector.isNull[0] = true;
                        outputColVector.noNulls = false;
                    }
                    outputColVector.isRepeating = true;
                    break;
                }
                if (inputCol.noNulls) {
                    if (batch.selectedInUse) {
                        if (!outputColVector.noNulls) {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outputIsNull[i] = false;
                                outputColVector.vector[i] = this.evaluateTimestamp(inputCol, i);
                            }
                        } else {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outputColVector.vector[i] = this.evaluateTimestamp(inputCol, i);
                            }
                        }
                    } else {
                        if (!outputColVector.noNulls) {
                            Arrays.fill(outputIsNull, false);
                            outputColVector.noNulls = true;
                        }
                        for (int i = 0; i != n; ++i) {
                            outputColVector.vector[i] = this.evaluateTimestamp(inputCol, i);
                        }
                    }
                } else {
                    outputColVector.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outputColVector.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outputColVector.vector[i] = this.evaluateTimestamp(inputCol, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputColVector.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outputColVector.vector[i] = this.evaluateTimestamp(inputCol, i);
                        }
                    }
                }
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                if (inputCol.isRepeating) {
                    if (inputCol.noNulls || !inputCol.isNull[0]) {
                        outputColVector.isNull[0] = false;
                        this.evaluateString(inputCol, outputColVector, 0);
                    } else {
                        outputColVector.isNull[0] = true;
                        outputColVector.noNulls = false;
                    }
                    outputColVector.isRepeating = true;
                    break;
                }
                if (inputCol.noNulls) {
                    if (batch.selectedInUse) {
                        if (!outputColVector.noNulls) {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                outputIsNull[i] = false;
                                this.evaluateString(inputCol, outputColVector, i);
                            }
                        } else {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                this.evaluateString(inputCol, outputColVector, i);
                            }
                        }
                    } else {
                        if (!outputColVector.noNulls) {
                            Arrays.fill(outputIsNull, false);
                            outputColVector.noNulls = true;
                        }
                        for (int i = 0; i != n; ++i) {
                            this.evaluateString(inputCol, outputColVector, i);
                        }
                    }
                } else {
                    outputColVector.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outputColVector.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            this.evaluateString(inputCol, outputColVector, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputColVector.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            this.evaluateString(inputCol, outputColVector, i);
                        }
                    }
                }
                break;
            }
            default: {
                throw new Error("Unsupported input type " + this.primitiveCategory.name());
            }
        }
    }

    protected long evaluateTimestamp(ColumnVector columnVector, int index) {
        TimestampColumnVector tcv = (TimestampColumnVector)columnVector;
        long days = DateWritableV2.millisToDays(tcv.getTime(index));
        days = this.isPositive ? (days += (long)this.numDays) : (days -= (long)this.numDays);
        return days;
    }

    protected long evaluateDate(ColumnVector columnVector, int index) {
        LongColumnVector lcv = (LongColumnVector)columnVector;
        long days = lcv.vector[index];
        days = this.isPositive ? (days += (long)this.numDays) : (days -= (long)this.numDays);
        return days;
    }

    protected void evaluateString(ColumnVector columnVector, LongColumnVector outputVector, int i) {
        BytesColumnVector bcv = (BytesColumnVector)columnVector;
        this.text.set(bcv.vector[i], bcv.start[i], bcv.length[i]);
        Date hDate = new Date();
        boolean parsed = this.dateParser.parseDate(this.text.toString(), hDate);
        if (!parsed) {
            outputVector.noNulls = false;
            outputVector.isNull[i] = true;
            return;
        }
        long days = DateWritableV2.millisToDays(hDate.toEpochMilli());
        days = this.isPositive ? (days += (long)this.numDays) : (days -= (long)this.numDays);
        outputVector.vector[i] = days;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum) + ", val " + this.numDays;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR});
        return b.build();
    }
}

