/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class StringSubstrColStart
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum;
    private int startIdx;
    private static transient byte[] EMPTY_STRING;

    public StringSubstrColStart(int colNum, int startIdx, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
        this.startIdx = startIdx >= 1 ? startIdx - 1 : (startIdx == 0 ? 0 : startIdx);
    }

    public StringSubstrColStart() {
        this.colNum = -1;
        this.startIdx = -1;
    }

    static int getSubstrStartOffset(byte[] utf8String, int start, int len, int substrStart) {
        int i;
        int end = start + len;
        if (substrStart < 0) {
            int length = 0;
            for (i = start; i != end; ++i) {
                if ((utf8String[i] & 0xC0) == 128) continue;
                ++length;
            }
            if (-substrStart > length) {
                return -1;
            }
            substrStart = length + substrStart;
        }
        int curIdx = -1;
        for (i = start; i != end; ++i) {
            if ((utf8String[i] & 0xC0) == 128 || ++curIdx != substrStart) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inV = (BytesColumnVector)batch.cols[this.colNum];
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[this.outputColumnNum];
        int n = batch.size;
        if (n == 0) {
            return;
        }
        byte[][] vector = inV.vector;
        int[] sel = batch.selected;
        int[] len = inV.length;
        int[] start = inV.start;
        outputColVector.initBuffer();
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        if (inV.isRepeating) {
            if (inV.noNulls || !inV.isNull[0]) {
                outputIsNull[0] = false;
                int offset = StringSubstrColStart.getSubstrStartOffset(vector[0], start[0], len[0], this.startIdx);
                if (offset != -1) {
                    outputColVector.setVal(0, vector[0], offset, len[0] - (offset - start[0]));
                } else {
                    outputColVector.setVal(0, EMPTY_STRING, 0, EMPTY_STRING.length);
                }
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
                outputColVector.setVal(0, EMPTY_STRING, 0, EMPTY_STRING.length);
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (batch.selectedInUse) {
            if (!inV.noNulls) {
                for (int i = 0; i != n; ++i) {
                    int selected = sel[i];
                    if (!inV.isNull[selected]) {
                        outputIsNull[selected] = false;
                        int offset = StringSubstrColStart.getSubstrStartOffset(vector[selected], start[selected], len[selected], this.startIdx);
                        outputColVector.isNull[selected] = false;
                        if (offset != -1) {
                            outputColVector.setVal(selected, vector[selected], offset, len[selected] - (offset - start[selected]));
                            continue;
                        }
                        outputColVector.setVal(selected, EMPTY_STRING, 0, EMPTY_STRING.length);
                        continue;
                    }
                    outputColVector.isNull[selected] = true;
                    outputColVector.noNulls = false;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    int selected = sel[i];
                    outputColVector.isNull[selected] = false;
                    int offset = StringSubstrColStart.getSubstrStartOffset(vector[selected], start[selected], len[selected], this.startIdx);
                    if (offset != -1) {
                        outputColVector.setVal(selected, vector[selected], offset, len[selected] - (offset - start[selected]));
                        continue;
                    }
                    outputColVector.setVal(selected, EMPTY_STRING, 0, EMPTY_STRING.length);
                }
            }
        } else if (!inV.noNulls) {
            for (int i = 0; i != n; ++i) {
                if (!inV.isNull[i]) {
                    outputColVector.isNull[i] = false;
                    int offset = StringSubstrColStart.getSubstrStartOffset(vector[i], start[i], len[i], this.startIdx);
                    if (offset != -1) {
                        outputColVector.setVal(i, vector[i], offset, len[i] - (offset - start[i]));
                        continue;
                    }
                    outputColVector.setVal(i, EMPTY_STRING, 0, EMPTY_STRING.length);
                    continue;
                }
                outputColVector.isNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            if (!outputColVector.noNulls) {
                Arrays.fill(outputIsNull, false);
                outputColVector.noNulls = true;
            }
            for (int i = 0; i != n; ++i) {
                int offset = StringSubstrColStart.getSubstrStartOffset(vector[i], start[i], len[i], this.startIdx);
                if (offset != -1) {
                    outputColVector.setVal(i, vector[i], offset, len[i] - (offset - start[i]));
                    continue;
                }
                outputColVector.setVal(i, EMPTY_STRING, 0, EMPTY_STRING.length);
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum) + ", start " + this.startIdx;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR});
        return b.build();
    }

    static {
        try {
            EMPTY_STRING = "".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

