/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ListIndexColScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int listColumnNum;
    private int index;

    public ListIndexColScalar() {
    }

    public ListIndexColScalar(int listColumn, int index, int outputColumnNum) {
        super(outputColumnNum);
        this.listColumnNum = listColumn;
        this.index = index;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector outV = batch.cols[this.outputColumnNum];
        ListColumnVector listV = (ListColumnVector)batch.cols[this.listColumnNum];
        ColumnVector childV = listV.child;
        if (listV.isRepeating) {
            if (listV.isNull[0]) {
                outV.isNull[0] = true;
                outV.noNulls = false;
            } else if ((long)this.index >= listV.lengths[0]) {
                outV.isNull[0] = true;
                outV.noNulls = false;
            } else {
                outV.isNull[0] = false;
                outV.setElement(0, (int)(listV.offsets[0] + (long)this.index), childV);
            }
            outV.isRepeating = true;
        } else {
            for (int i = 0; i < batch.size; ++i) {
                int j;
                int n = j = batch.selectedInUse ? batch.selected[i] : i;
                if (listV.isNull[j] || (long)this.index >= listV.lengths[j]) {
                    outV.isNull[j] = true;
                    outV.noNulls = false;
                    continue;
                }
                outV.isNull[j] = false;
                outV.setElement(j, (int)(listV.offsets[j] + (long)this.index), childV);
            }
            outV.isRepeating = false;
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.listColumnNum) + ", " + this.getColumnParamString(1, this.index);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.LIST, VectorExpressionDescriptor.ArgumentType.INT_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }
}

