/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ListIndexColColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int listColumnNum;
    private int indexColumnNum;

    public ListIndexColColumn() {
    }

    public ListIndexColColumn(int listColumnNum, int indexColumnNum, int outputColumnNum) {
        super(outputColumnNum);
        this.listColumnNum = listColumnNum;
        this.indexColumnNum = indexColumnNum;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector outV = batch.cols[this.outputColumnNum];
        ListColumnVector listV = (ListColumnVector)batch.cols[this.listColumnNum];
        ColumnVector childV = listV.child;
        LongColumnVector indexColumnVector = (LongColumnVector)batch.cols[this.indexColumnNum];
        long[] indexV = indexColumnVector.vector;
        outV.isRepeating = false;
        if (listV.isRepeating) {
            if (listV.isNull[0]) {
                outV.isNull[0] = true;
                outV.noNulls = false;
                outV.isRepeating = true;
            } else if (indexColumnVector.isRepeating) {
                if (indexV[0] >= listV.lengths[0]) {
                    outV.isNull[0] = true;
                    outV.noNulls = false;
                } else {
                    outV.isNull[0] = false;
                    outV.setElement(0, (int)(listV.offsets[0] + indexV[0]), childV);
                }
                outV.isRepeating = true;
            } else {
                for (int i = 0; i < batch.size; ++i) {
                    int j;
                    int n = j = batch.selectedInUse ? batch.selected[i] : i;
                    if (indexV[j] >= listV.lengths[0]) {
                        outV.isNull[j] = true;
                        outV.noNulls = false;
                        continue;
                    }
                    outV.isNull[j] = false;
                    outV.setElement(j, (int)(listV.offsets[0] + indexV[j]), childV);
                }
            }
        } else {
            for (int i = 0; i < batch.size; ++i) {
                int j;
                int n = j = batch.selectedInUse ? batch.selected[i] : i;
                if (listV.isNull[j] || indexV[j] >= listV.lengths[j]) {
                    outV.isNull[j] = true;
                    outV.noNulls = false;
                    continue;
                }
                outV.isNull[j] = false;
                outV.setElement(j, (int)(listV.offsets[j] + indexV[j]), childV);
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.listColumnNum) + ", " + this.getColumnParamString(1, this.indexColumnNum);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.LIST, VectorExpressionDescriptor.ArgumentType.INT_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN}).build();
    }
}

