/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class FuncRoundWithNumDigitsDecimalToDecimal
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum;
    private int decimalPlaces;

    public FuncRoundWithNumDigitsDecimalToDecimal(int colNum, int scalarValue, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
        this.decimalPlaces = scalarValue;
    }

    public FuncRoundWithNumDigitsDecimalToDecimal() {
        this.colNum = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
        DecimalColumnVector inputColVector = (DecimalColumnVector)batch.cols[this.colNum];
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        HiveDecimalWritable[] vector = inputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.round(0, vector[0], this.decimalPlaces, outputColVector);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.round(i, vector[i], this.decimalPlaces, outputColVector);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.round(i, vector[i], this.decimalPlaces, outputColVector);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.round(i, vector[i], this.decimalPlaces, outputColVector);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    this.round(i, vector[i], this.decimalPlaces, outputColVector);
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    this.round(i, vector[i], this.decimalPlaces, outputColVector);
                }
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum) + ", decimalPlaces " + this.decimalPlaces;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.DECIMAL, VectorExpressionDescriptor.ArgumentType.INT_FAMILY}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR}).build();
    }

    protected void round(int i, HiveDecimalWritable input, int decimalPlaces, DecimalColumnVector outputColVector) {
        DecimalUtil.round(i, input, decimalPlaces, outputColVector);
    }
}

