/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncDoubleToDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class CastFloatToDecimal
extends FuncDoubleToDecimal {
    private static final long serialVersionUID = 1L;

    public CastFloatToDecimal() {
    }

    public CastFloatToDecimal(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
    }

    @Override
    protected void func(DecimalColumnVector outV, DoubleColumnVector inV, int i) {
        HiveDecimalWritable decWritable = outV.vector[i];
        byte[] floatBytes = Float.toString((float)inV.vector[i]).getBytes();
        decWritable.setFromBytes(floatBytes, 0, floatBytes.length);
        if (!decWritable.mutateEnforcePrecisionScale(outV.precision, outV.scale)) {
            outV.isNull[i] = true;
            outV.noNulls = false;
        }
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(new VectorExpressionDescriptor.ArgumentType[]{VectorExpressionDescriptor.ArgumentType.FLOAT}).setInputExpressionTypes(new VectorExpressionDescriptor.InputExpressionType[]{VectorExpressionDescriptor.InputExpressionType.COLUMN});
        return b.build();
    }
}

