/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.thrift.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TEnum;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TUnion;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class PropValueUnion
extends TUnion<PropValueUnion, _Fields> {
    private static final TStruct STRUCT_DESC = new TStruct("PropValueUnion");
    private static final TField INT_VALUE_FIELD_DESC = new TField("intValue", 8, 1);
    private static final TField LONG_VALUE_FIELD_DESC = new TField("longValue", 10, 2);
    private static final TField STRING_VALUE_FIELD_DESC = new TField("stringValue", 11, 3);
    private static final TField DOUBLE_VALUE_FIELD_DESC = new TField("doubleValue", 4, 4);
    private static final TField FLAG_FIELD_DESC = new TField("flag", 2, 5);
    private static final TField L_STRING_FIELD_DESC = new TField("lString", 15, 6);
    private static final TField UNION_MSTRING_STRING_FIELD_DESC = new TField("unionMStringString", 13, 7);
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public PropValueUnion() {
    }

    public PropValueUnion(_Fields setField, Object value) {
        super((TFieldIdEnum)setField, value);
    }

    public PropValueUnion(PropValueUnion other) {
        super((TUnion)other);
    }

    public PropValueUnion deepCopy() {
        return new PropValueUnion(this);
    }

    public static PropValueUnion intValue(int value) {
        PropValueUnion x = new PropValueUnion();
        x.setIntValue(value);
        return x;
    }

    public static PropValueUnion longValue(long value) {
        PropValueUnion x = new PropValueUnion();
        x.setLongValue(value);
        return x;
    }

    public static PropValueUnion stringValue(String value) {
        PropValueUnion x = new PropValueUnion();
        x.setStringValue(value);
        return x;
    }

    public static PropValueUnion doubleValue(double value) {
        PropValueUnion x = new PropValueUnion();
        x.setDoubleValue(value);
        return x;
    }

    public static PropValueUnion flag(boolean value) {
        PropValueUnion x = new PropValueUnion();
        x.setFlag(value);
        return x;
    }

    public static PropValueUnion lString(List<String> value) {
        PropValueUnion x = new PropValueUnion();
        x.setLString(value);
        return x;
    }

    public static PropValueUnion unionMStringString(Map<String, String> value) {
        PropValueUnion x = new PropValueUnion();
        x.setUnionMStringString(value);
        return x;
    }

    protected void checkType(_Fields setField, Object value) throws ClassCastException {
        switch (setField) {
            case INT_VALUE: {
                if (value instanceof Integer) break;
                throw new ClassCastException("Was expecting value of type Integer for field 'intValue', but got " + value.getClass().getSimpleName());
            }
            case LONG_VALUE: {
                if (value instanceof Long) break;
                throw new ClassCastException("Was expecting value of type Long for field 'longValue', but got " + value.getClass().getSimpleName());
            }
            case STRING_VALUE: {
                if (value instanceof String) break;
                throw new ClassCastException("Was expecting value of type String for field 'stringValue', but got " + value.getClass().getSimpleName());
            }
            case DOUBLE_VALUE: {
                if (value instanceof Double) break;
                throw new ClassCastException("Was expecting value of type Double for field 'doubleValue', but got " + value.getClass().getSimpleName());
            }
            case FLAG: {
                if (value instanceof Boolean) break;
                throw new ClassCastException("Was expecting value of type Boolean for field 'flag', but got " + value.getClass().getSimpleName());
            }
            case L_STRING: {
                if (value instanceof List) break;
                throw new ClassCastException("Was expecting value of type List<String> for field 'lString', but got " + value.getClass().getSimpleName());
            }
            case UNION_MSTRING_STRING: {
                if (value instanceof Map) break;
                throw new ClassCastException("Was expecting value of type Map<String,String> for field 'unionMStringString', but got " + value.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unknown field id " + (Object)((Object)setField));
            }
        }
    }

    protected Object standardSchemeReadValue(TProtocol iprot, TField field) throws TException {
        _Fields setField = _Fields.findByThriftId(field.id);
        if (setField != null) {
            switch (setField) {
                case INT_VALUE: {
                    if (field.type == PropValueUnion.INT_VALUE_FIELD_DESC.type) {
                        Integer intValue = iprot.readI32();
                        return intValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case LONG_VALUE: {
                    if (field.type == PropValueUnion.LONG_VALUE_FIELD_DESC.type) {
                        Long longValue = iprot.readI64();
                        return longValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case STRING_VALUE: {
                    if (field.type == PropValueUnion.STRING_VALUE_FIELD_DESC.type) {
                        String stringValue = iprot.readString();
                        return stringValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case DOUBLE_VALUE: {
                    if (field.type == PropValueUnion.DOUBLE_VALUE_FIELD_DESC.type) {
                        Double doubleValue = iprot.readDouble();
                        return doubleValue;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case FLAG: {
                    if (field.type == PropValueUnion.FLAG_FIELD_DESC.type) {
                        Boolean flag = iprot.readBool();
                        return flag;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case L_STRING: {
                    if (field.type == PropValueUnion.L_STRING_FIELD_DESC.type) {
                        TList _list0 = iprot.readListBegin();
                        ArrayList<String> lString = new ArrayList<String>(_list0.size);
                        for (int _i2 = 0; _i2 < _list0.size; ++_i2) {
                            String _elem1 = iprot.readString();
                            lString.add(_elem1);
                        }
                        iprot.readListEnd();
                        return lString;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case UNION_MSTRING_STRING: {
                    if (field.type == PropValueUnion.UNION_MSTRING_STRING_FIELD_DESC.type) {
                        TMap _map3 = iprot.readMapBegin();
                        HashMap<String, String> unionMStringString = new HashMap<String, String>(2 * _map3.size);
                        for (int _i6 = 0; _i6 < _map3.size; ++_i6) {
                            String _key4 = iprot.readString();
                            String _val5 = iprot.readString();
                            unionMStringString.put(_key4, _val5);
                        }
                        iprot.readMapEnd();
                        return unionMStringString;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
            }
            throw new IllegalStateException("setField wasn't null, but didn't match any of the case statements!");
        }
        TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
        return null;
    }

    protected void standardSchemeWriteValue(TProtocol oprot) throws TException {
        switch ((_Fields)this.setField_) {
            case INT_VALUE: {
                Integer intValue = (Integer)this.value_;
                oprot.writeI32(intValue.intValue());
                return;
            }
            case LONG_VALUE: {
                Long longValue = (Long)this.value_;
                oprot.writeI64(longValue.longValue());
                return;
            }
            case STRING_VALUE: {
                String stringValue = (String)this.value_;
                oprot.writeString(stringValue);
                return;
            }
            case DOUBLE_VALUE: {
                Double doubleValue = (Double)this.value_;
                oprot.writeDouble(doubleValue.doubleValue());
                return;
            }
            case FLAG: {
                Boolean flag = (Boolean)this.value_;
                oprot.writeBool(flag.booleanValue());
                return;
            }
            case L_STRING: {
                List lString = (List)this.value_;
                oprot.writeListBegin(new TList(11, lString.size()));
                for (String _iter7 : lString) {
                    oprot.writeString(_iter7);
                }
                oprot.writeListEnd();
                return;
            }
            case UNION_MSTRING_STRING: {
                Map unionMStringString = (Map)this.value_;
                oprot.writeMapBegin(new TMap(11, 11, unionMStringString.size()));
                for (Map.Entry _iter8 : unionMStringString.entrySet()) {
                    oprot.writeString((String)_iter8.getKey());
                    oprot.writeString((String)_iter8.getValue());
                }
                oprot.writeMapEnd();
                return;
            }
        }
        throw new IllegalStateException("Cannot write union with unknown field " + this.setField_);
    }

    protected Object tupleSchemeReadValue(TProtocol iprot, short fieldID) throws TException {
        _Fields setField = _Fields.findByThriftId(fieldID);
        if (setField != null) {
            switch (setField) {
                case INT_VALUE: {
                    Integer intValue = iprot.readI32();
                    return intValue;
                }
                case LONG_VALUE: {
                    Long longValue = iprot.readI64();
                    return longValue;
                }
                case STRING_VALUE: {
                    String stringValue = iprot.readString();
                    return stringValue;
                }
                case DOUBLE_VALUE: {
                    Double doubleValue = iprot.readDouble();
                    return doubleValue;
                }
                case FLAG: {
                    Boolean flag = iprot.readBool();
                    return flag;
                }
                case L_STRING: {
                    TList _list9 = iprot.readListBegin();
                    ArrayList<String> lString = new ArrayList<String>(_list9.size);
                    for (int _i11 = 0; _i11 < _list9.size; ++_i11) {
                        String _elem10 = iprot.readString();
                        lString.add(_elem10);
                    }
                    iprot.readListEnd();
                    return lString;
                }
                case UNION_MSTRING_STRING: {
                    TMap _map12 = iprot.readMapBegin();
                    HashMap<String, String> unionMStringString = new HashMap<String, String>(2 * _map12.size);
                    for (int _i15 = 0; _i15 < _map12.size; ++_i15) {
                        String _key13 = iprot.readString();
                        String _val14 = iprot.readString();
                        unionMStringString.put(_key13, _val14);
                    }
                    iprot.readMapEnd();
                    return unionMStringString;
                }
            }
            throw new IllegalStateException("setField wasn't null, but didn't match any of the case statements!");
        }
        throw new TProtocolException("Couldn't find a field with field id " + fieldID);
    }

    protected void tupleSchemeWriteValue(TProtocol oprot) throws TException {
        switch ((_Fields)this.setField_) {
            case INT_VALUE: {
                Integer intValue = (Integer)this.value_;
                oprot.writeI32(intValue.intValue());
                return;
            }
            case LONG_VALUE: {
                Long longValue = (Long)this.value_;
                oprot.writeI64(longValue.longValue());
                return;
            }
            case STRING_VALUE: {
                String stringValue = (String)this.value_;
                oprot.writeString(stringValue);
                return;
            }
            case DOUBLE_VALUE: {
                Double doubleValue = (Double)this.value_;
                oprot.writeDouble(doubleValue.doubleValue());
                return;
            }
            case FLAG: {
                Boolean flag = (Boolean)this.value_;
                oprot.writeBool(flag.booleanValue());
                return;
            }
            case L_STRING: {
                List lString = (List)this.value_;
                oprot.writeListBegin(new TList(11, lString.size()));
                for (String _iter16 : lString) {
                    oprot.writeString(_iter16);
                }
                oprot.writeListEnd();
                return;
            }
            case UNION_MSTRING_STRING: {
                Map unionMStringString = (Map)this.value_;
                oprot.writeMapBegin(new TMap(11, 11, unionMStringString.size()));
                for (Map.Entry _iter17 : unionMStringString.entrySet()) {
                    oprot.writeString((String)_iter17.getKey());
                    oprot.writeString((String)_iter17.getValue());
                }
                oprot.writeMapEnd();
                return;
            }
        }
        throw new IllegalStateException("Cannot write union with unknown field " + this.setField_);
    }

    protected TField getFieldDesc(_Fields setField) {
        switch (setField) {
            case INT_VALUE: {
                return INT_VALUE_FIELD_DESC;
            }
            case LONG_VALUE: {
                return LONG_VALUE_FIELD_DESC;
            }
            case STRING_VALUE: {
                return STRING_VALUE_FIELD_DESC;
            }
            case DOUBLE_VALUE: {
                return DOUBLE_VALUE_FIELD_DESC;
            }
            case FLAG: {
                return FLAG_FIELD_DESC;
            }
            case L_STRING: {
                return L_STRING_FIELD_DESC;
            }
            case UNION_MSTRING_STRING: {
                return UNION_MSTRING_STRING_FIELD_DESC;
            }
        }
        throw new IllegalArgumentException("Unknown field id " + (Object)((Object)setField));
    }

    protected TStruct getStructDesc() {
        return STRUCT_DESC;
    }

    protected _Fields enumForId(short id) {
        return _Fields.findByThriftIdOrThrow(id);
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public int getIntValue() {
        if (this.getSetField() == _Fields.INT_VALUE) {
            return (Integer)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'intValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setIntValue(int value) {
        this.setField_ = _Fields.INT_VALUE;
        this.value_ = value;
    }

    public long getLongValue() {
        if (this.getSetField() == _Fields.LONG_VALUE) {
            return (Long)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'longValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setLongValue(long value) {
        this.setField_ = _Fields.LONG_VALUE;
        this.value_ = value;
    }

    public String getStringValue() {
        if (this.getSetField() == _Fields.STRING_VALUE) {
            return (String)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'stringValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setStringValue(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = _Fields.STRING_VALUE;
        this.value_ = value;
    }

    public double getDoubleValue() {
        if (this.getSetField() == _Fields.DOUBLE_VALUE) {
            return (Double)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'doubleValue' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setDoubleValue(double value) {
        this.setField_ = _Fields.DOUBLE_VALUE;
        this.value_ = value;
    }

    public boolean getFlag() {
        if (this.getSetField() == _Fields.FLAG) {
            return (Boolean)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'flag' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setFlag(boolean value) {
        this.setField_ = _Fields.FLAG;
        this.value_ = value;
    }

    public List<String> getLString() {
        if (this.getSetField() == _Fields.L_STRING) {
            return (List)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'lString' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setLString(List<String> value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = _Fields.L_STRING;
        this.value_ = value;
    }

    public Map<String, String> getUnionMStringString() {
        if (this.getSetField() == _Fields.UNION_MSTRING_STRING) {
            return (Map)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'unionMStringString' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setUnionMStringString(Map<String, String> value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = _Fields.UNION_MSTRING_STRING;
        this.value_ = value;
    }

    public boolean isSetIntValue() {
        return this.setField_ == _Fields.INT_VALUE;
    }

    public boolean isSetLongValue() {
        return this.setField_ == _Fields.LONG_VALUE;
    }

    public boolean isSetStringValue() {
        return this.setField_ == _Fields.STRING_VALUE;
    }

    public boolean isSetDoubleValue() {
        return this.setField_ == _Fields.DOUBLE_VALUE;
    }

    public boolean isSetFlag() {
        return this.setField_ == _Fields.FLAG;
    }

    public boolean isSetLString() {
        return this.setField_ == _Fields.L_STRING;
    }

    public boolean isSetUnionMStringString() {
        return this.setField_ == _Fields.UNION_MSTRING_STRING;
    }

    public boolean equals(Object other) {
        if (other instanceof PropValueUnion) {
            return this.equals((PropValueUnion)((Object)other));
        }
        return false;
    }

    public boolean equals(PropValueUnion other) {
        return other != null && this.getSetField() == other.getSetField() && this.getFieldValue().equals(other.getFieldValue());
    }

    public int compareTo(PropValueUnion other) {
        int lastComparison = TBaseHelper.compareTo((Comparable)((Comparable)this.getSetField()), (Comparable)((Comparable)other.getSetField()));
        if (lastComparison == 0) {
            return TBaseHelper.compareTo((Object)this.getFieldValue(), (Object)other.getFieldValue());
        }
        return lastComparison;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(((Object)((Object)this)).getClass().getName());
        TFieldIdEnum setField = this.getSetField();
        if (setField != null) {
            list.add(setField.getThriftFieldId());
            Object value = this.getFieldValue();
            if (value instanceof TEnum) {
                list.add(((TEnum)this.getFieldValue()).getValue());
            } else {
                list.add(value);
            }
        }
        return list.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.INT_VALUE, new FieldMetaData("intValue", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.LONG_VALUE, new FieldMetaData("longValue", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.STRING_VALUE, new FieldMetaData("stringValue", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DOUBLE_VALUE, new FieldMetaData("doubleValue", 2, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.FLAG, new FieldMetaData("flag", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.L_STRING, new FieldMetaData("lString", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.UNION_MSTRING_STRING, new FieldMetaData("unionMStringString", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(PropValueUnion.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        INT_VALUE(1, "intValue"),
        LONG_VALUE(2, "longValue"),
        STRING_VALUE(3, "stringValue"),
        DOUBLE_VALUE(4, "doubleValue"),
        FLAG(5, "flag"),
        L_STRING(6, "lString"),
        UNION_MSTRING_STRING(7, "unionMStringString");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return INT_VALUE;
                }
                case 2: {
                    return LONG_VALUE;
                }
                case 3: {
                    return STRING_VALUE;
                }
                case 4: {
                    return DOUBLE_VALUE;
                }
                case 5: {
                    return FLAG;
                }
                case 6: {
                    return L_STRING;
                }
                case 7: {
                    return UNION_MSTRING_STRING;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

