/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.io;

import org.apache.hadoop.hive.common.type.HiveBaseChar;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.serde2.io.HiveBaseCharWritable;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hive.common.util.HiveStringUtils;

public class HiveCharWritable
extends HiveBaseCharWritable
implements WritableComparable<HiveCharWritable> {
    public HiveCharWritable() {
    }

    public HiveCharWritable(HiveChar hc) {
        this.set(hc);
    }

    public HiveCharWritable(HiveCharWritable hcw) {
        this.set(hcw);
    }

    public void set(HiveChar val) {
        this.set(val.getValue(), -1);
    }

    public void set(String val) {
        this.set(val, -1);
    }

    public void set(HiveCharWritable val) {
        this.value.set(val.value);
        this.charLength = -1;
    }

    public void set(HiveCharWritable val, int maxLength) {
        this.set(val.getHiveChar(), maxLength);
    }

    public void set(HiveChar val, int len) {
        this.set(val.getValue(), len);
    }

    public void set(String val, int maxLength) {
        this.value.set(HiveBaseChar.getPaddedValue(val, maxLength));
    }

    public HiveChar getHiveChar() {
        return new HiveChar(this.value.toString(), -1);
    }

    public void enforceMaxLength(int maxLength) {
        if (this.getCharacterLength() != maxLength) {
            this.set(this.getHiveChar(), maxLength);
        }
    }

    public Text getStrippedValue() {
        if (this.value.charAt(this.value.getLength() - 1) != 32) {
            return this.value;
        }
        return new Text(this.getHiveChar().getStrippedValue());
    }

    public Text getPaddedValue() {
        return this.getTextValue();
    }

    @Override
    public int getCharacterLength() {
        if (this.charLength != -1) {
            return this.charLength;
        }
        this.charLength = HiveStringUtils.getTextUtfLength(this.getStrippedValue());
        return this.charLength;
    }

    public int compareTo(HiveCharWritable rhs) {
        return this.getStrippedValue().compareTo((BinaryComparable)rhs.getStrippedValue());
    }

    @Override
    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (rhs == null || rhs.getClass() != this.getClass()) {
            return false;
        }
        return this.getStrippedValue().equals((Object)((HiveCharWritable)rhs).getStrippedValue());
    }

    @Override
    public int hashCode() {
        return this.getStrippedValue().hashCode();
    }

    public String toString() {
        return this.getPaddedValue().toString();
    }
}

