/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.SingleValueBoundaryScanner;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

class TimestampValueBoundaryScanner
extends SingleValueBoundaryScanner {
    public TimestampValueBoundaryScanner(BoundaryDef start, BoundaryDef end, OrderExpressionDef expressionDef, boolean nullsLast) {
        super(start, end, expressionDef, nullsLast);
    }

    @Override
    public boolean isDistanceGreater(Object v1, Object v2, int amt) {
        if (v1 != null && v2 != null) {
            long l2;
            long l1 = PrimitiveObjectInspectorUtils.getTimestamp(v1, (PrimitiveObjectInspector)this.expressionDef.getOI()).toEpochMilli();
            return (double)(l1 - (l2 = PrimitiveObjectInspectorUtils.getTimestamp(v2, (PrimitiveObjectInspector)this.expressionDef.getOI()).toEpochMilli())) / 1000.0 > (double)amt;
        }
        return v1 != null || v2 != null;
    }

    @Override
    public boolean isEqual(Object v1, Object v2) {
        if (v1 != null && v2 != null) {
            Timestamp l1 = PrimitiveObjectInspectorUtils.getTimestamp(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            Timestamp l2 = PrimitiveObjectInspectorUtils.getTimestamp(v2, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return l1.equals(l2);
        }
        return v1 == null && v2 == null;
    }
}

